/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags.ext;

import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagValueException;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class FlagBuilder<T> {
    private final Function<String, T> parser;
    private final Function<T, String> formatter;
    @Nullable
    private T defaultValue;
    private Predicate<T> constraint = Predicates.alwaysTrue();
    private final List<String> constraintDescriptions = new ArrayList<String>();

    public static <T> FlagBuilder<T> newBuilder(Function<String, ? extends T> parser, Function<? super T, String> formatter) {
        return new FlagBuilder<T>(parser, formatter);
    }

    public static <T> FlagBuilder<T> newBuilder(Function<String, ? extends T> parser) {
        return FlagBuilder.newBuilder(parser, v -> {
            throw new UnsupportedOperationException("Flag serialization not supported. If you require serialization support, use FlagBuilder.newBuilder(Converter) or FlagBuilder.newBuilder(Function, Function) instead.");
        });
    }

    public static <T> FlagBuilder<T> newBuilder(Converter<String, T> converter) {
        return FlagBuilder.newBuilder(converter, converter.reverse());
    }

    @CanIgnoreReturnValue
    public FlagBuilder<T> withDefaultValue(@Nullable T defaultValue) {
        this.defaultValue = defaultValue;
        this.checkCurrentConstraints();
        return this;
    }

    @CanIgnoreReturnValue
    public FlagBuilder<T> addConstraint(Predicate<? super T> constraint) {
        return this.addConstraint(constraint, "unknown constraint: " + constraint);
    }

    @CanIgnoreReturnValue
    public FlagBuilder<T> addConstraint(Predicate<? super T> constraint, String description) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(description), "Must give a valid description.");
        this.constraint = Predicates.and(this.constraint, Preconditions.checkNotNull(constraint));
        this.constraintDescriptions.add(description);
        this.checkCurrentConstraints();
        return this;
    }

    public Flag<T> build() {
        try {
            return new BuiltFlag(this);
        }
        catch (InvalidFlagValueException e) {
            throw new IllegalStateException(e);
        }
    }

    private void checkCurrentConstraints() {
        Preconditions.checkArgument(this.defaultValue == null || this.constraint.apply(this.defaultValue), "Flag default value (%s) violates one or more constraints: %s", this.defaultValue, this.constraintDescriptions);
    }

    private FlagBuilder(Function<String, ? extends T> parser, Function<? super T, String> formatter) {
        this.parser = Preconditions.checkNotNull(parser);
        this.formatter = Preconditions.checkNotNull(formatter);
    }

    private static class BuiltFlag<T>
    extends Flag<T> {
        private final Function<String, T> parser;
        private final Function<T, String> formatter;
        private final Predicate<T> constraint;
        private final ImmutableList<String> constraintDescriptions;

        public BuiltFlag(FlagBuilder<T> builder) throws InvalidFlagValueException {
            super(((FlagBuilder)builder).defaultValue);
            this.parser = Preconditions.checkNotNull(((FlagBuilder)builder).parser);
            this.formatter = Preconditions.checkNotNull(((FlagBuilder)builder).formatter);
            this.constraint = Preconditions.checkNotNull(((FlagBuilder)builder).constraint);
            this.constraintDescriptions = ImmutableList.copyOf(((FlagBuilder)builder).constraintDescriptions);
            if (((FlagBuilder)builder).defaultValue != null) {
                this.checkConstraint(((FlagBuilder)builder).defaultValue);
            }
        }

        @Override
        protected T parse(String text) throws InvalidFlagValueException {
            try {
                return this.checkConstraint(this.parser.apply(text));
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof InvalidFlagValueException) {
                    throw (InvalidFlagValueException)e.getCause();
                }
                throw new InvalidFlagValueException(e.getMessage(), e);
            }
        }

        @Override
        protected String parsableStringValue(T value) {
            return this.formatter.apply(value);
        }

        @CanIgnoreReturnValue
        private T checkConstraint(T value) throws InvalidFlagValueException {
            if (!this.constraint.apply(value)) {
                throw new InvalidFlagValueException(String.format("Flag value (%s) violates one or more constraints: %s", value, this.constraintDescriptions));
            }
            return value;
        }
    }
}

