/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.html.types;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.html.types.BuilderUtils;
import com.google.appengine.repackaged.com.google.common.html.types.SafeHtml;
import com.google.appengine.repackaged.com.google.common.html.types.SafeHtmlBuilder;
import com.google.appengine.repackaged.com.google.common.html.types.SafeHtmlProto;
import com.google.appengine.repackaged.com.google.common.html.types.SafeScript;
import com.google.appengine.repackaged.com.google.common.html.types.SafeStyleSheet;
import com.google.appengine.repackaged.com.google.common.html.types.TrustedResourceUrl;
import com.google.appengine.repackaged.com.google.common.io.Resources;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CompileTimeConstant;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;

@CheckReturnValue
@GwtCompatible(emulated=true)
public final class SafeHtmls {
    public static SafeHtml createElement(@CompileTimeConstant String elementName, String content) {
        return new SafeHtmlBuilder(elementName).escapeAndAppendContent(content).build();
    }

    public static SafeHtml createElement(@CompileTimeConstant String elementName, Iterable<SafeHtml> htmls) {
        return new SafeHtmlBuilder(elementName).appendContent(htmls).build();
    }

    public static SafeHtml createElement(@CompileTimeConstant String elementName, SafeHtml ... htmls) {
        SafeHtmlBuilder builder = new SafeHtmlBuilder(elementName);
        if (htmls.length != 0) {
            builder.appendContent(htmls);
        }
        return builder.build();
    }

    @GwtIncompatible(value="Resources")
    public static SafeHtml fromResource(@CompileTimeConstant String resourceName) throws IOException {
        return SafeHtmls.create(Resources.toString(Resources.getResource(resourceName), Charset.forName("UTF-8")));
    }

    @GwtIncompatible(value="Resources")
    public static SafeHtml fromResource(Class<?> contextClass, @CompileTimeConstant String resourceName) throws IOException {
        return SafeHtmls.create(Resources.toString(Resources.getResource(contextClass, resourceName), Charset.forName("UTF-8")));
    }

    public static SafeHtml fromProto(SafeHtmlProto proto) {
        return SafeHtmls.create(proto.getPrivateDoNotAccessOrElseSafeHtmlWrappedValue());
    }

    public static SafeHtml fromScript(SafeScript script) {
        return SafeHtmls.create("<script type=\"text/javascript\">" + script.getSafeScriptString() + "</script>");
    }

    public static SafeHtml fromScriptForTypeApplicationLdJson(SafeScript script) {
        return SafeHtmls.create("<script type=\"application/ld+json\">" + script.getSafeScriptString() + "</script>");
    }

    public static SafeHtml fromScriptWithCspNonce(SafeScript script, String cspNonce) {
        return SafeHtmls.create("<script type=\"text/javascript\" nonce=\"" + SafeHtmls.htmlEscapeInternal(cspNonce) + "\">" + script.getSafeScriptString() + "</script>");
    }

    public static SafeHtml fromScriptUrl(TrustedResourceUrl trustedResourceUrl) {
        String escapedUrl = SafeHtmls.htmlEscapeInternal(trustedResourceUrl.getTrustedResourceUrlString());
        return SafeHtmls.create("<script type=\"text/javascript\" src=\"" + escapedUrl + "\"></script>");
    }

    public static SafeHtml fromScriptUrlDeferred(TrustedResourceUrl trustedResourceUrl) {
        String escapedUrl = SafeHtmls.htmlEscapeInternal(trustedResourceUrl.getTrustedResourceUrlString());
        return SafeHtmls.create("<script defer type=\"text/javascript\" src=\"" + escapedUrl + "\"></script>");
    }

    public static SafeHtml fromScriptUrlWithCspNonce(TrustedResourceUrl trustedResourceUrl, String cspNonce) {
        String escapedUrl = SafeHtmls.htmlEscapeInternal(trustedResourceUrl.getTrustedResourceUrlString());
        return SafeHtmls.create("<script type=\"text/javascript\" nonce=\"" + SafeHtmls.htmlEscapeInternal(cspNonce) + "\" src=\"" + escapedUrl + "\"></script>");
    }

    public static SafeHtml fromScriptUrlWithCspNonceDeferred(TrustedResourceUrl trustedResourceUrl, String cspNonce) {
        String escapedUrl = SafeHtmls.htmlEscapeInternal(trustedResourceUrl.getTrustedResourceUrlString());
        return SafeHtmls.create("<script defer type=\"text/javascript\" nonce=\"" + SafeHtmls.htmlEscapeInternal(cspNonce) + "\" src=\"" + escapedUrl + "\"></script>");
    }

    public static SafeHtml fromStyleSheet(SafeStyleSheet safeStyleSheet) {
        Preconditions.checkArgument(!safeStyleSheet.getSafeStyleSheetString().contains("<"));
        return SafeHtmls.create("<style type=\"text/css\">" + safeStyleSheet.getSafeStyleSheetString() + "</style>");
    }

    public static SafeHtml fromStyleUrl(TrustedResourceUrl trustedResourceUrl) {
        String escapedUrl = SafeHtmls.htmlEscapeInternal(trustedResourceUrl.getTrustedResourceUrlString());
        return SafeHtmls.create("<link rel=\"stylesheet\" href=\"" + escapedUrl + "\">");
    }

    public static SafeHtmlProto toProto(SafeHtml safeHtml) {
        return SafeHtmlProto.newBuilder().setPrivateDoNotAccessOrElseSafeHtmlWrappedValue(safeHtml.getSafeHtmlString()).build();
    }

    public static SafeHtml htmlEscape(String text) {
        return SafeHtmls.create(SafeHtmls.htmlEscapeInternal(text));
    }

    public static SafeHtml htmlEscapePreservingNewlines(String text) {
        return SafeHtmls.create(SafeHtmls.htmlEscapeInternal(text).replaceAll("\r?\n|\r", "<br>"));
    }

    public static SafeHtml htmlEscapePreservingWhitespace(String text) {
        String html = SafeHtmls.htmlEscapeInternal(text).replaceAll("(^|[\r\n\t ]) ", "$1&#160;").replaceAll("\r?\n|\r", "<br>").replaceAll("(\t+)", "<span style=\"white-space:pre\">$1</span>");
        return SafeHtmls.create(html);
    }

    public static SafeHtml comment(String text) {
        return SafeHtmls.create("<!--" + SafeHtmls.htmlEscapeInternal(text) + "-->");
    }

    public static SafeHtml html5Doctype() {
        return SafeHtmls.create("<!DOCTYPE html>");
    }

    public static SafeHtml concat(SafeHtml ... htmls) {
        return SafeHtmls.concat(Arrays.asList(htmls));
    }

    public static SafeHtml concat(Iterable<SafeHtml> htmls) {
        int concatLength = 0;
        for (SafeHtml html : htmls) {
            concatLength += html.getSafeHtmlString().length();
        }
        StringBuilder result = new StringBuilder(concatLength);
        for (SafeHtml html : htmls) {
            result.append(html.getSafeHtmlString());
        }
        return SafeHtmls.create(result.toString());
    }

    static SafeHtml create(String html) {
        return new SafeHtml(html);
    }

    private static String htmlEscapeInternal(String text) {
        return BuilderUtils.escapeHtmlInternal(BuilderUtils.coerceToInterchangeValid(text));
    }

    private SafeHtmls() {
    }
}

