/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.time;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.annotations.PreferKotlinApi;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.DiscreteDomain;
import com.google.appengine.repackaged.com.google.common.math.DoubleMath;
import com.google.appengine.repackaged.com.google.common.math.LongMath;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.InlineMe;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.jspecify.nullness.Nullable;

@GwtIncompatible
public final class Durations {
    static final Duration MIN = Duration.ofSeconds(Long.MIN_VALUE);
    private static final double MIN_SECONDS = MIN.getSeconds();
    public static final Duration MAX = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
    private static final double MAX_SECONDS = 9.223372036854776E18;
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final int NANOS_PER_MICRO = 1000;
    private static final int MICROS_PER_SECOND = 1000000;
    private static final int NANOS_POWER_OF_TEN = 9;
    private static final Duration SATURATED_MAX_MILLIS = Duration.ofMillis(Long.MAX_VALUE);
    private static final Duration SATURATED_MIN_MILLIS = Duration.ofMillis(Long.MIN_VALUE);
    private static final Duration SATURATED_MAX_MICROS = Durations.ofMicros(Long.MAX_VALUE);
    private static final Duration SATURATED_MIN_MICROS = Durations.ofMicros(Long.MIN_VALUE);
    private static final Duration SATURATED_MAX_NANOS = Duration.ofNanos(Long.MAX_VALUE);
    private static final Duration SATURATED_MIN_NANOS = Duration.ofNanos(Long.MIN_VALUE);

    private Durations() {
    }

    public static Duration multiplyChecked(Duration duration, double c) {
        if (Double.isNaN(c)) {
            throw new ArithmeticException("Cannot multiply a duration by NaN");
        }
        if (Double.isInfinite(c)) {
            throw new ArithmeticException("result does not fit into the range of a Duration");
        }
        return Durations.ofSecondsChecked(Durations.toSecondsAsBigDecimal(duration).multiply(new BigDecimal(c)));
    }

    @PreferKotlinApi(replacement="duration.toSecondsAsDouble()", imports={"com.google.appengine.repackaged.com.google.common.time.toSecondsAsDouble"})
    public static double toSecondsAsDouble(Duration duration) {
        return (double)duration.getSeconds() + (double)duration.getNano() / 1.0E9;
    }

    private static BigDecimal toSecondsAsBigDecimal(Duration duration) {
        return BigDecimal.valueOf(duration.getSeconds()).add(BigDecimal.valueOf(duration.getNano(), 9));
    }

    public static Duration ofSeconds(double seconds) {
        if (seconds >= 9.223372036854776E18) {
            return MAX;
        }
        if (seconds <= MIN_SECONDS) {
            return MIN;
        }
        long wholeSeconds = DoubleMath.roundToLong(seconds, RoundingMode.FLOOR);
        long nanos = DoubleMath.roundToLong((seconds - (double)wholeSeconds) * 1.0E9, RoundingMode.FLOOR);
        return Duration.ofSeconds(wholeSeconds, nanos);
    }

    private static Duration ofSecondsChecked(BigDecimal seconds) {
        if (seconds.compareTo(BigDecimal.valueOf(9.223372036854776E18)) >= 0 || seconds.compareTo(BigDecimal.valueOf(MIN_SECONDS)) <= 0) {
            throw new ArithmeticException("result does not fit into the range of a Duration");
        }
        long wholeSeconds = seconds.longValue();
        long nanos = seconds.subtract(BigDecimal.valueOf(wholeSeconds)).setScale(9, RoundingMode.HALF_EVEN).unscaledValue().longValue();
        return Duration.ofSeconds(wholeSeconds, nanos);
    }

    @Deprecated
    @InlineMe(replacement="Duration.ofSeconds(seconds)", imports={"java.time.Duration"})
    @PreferKotlinApi(replacement="seconds.seconds", imports={"com.google.appengine.repackaged.com.google.common.time.kotlin.seconds"})
    public static Duration ofSeconds(long seconds) {
        return Duration.ofSeconds(seconds);
    }

    @PreferKotlinApi(replacement="duration.toMillisSaturated()", imports={"com.google.appengine.repackaged.com.google.common.time.toMillisSaturated"})
    public static long toMillisSaturated(Duration duration) {
        if (duration.compareTo(SATURATED_MAX_MILLIS) >= 0) {
            return Long.MAX_VALUE;
        }
        if (duration.compareTo(SATURATED_MIN_MILLIS) <= 0) {
            return Long.MIN_VALUE;
        }
        try {
            return duration.toMillis();
        }
        catch (ArithmeticException tooBig) {
            return duration.isNegative() ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
    }

    @PreferKotlinApi(replacement="duration.toMicros()", imports={"com.google.appengine.repackaged.com.google.common.time.toMicros"})
    public static long toMicros(Duration duration) {
        if (duration.getSeconds() < -9223372036854L) {
            return LongMath.checkedAdd(LongMath.checkedMultiply(duration.getSeconds() + 1L, 1000000L), duration.getNano() / 1000 - 1000000);
        }
        long micros = LongMath.checkedMultiply(duration.getSeconds(), 1000000L);
        return LongMath.checkedAdd(micros, duration.getNano() / 1000);
    }

    @PreferKotlinApi(replacement="duration.toMicrosSaturated()", imports={"com.google.appengine.repackaged.com.google.common.time.toMicrosSaturated"})
    public static long toMicrosSaturated(Duration duration) {
        if (duration.compareTo(SATURATED_MAX_MICROS) >= 0) {
            return Long.MAX_VALUE;
        }
        if (duration.compareTo(SATURATED_MIN_MICROS) <= 0) {
            return Long.MIN_VALUE;
        }
        try {
            return Durations.toMicros(duration);
        }
        catch (ArithmeticException tooBig) {
            return duration.isNegative() ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
    }

    @PreferKotlinApi(replacement="micros.micros", imports={"com.google.appengine.repackaged.com.google.common.time.kotlin.micros"})
    public static Duration ofMicros(long micros) {
        return Duration.of(micros, ChronoUnit.MICROS);
    }

    @PreferKotlinApi(replacement="duration.toNanosSaturated()", imports={"com.google.appengine.repackaged.com.google.common.time.toNanosSaturated"})
    public static long toNanosSaturated(Duration duration) {
        if (duration.compareTo(SATURATED_MAX_NANOS) >= 0) {
            return Long.MAX_VALUE;
        }
        if (duration.compareTo(SATURATED_MIN_NANOS) <= 0) {
            return Long.MIN_VALUE;
        }
        try {
            return duration.toNanos();
        }
        catch (ArithmeticException tooBig) {
            return duration.isNegative() ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
    }

    public static Duration of(long value, TimeUnit timeUnit) {
        return Duration.of(value, Durations.convertTimeUnitToChronoUnit(timeUnit));
    }

    private static ChronoUnit convertTimeUnitToChronoUnit(TimeUnit timeUnit) {
        Preconditions.checkNotNull(timeUnit, "timeUnit");
        switch (timeUnit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError((Object)"Unknown TimeUnit enum constant");
    }

    @CanIgnoreReturnValue
    public static Duration checkNotNegative(Duration duration) {
        Preconditions.checkArgument(!duration.isNegative(), "duration (%s) must not be negative", (Object)duration);
        return duration;
    }

    @CanIgnoreReturnValue
    public static Duration checkPositive(Duration duration) {
        Preconditions.checkArgument(Durations.isPositive(duration), "duration (%s) must be positive", (Object)duration);
        return duration;
    }

    @PreferKotlinApi(replacement="duration.isPositive()", imports={"com.google.appengine.repackaged.com.google.common.time.isPositive"})
    public static boolean isPositive(Duration duration) {
        return !duration.isNegative() && !duration.isZero();
    }

    public static DiscreteDomain<Duration> domain() {
        return DurationDomain.INSTANCE;
    }

    private static final class DurationDomain
    extends DiscreteDomain<Duration> {
        private static final DurationDomain INSTANCE = new DurationDomain();

        private DurationDomain() {
        }

        @Override
        public Duration minValue() {
            return MIN;
        }

        @Override
        public Duration maxValue() {
            return MAX;
        }

        @Override
        public @Nullable Duration next(Duration value) {
            return value.equals(this.maxValue()) ? null : value.plusNanos(1L);
        }

        @Override
        public @Nullable Duration previous(Duration value) {
            return value.equals(this.minValue()) ? null : value.minusNanos(1L);
        }

        @Override
        public long distance(Duration start, Duration end) {
            long seconds = LongMath.saturatedSubtract(end.getSeconds(), start.getSeconds());
            long nanos = LongMath.saturatedMultiply(seconds, 1000000000L);
            return LongMath.saturatedAdd(nanos, end.getNano() - start.getNano());
        }

        public String toString() {
            return "Durations.domain()";
        }
    }
}

