/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1.client;

import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.common.hash.HashCode;
import com.google.appengine.repackaged.com.google.common.hash.Hasher;
import com.google.appengine.repackaged.com.google.common.hash.Hashing;

class EndToEndChecksumHandler {
    static final String HTTP_REQUEST_CHECKSUM_HEADER = "x-request-checksum-348659783";
    static final String HTTP_RESPONSE_CHECKSUM_HEADER = "x-response-checksum-348659783";
    final Hasher hasher = EndToEndChecksumHandler.getNewCrc32cHasher();

    EndToEndChecksumHandler() {
    }

    static String computeChecksum(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        HashCode hc = EndToEndChecksumHandler.getNewCrc32cHasher().putBytes(bytes).hash();
        return hc.toString();
    }

    private static Hasher getNewCrc32cHasher() {
        return Hashing.crc32c().newHasher();
    }

    static boolean validateChecksum(String checksum, byte[] bytes) {
        return checksum != null && !checksum.isEmpty() && bytes != null && bytes.length > 0 && checksum.equalsIgnoreCase(EndToEndChecksumHandler.computeChecksum(bytes));
    }

    static boolean hasChecksumHeader(HttpResponse response) {
        String checksum = EndToEndChecksumHandler.getChecksumHeader(response);
        return checksum != null && !checksum.isEmpty();
    }

    static String getChecksumHeader(HttpResponse response) {
        return response.getHeaders().getFirstHeaderStringValue(HTTP_RESPONSE_CHECKSUM_HEADER);
    }

    void update(byte[] bytes, int off, int len) {
        this.hasher.putBytes(bytes, off, len);
    }

    String hash() {
        return this.hasher.hash().toString();
    }
}

