/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.index;

import com.google.appengine.repackaged.org.apache.lucene.index.DefaultSkipListWriter;
import com.google.appengine.repackaged.org.apache.lucene.index.FieldInfo;
import com.google.appengine.repackaged.org.apache.lucene.index.FieldInfos;
import com.google.appengine.repackaged.org.apache.lucene.index.FormatPostingsFieldsConsumer;
import com.google.appengine.repackaged.org.apache.lucene.index.FormatPostingsTermsConsumer;
import com.google.appengine.repackaged.org.apache.lucene.index.FormatPostingsTermsWriter;
import com.google.appengine.repackaged.org.apache.lucene.index.SegmentWriteState;
import com.google.appengine.repackaged.org.apache.lucene.index.TermInfosWriter;
import com.google.appengine.repackaged.org.apache.lucene.store.Directory;
import java.io.IOException;

final class FormatPostingsFieldsWriter
extends FormatPostingsFieldsConsumer {
    final Directory dir;
    final String segment;
    final TermInfosWriter termsOut;
    final FieldInfos fieldInfos;
    final FormatPostingsTermsWriter termsWriter;
    final DefaultSkipListWriter skipListWriter;
    final int totalNumDocs;

    public FormatPostingsFieldsWriter(SegmentWriteState state, FieldInfos fieldInfos) throws IOException {
        this.dir = state.directory;
        this.segment = state.segmentName;
        this.totalNumDocs = state.numDocs;
        this.fieldInfos = fieldInfos;
        this.termsOut = new TermInfosWriter(this.dir, this.segment, fieldInfos, state.termIndexInterval);
        this.skipListWriter = new DefaultSkipListWriter(this.termsOut.skipInterval, this.termsOut.maxSkipLevels, this.totalNumDocs, null, null);
        state.flushedFiles.add(state.segmentFileName("tis"));
        state.flushedFiles.add(state.segmentFileName("tii"));
        this.termsWriter = new FormatPostingsTermsWriter(state, this);
    }

    FormatPostingsTermsConsumer addField(FieldInfo field) {
        this.termsWriter.setField(field);
        return this.termsWriter;
    }

    void finish() throws IOException {
        this.termsOut.close();
        this.termsWriter.close();
    }
}

