/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.capabilities.Capability;
import com.google.appengine.api.capabilities.CapabilityStatus;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LocalCapabilitiesEnvironment {
    private static final String KEY_DELIMITER = ".";
    public static final String KEY_PREFIX = "capability.status.";
    public static final ImmutableSet<String> DATASTORE_WRITE_RPCS = new ImmutableSet.Builder().add((Object)"Delete").add((Object)"Put").add((Object)"Touch").add((Object)"Commit").add((Object)"CreateIndex").add((Object)"UpdateIndex").add((Object)"DeleteIndex").add((Object)"AddActions").add((Object)"AllocateIds").build();
    public static final ImmutableList<Capability> DEFAULT_ENABLED_SERVICES = ImmutableList.of((Object)Capability.BLOBSTORE, (Object)Capability.DATASTORE, (Object)Capability.DATASTORE_WRITE, (Object)Capability.IMAGES, (Object)Capability.MAIL, (Object)Capability.MEMCACHE, (Object)Capability.TASKQUEUE, (Object)Capability.URL_FETCH, (Object)Capability.XMPP);
    Map<String, CapabilityStatus> capabilitiesStatus = Collections.synchronizedMap(new HashMap());

    public LocalCapabilitiesEnvironment(Properties properties) {
        for (Capability capability : DEFAULT_ENABLED_SERVICES) {
            this.capabilitiesStatus.put(LocalCapabilitiesEnvironment.geCapabilityPropertyKey(capability.getPackageName(), capability.getName()), CapabilityStatus.ENABLED);
        }
        for (String capabilityName : properties.stringPropertyNames()) {
            if (!capabilityName.startsWith(KEY_PREFIX)) continue;
            String status = properties.getProperty(capabilityName);
            CapabilityStatus s = CapabilityStatus.valueOf((String)status);
            this.capabilitiesStatus.put(capabilityName, s);
        }
    }

    public static String geCapabilityPropertyKey(String packageName, String capability) {
        return KEY_PREFIX + packageName + KEY_DELIMITER + capability;
    }

    public void setCapabilitiesStatus(String capabilityName, CapabilityStatus status) {
        if (!capabilityName.startsWith(KEY_PREFIX)) {
            return;
        }
        if (status == null) {
            throw new IllegalArgumentException("Capability Status:  is not known");
        }
        this.capabilitiesStatus.put(capabilityName, status);
    }

    public CapabilityStatus getStatusFromMethodName(String capabilityName, String methodName) {
        CapabilityStatus status;
        if (capabilityName.equals("datastore_v3") && (status = this.capabilitiesStatus.get(LocalCapabilitiesEnvironment.geCapabilityPropertyKey(capabilityName, "write"))) != null && !status.equals((Object)CapabilityStatus.ENABLED) && DATASTORE_WRITE_RPCS.contains((Object)methodName)) {
            return status;
        }
        status = this.capabilitiesStatus.get(LocalCapabilitiesEnvironment.geCapabilityPropertyKey(capabilityName, "*"));
        if (status != null) {
            return status;
        }
        return CapabilityStatus.ENABLED;
    }

    public CapabilityStatus getStatusFromCapabilityName(String packageName, String capabilityName) {
        CapabilityStatus status = this.capabilitiesStatus.get(LocalCapabilitiesEnvironment.geCapabilityPropertyKey(packageName, capabilityName));
        return status != null ? status : CapabilityStatus.UNKNOWN;
    }
}

