/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.MoreElements;
import com.google.auto.factory.AutoFactory;
import com.google.auto.factory.Provided;
import com.google.auto.factory.processor.AutoFactoryDeclaration;
import com.google.auto.factory.processor.Elements2;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.InjectApi;
import com.google.auto.factory.processor.Mirrors;
import com.google.auto.factory.processor.Parameter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class FactoryDescriptorGenerator {
    private final Messager messager;
    private final Types types;
    private final AutoFactoryDeclaration.Factory declarationFactory;
    private final InjectApi injectApi;

    FactoryDescriptorGenerator(Messager messager, Types types, AutoFactoryDeclaration.Factory declarationFactory, InjectApi injectApi) {
        this.messager = messager;
        this.types = types;
        this.declarationFactory = declarationFactory;
        this.injectApi = injectApi;
    }

    ImmutableSet<FactoryMethodDescriptor> generateDescriptor(Element element) {
        final AnnotationMirror mirror = Mirrors.getAnnotationMirror(element, AutoFactory.class).get();
        final Optional<AutoFactoryDeclaration> declaration = this.declarationFactory.createIfValid(element);
        if (!declaration.isPresent()) {
            return ImmutableSet.of();
        }
        return element.accept(new ElementKindVisitor6<ImmutableSet<FactoryMethodDescriptor>, Void>(){

            @Override
            protected ImmutableSet<FactoryMethodDescriptor> defaultAction(Element e, Void p) {
                throw new AssertionError((Object)"@AutoFactory applied to an impossible element");
            }

            @Override
            public ImmutableSet<FactoryMethodDescriptor> visitTypeAsClass(TypeElement type, Void p) {
                if (type.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    FactoryDescriptorGenerator.this.messager.printMessage(Diagnostic.Kind.ERROR, "Auto-factory doesn't support being applied to abstract classes.", type, mirror);
                    return ImmutableSet.of();
                }
                ImmutableSet<ExecutableElement> constructors = Elements2.getConstructors(type);
                if (constructors.isEmpty()) {
                    return FactoryDescriptorGenerator.this.generateDescriptorForDefaultConstructor((AutoFactoryDeclaration)declaration.get(), type);
                }
                return FluentIterable.from(constructors).transform((Function)new Function<ExecutableElement, FactoryMethodDescriptor>(){

                    public FactoryMethodDescriptor apply(ExecutableElement constructor) {
                        return FactoryDescriptorGenerator.this.generateDescriptorForConstructor((AutoFactoryDeclaration)declaration.get(), constructor);
                    }
                }).toSet();
            }

            @Override
            public ImmutableSet<FactoryMethodDescriptor> visitTypeAsInterface(TypeElement type, Void p) {
                FactoryDescriptorGenerator.this.messager.printMessage(Diagnostic.Kind.ERROR, "Auto-factory doesn't support being applied to interfaces.", type, mirror);
                return ImmutableSet.of();
            }

            @Override
            public ImmutableSet<FactoryMethodDescriptor> visitExecutableAsConstructor(ExecutableElement e, Void p) {
                return ImmutableSet.of((Object)FactoryDescriptorGenerator.this.generateDescriptorForConstructor((AutoFactoryDeclaration)declaration.get(), e));
            }
        }, null);
    }

    FactoryMethodDescriptor generateDescriptorForConstructor(AutoFactoryDeclaration declaration, ExecutableElement constructor) {
        Preconditions.checkNotNull((Object)constructor);
        Preconditions.checkArgument((constructor.getKind() == ElementKind.CONSTRUCTOR ? 1 : 0) != 0);
        TypeElement classElement = MoreElements.asType((Element)constructor.getEnclosingElement());
        Map<Boolean, List<VariableElement>> parameterMap = constructor.getParameters().stream().collect(Collectors.partitioningBy(parameter -> MoreElements.isAnnotationPresent((Element)parameter, Provided.class)));
        ImmutableSet<Parameter> providedParameters = Parameter.forParameterList(Objects.requireNonNull(parameterMap.get(true)), this.types, this.injectApi);
        ImmutableSet<Parameter> passedParameters = Parameter.forParameterList(Objects.requireNonNull(parameterMap.get(false)), this.types, this.injectApi);
        return FactoryMethodDescriptor.builder(declaration).name("create").returnType(classElement.asType()).publicMethod(classElement.getModifiers().contains((Object)Modifier.PUBLIC)).providedParameters((Iterable<Parameter>)providedParameters).passedParameters((Iterable<Parameter>)passedParameters).creationParameters((Iterable<Parameter>)Parameter.forParameterList(constructor.getParameters(), this.types, this.injectApi)).isVarArgs(constructor.isVarArgs()).exceptions(constructor.getThrownTypes()).overridingMethod(false).build();
    }

    private ImmutableSet<FactoryMethodDescriptor> generateDescriptorForDefaultConstructor(AutoFactoryDeclaration declaration, TypeElement type) {
        return ImmutableSet.of((Object)FactoryMethodDescriptor.builder(declaration).name("create").returnType(type.asType()).publicMethod(type.getModifiers().contains((Object)Modifier.PUBLIC)).providedParameters((Iterable<Parameter>)ImmutableSet.of()).passedParameters((Iterable<Parameter>)ImmutableSet.of()).creationParameters((Iterable<Parameter>)ImmutableSet.of()).isVarArgs(false).exceptions((Iterable<? extends TypeMirror>)ImmutableSet.of()).overridingMethod(false).build());
    }
}

