/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class AbstractMethodLister {
    private final InputStream inputStream;

    AbstractMethodLister(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    List<String> abstractNoArgMethods() {
        try {
            return this.abstractNoArgMethodsX();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> abstractNoArgMethodsX() throws IOException {
        ClassReader classReader = new ClassReader(this.inputStream);
        RecordingClassVisitor classVisitor = new RecordingClassVisitor();
        classReader.accept((ClassVisitor)classVisitor, 0);
        return classVisitor.abstractNoArgMethods;
    }

    private static class RecordingClassVisitor
    extends ClassVisitor {
        private final List<String> abstractNoArgMethods = new ArrayList<String>();

        RecordingClassVisitor() {
            super(262144);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (Modifier.isAbstract(access) && desc.contains("()") && !desc.endsWith("V")) {
                this.abstractNoArgMethods.add(name);
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

