/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Template {
    private final String template;
    private final Node rootNode;
    private static final Pattern varRefPattern = Pattern.compile("\\p{javaJavaIdentifierPart}+(\\.\\p{javaJavaIdentifierPart}+)*");
    private static final Pattern entireLineCommentPattern = Pattern.compile("^\\s*#.*$\n", 8);
    private static final Pattern midLineCommentPattern = Pattern.compile("#.*$", 8);
    private static final int EXCERPT_LENGTH = 40;

    private Template(String template) {
        this.template = Template.stripComments(template);
        this.rootNode = Template.parse(this.template, 0, this.template.length());
    }

    static Template compile(String template) {
        return new Template(template);
    }

    String rewrite(Map<String, ?> vars) {
        StringBuilder sb = new StringBuilder();
        this.rootNode.appendTo(sb, this, vars);
        return sb.toString();
    }

    private static Node parse(String template, int start, int stop) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        int index = start;
        while (index < stop) {
            int endLiteral;
            int dollar = Template.indexOf(template, "$[", index, stop);
            int n = endLiteral = dollar < 0 ? stop : dollar;
            if (endLiteral > index) {
                nodes.add(new LiteralNode(index, template.substring(index, endLiteral)));
                index = endLiteral;
            }
            if (dollar < 0) continue;
            int closeSquare = Template.matchingCloseSquare(template, dollar);
            nodes.add(Template.parseDollar(template, dollar, closeSquare));
            index = closeSquare + 1;
        }
        assert (index == stop);
        return new CompoundNode(start, nodes);
    }

    private static Node parseDollar(String template, int dollar, int closeSquare) {
        VarRefNode node;
        assert (template.startsWith("$[", dollar));
        assert (template.charAt(closeSquare) == ']');
        int afterOpen = dollar + "$[".length();
        int i = Template.scanVarRef(template, afterOpen, closeSquare);
        String varRef = template.substring(afterOpen, i);
        char c = template.charAt(i);
        switch (c) {
            case ']': {
                node = new VarNode(i, varRef);
                break;
            }
            case '!': 
            case '?': {
                node = Template.parseConditional(template, dollar, varRef, c, i + 1, closeSquare);
                break;
            }
            case ':': {
                node = Template.parseIteration(template, dollar, varRef, i + 1, closeSquare);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected character after variable name at " + Template.excerpt(template, dollar));
            }
        }
        return node;
    }

    private static ConditionalNode parseConditional(String template, int dollar, String varRef, char queryOrBang, int afterQueryOrBang, int stop) {
        Node[] nodes;
        Node secondNode;
        Node firstNode;
        assert (template.charAt(stop) == ']');
        if (template.charAt(afterQueryOrBang) == '[') {
            int endFirstPart = Template.matchingCloseSquare(template, afterQueryOrBang);
            if (template.charAt(endFirstPart + 1) != '[' || Template.matchingCloseSquare(template, endFirstPart + 1) != stop - 1) {
                throw new IllegalArgumentException("Could not scan [firstPart][secondPart] at " + Template.excerpt(template, afterQueryOrBang + 1));
            }
            firstNode = Template.parse(template, afterQueryOrBang + 1, endFirstPart);
            secondNode = Template.parse(template, endFirstPart + 2, stop - 1);
        } else {
            firstNode = Template.parse(template, afterQueryOrBang, stop);
            secondNode = new LiteralNode(stop, "");
        }
        if (queryOrBang == '?') {
            nodes = new Node[]{secondNode, firstNode};
        } else {
            assert (queryOrBang == '!');
            nodes = new Node[]{firstNode, secondNode};
        }
        return new ConditionalNode(dollar, varRef, nodes);
    }

    private static IterationNode parseIteration(String template, int dollar, String varRef, int afterColon, int stop) {
        int firstBar = Template.indexOf(template, "|", afterColon, stop);
        int secondBar = Template.indexOf(template, "|", firstBar + 1, stop);
        if (secondBar < afterColon) {
            throw new IllegalArgumentException("Expected $[listVar:iterVar|sep|...] at " + Template.excerpt(template, dollar));
        }
        String iterationVarName = template.substring(afterColon, firstBar);
        String separator = template.substring(firstBar + 1, secondBar);
        Node iterated = Template.parse(template, secondBar + 1, stop);
        return new IterationNode(dollar, varRef, iterationVarName, separator, iterated);
    }

    private static int indexOf(String container, String pattern, int start, int stop) {
        for (int i = start; i < stop; ++i) {
            if (!container.startsWith(pattern, i)) continue;
            return i;
        }
        return -1;
    }

    private static int scanVarRef(String text, int start, int stop) {
        Matcher matcher = varRefPattern.matcher(text.substring(start, stop));
        if (matcher.lookingAt()) {
            return start + matcher.end();
        }
        throw new IllegalArgumentException("Expected id after $[ at " + Template.excerpt(text, start));
    }

    private static int matchingCloseSquare(String s, int i) {
        int squares = 0;
        for (int j = i; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c == '[') {
                ++squares;
                continue;
            }
            if (c != ']' || --squares != 0) continue;
            return j;
        }
        throw new IllegalArgumentException("No closing ] to match text starting " + Template.excerpt(s, i));
    }

    private static String stripComments(String template) {
        template = entireLineCommentPattern.matcher(template).replaceAll("");
        return midLineCommentPattern.matcher(template).replaceAll("");
    }

    private static String excerpt(String s, int startI) {
        if (s.length() - startI <= 40) {
            return s.substring(startI);
        }
        return s.substring(startI, startI + 40) + "...";
    }

    private static class IterationNode
    extends VarRefNode {
        private final String iterationVarName;
        private final String separator;
        private final Node iteratedNode;

        IterationNode(int templateIndex, String varRef, String iterationVarName, String separator, Node iteratedNode) {
            super(templateIndex, varRef);
            this.iterationVarName = iterationVarName;
            this.separator = separator;
            this.iteratedNode = iteratedNode;
        }

        @Override
        void appendTo(StringBuilder sb, Template template, Map<String, ?> vars) {
            if (vars.containsKey(this.iterationVarName)) {
                throw new IllegalArgumentException("Iteration variable name " + this.iterationVarName + " is already defined at " + Template.excerpt(template.template, this.templateIndex));
            }
            HashMap newVars = new HashMap(vars);
            Object iterableValue = this.getVar(vars, template);
            if (!(iterableValue instanceof Iterable)) {
                throw new IllegalArgumentException("Value (" + iterableValue + ") is not Iterable at " + Template.excerpt(template.template, this.templateIndex));
            }
            Iterable iterable = (Iterable)iterableValue;
            String sep = "";
            for (Object value : iterable) {
                newVars.put(this.iterationVarName, value);
                sb.append(sep);
                this.iteratedNode.appendTo(sb, template, newVars);
                sep = this.separator;
            }
        }
    }

    private static class ConditionalNode
    extends VarRefNode {
        private final Node[] nodes;

        ConditionalNode(int templateIndex, String varRef, Node[] nodes) {
            super(templateIndex, varRef);
            assert (nodes.length == 2);
            this.nodes = nodes;
        }

        @Override
        void appendTo(StringBuilder sb, Template template, Map<String, ?> vars) {
            Object value = this.getVar(vars, template);
            boolean truth = this.truth(value, template);
            Node node = truth ? this.nodes[1] : this.nodes[0];
            node.appendTo(sb, template, vars);
        }

        private boolean truth(Object x, Template template) {
            if (x == null) {
                return false;
            }
            if (x instanceof Boolean) {
                return (Boolean)x;
            }
            if (x instanceof Number) {
                return ((Number)x).doubleValue() != 0.0;
            }
            if (x instanceof CharSequence) {
                return ((CharSequence)x).length() != 0;
            }
            if (x instanceof Iterable) {
                return ((Iterable)x).iterator().hasNext();
            }
            throw new IllegalArgumentException("Don't know how to evaluate the truth of " + x + " at " + Template.excerpt(template.template, this.templateIndex));
        }
    }

    private static class VarNode
    extends VarRefNode {
        VarNode(int templateIndex, String varRef) {
            super(templateIndex, varRef);
        }

        @Override
        void appendTo(StringBuilder sb, Template template, Map<String, ?> vars) {
            Object value = this.getVar(vars, template);
            sb.append(value);
        }
    }

    private static abstract class VarRefNode
    extends Node {
        private final String varRef;

        VarRefNode(int templateIndex, String varRef) {
            super(templateIndex);
            this.varRef = varRef;
        }

        Object getVar(Map<String, ?> vars, Template template) {
            String[] parts = this.varRef.split("\\.");
            Object value = vars.get(parts[0]);
            if (value == null) {
                throw new IllegalArgumentException("Reference to undefined var $[" + parts[0] + "] at " + Template.excerpt(template.template, this.templateIndex));
            }
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i];
                Method method = VarRefNode.findPublicMethod(value.getClass(), part);
                if (method == null) {
                    throw new IllegalArgumentException("No method \"" + part + "\" in " + value.getClass());
                }
                try {
                    value = method.invoke(value, new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to invoke " + value.getClass().getName() + "." + part + "() on " + value, e);
                }
            }
            return value;
        }

        private static Method findPublicMethod(Class<?> c, String methodName) {
            try {
                Method method = c.getMethod(methodName, new Class[0]);
                if (Modifier.isPublic(c.getModifiers()) || c.getName().startsWith("com.google.auto.value")) {
                    return method;
                }
                if (c.getSuperclass() != null) {
                    method = VarRefNode.findPublicMethod(c.getSuperclass(), methodName);
                }
                if (method == null) {
                    Class<?> intf;
                    Class<?>[] arr$ = c.getInterfaces();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (method = VarRefNode.findPublicMethod(intf = arr$[i$], methodName)) == null; ++i$) {
                    }
                }
                return method;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }

    private static class CompoundNode
    extends Node {
        private final List<Node> nodes;

        CompoundNode(int templateIndex, List<Node> nodes) {
            super(templateIndex);
            this.nodes = nodes;
        }

        @Override
        void appendTo(StringBuilder sb, Template template, Map<String, ?> vars) {
            for (Node node : this.nodes) {
                node.appendTo(sb, template, vars);
            }
        }
    }

    private static class LiteralNode
    extends Node {
        private final String text;

        LiteralNode(int templateIndex, String text) {
            super(templateIndex);
            this.text = text;
        }

        @Override
        void appendTo(StringBuilder sb, Template template, Map<String, ?> vars) {
            sb.append(this.text);
        }
    }

    private static abstract class Node {
        final int templateIndex;

        Node(int templateIndex) {
            this.templateIndex = templateIndex;
        }

        abstract void appendTo(StringBuilder var1, Template var2, Map<String, ?> var3);
    }
}

