/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.AnnotationMirrors;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.collect.Multimap;
import autovalue.shaded.com.google.escapevelocity.Template;
import com.google.auto.value.processor.AutoValueTemplateVars;
import com.google.auto.value.processor.AutoValueishProcessor;
import com.google.auto.value.processor.BuilderSpec;
import com.google.auto.value.processor.GwtCompatibility;
import com.google.auto.value.processor.PropertyBuilderClassifier;
import com.google.auto.value.processor.TemplateVars;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeSimplifier;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

class GwtSerialization {
    private final GwtCompatibility gwtCompatibility;
    private final ProcessingEnvironment processingEnv;
    private final TypeElement type;

    GwtSerialization(GwtCompatibility gwtCompatibility, ProcessingEnvironment processingEnv, TypeElement type) {
        this.gwtCompatibility = gwtCompatibility;
        this.processingEnv = processingEnv;
        this.type = type;
    }

    private boolean shouldWriteGwtSerializer() {
        Optional<AnnotationMirror> optionalGwtCompatible = this.gwtCompatibility.gwtCompatibleAnnotation();
        if (optionalGwtCompatible.isPresent()) {
            AnnotationMirror gwtCompatible = optionalGwtCompatible.get();
            return AnnotationMirrors.getAnnotationValuesWithDefaults(gwtCompatible).entrySet().stream().anyMatch(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("serializable") && ((AnnotationValue)e.getValue()).getValue().equals(true));
        }
        return false;
    }

    void maybeWriteGwtSerializer(AutoValueTemplateVars autoVars, String finalSubclass) {
        if (this.shouldWriteGwtSerializer()) {
            GwtTemplateVars vars = new GwtTemplateVars();
            vars.pkg = autoVars.pkg;
            vars.subclass = finalSubclass;
            vars.formalTypes = autoVars.formalTypes;
            vars.actualTypes = autoVars.actualTypes;
            vars.useBuilder = !autoVars.builderTypeName.isEmpty();
            vars.builderSetters = autoVars.builderSetters;
            vars.builderPropertyBuilders = autoVars.builderPropertyBuilders;
            vars.generated = autoVars.generated;
            String className = (vars.pkg.isEmpty() ? "" : vars.pkg + ".") + vars.subclass + "_CustomFieldSerializer";
            vars.serializerClass = TypeSimplifier.simpleNameOf(className);
            vars.props = autoVars.props.stream().map(p -> new Property((AutoValueishProcessor.GetterProperty)p)).collect(Collectors.toList());
            vars.classHashString = this.computeClassHash(autoVars.props, vars.pkg);
            String text = vars.toText();
            text = TypeEncoder.decode(text, this.processingEnv, vars.pkg, this.type.asType());
            this.writeSourceFile(className, text, this.type);
        }
    }

    private void writeSourceFile(String className, String text, TypeElement originatingType) {
        try {
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(className, originatingType);
            try (Writer writer = sourceFile.openWriter();){
                writer.write(text);
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not write generated class " + className + ": " + e);
        }
    }

    private String computeClassHash(Iterable<AutoValueishProcessor.Property> props, String pkg) {
        CRC32 crc = new CRC32();
        String encodedType = TypeEncoder.encode(this.type.asType()) + ":";
        String decodedType = TypeEncoder.decode(encodedType, this.processingEnv, "", null);
        if (!decodedType.startsWith(pkg)) {
            decodedType = pkg + "." + decodedType;
        }
        crc.update(decodedType.getBytes(StandardCharsets.UTF_8));
        for (AutoValueishProcessor.Property prop : props) {
            String encodedProp = prop + ":" + TypeEncoder.encode(prop.getTypeMirror()) + ";";
            String decodedProp = TypeEncoder.decode(encodedProp, this.processingEnv, pkg, null);
            crc.update(decodedProp.getBytes(StandardCharsets.UTF_8));
        }
        return String.format("%08x", crc.getValue());
    }

    static class GwtTemplateVars
    extends TemplateVars {
        List<Property> props;
        String pkg;
        String subclass;
        String formalTypes;
        String actualTypes;
        Boolean useBuilder;
        Multimap<String, BuilderSpec.PropertySetter> builderSetters;
        ImmutableMap<String, PropertyBuilderClassifier.PropertyBuilder> builderPropertyBuilders = ImmutableMap.of();
        String serializerClass;
        String generated;
        String classHashString;
        private static final Template TEMPLATE = GwtTemplateVars.parsedTemplateForResource("gwtserializer.vm");

        GwtTemplateVars() {
        }

        @Override
        Template parsedTemplate() {
            return TEMPLATE;
        }
    }

    public static class Property {
        private final AutoValueishProcessor.GetterProperty property;
        private final boolean isCastingUnchecked;

        Property(AutoValueishProcessor.GetterProperty property) {
            this.property = property;
            this.isCastingUnchecked = TypeSimplifier.isCastingUnchecked(property.getTypeMirror());
        }

        public String toString() {
            return this.property.toString();
        }

        public String getGetter() {
            return this.property.getGetter();
        }

        public String getType() {
            return this.property.getType();
        }

        public String getName() {
            return this.property.getName();
        }

        public String getGwtType() {
            TypeMirror typeMirror = this.property.getTypeMirror();
            String type = typeMirror.toString();
            if (this.property.getKind().isPrimitive()) {
                return Character.toUpperCase(type.charAt(0)) + type.substring(1);
            }
            if (type.equals("java.lang.String")) {
                return "String";
            }
            return "Object";
        }

        public String getGwtCast() {
            if (this.property.getKind().isPrimitive() || this.getType().equals("String")) {
                return "";
            }
            return "(" + this.getType() + ") ";
        }

        public boolean isCastingUnchecked() {
            return this.isCastingUnchecked;
        }
    }
}

