/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.authorization.AuthorizationHandler;
import com.google.cloud.hadoop.gcsio.cooplock.CooperativeLockingOptions;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_GoogleCloudStorageOptions
extends GoogleCloudStorageOptions {
    private final boolean grpcEnabled;
    private final boolean directPathPreffered;
    private final String storageRootUrl;
    private final String storageServicePath;
    private final String projectId;
    private final String appName;
    private final boolean autoRepairImplicitDirectoriesEnabled;
    private final int maxWaitMillisForEmptyObjectCreation;
    private final long maxListItemsPerCall;
    private final long maxRequestsPerBatch;
    private final int batchThreads;
    private final int maxHttpRequestRetries;
    private final int httpRequestConnectTimeout;
    private final int httpRequestReadTimeout;
    private final HttpTransportFactory.HttpTransportType transportType;
    private final String proxyAddress;
    private final RedactedString proxyUsername;
    private final RedactedString proxyPassword;
    private final boolean copyWithRewriteEnabled;
    private final long maxBytesRewrittenPerCall;
    private final GoogleCloudStorageReadOptions readChannelOptions;
    private final AsyncWriteChannelOptions writeChannelOptions;
    private final RequesterPaysOptions requesterPaysOptions;
    private final CooperativeLockingOptions cooperativeLockingOptions;
    private final ImmutableMap<String, String> httpRequestHeaders;
    private final String encryptionAlgorithm;
    private final RedactedString encryptionKey;
    private final RedactedString encryptionKeyHash;
    private final Class<? extends AuthorizationHandler> authorizationHandlerImplClass;
    private final Map<String, String> authorizationHandlerProperties;

    private AutoValue_GoogleCloudStorageOptions(boolean grpcEnabled, boolean directPathPreffered, String storageRootUrl, String storageServicePath, @Nullable String projectId, @Nullable String appName, boolean autoRepairImplicitDirectoriesEnabled, int maxWaitMillisForEmptyObjectCreation, long maxListItemsPerCall, long maxRequestsPerBatch, int batchThreads, int maxHttpRequestRetries, int httpRequestConnectTimeout, int httpRequestReadTimeout, HttpTransportFactory.HttpTransportType transportType, @Nullable String proxyAddress, @Nullable RedactedString proxyUsername, @Nullable RedactedString proxyPassword, boolean copyWithRewriteEnabled, long maxBytesRewrittenPerCall, GoogleCloudStorageReadOptions readChannelOptions, AsyncWriteChannelOptions writeChannelOptions, RequesterPaysOptions requesterPaysOptions, CooperativeLockingOptions cooperativeLockingOptions, ImmutableMap<String, String> httpRequestHeaders, @Nullable String encryptionAlgorithm, @Nullable RedactedString encryptionKey, @Nullable RedactedString encryptionKeyHash, @Nullable Class<? extends AuthorizationHandler> authorizationHandlerImplClass, Map<String, String> authorizationHandlerProperties) {
        this.grpcEnabled = grpcEnabled;
        this.directPathPreffered = directPathPreffered;
        this.storageRootUrl = storageRootUrl;
        this.storageServicePath = storageServicePath;
        this.projectId = projectId;
        this.appName = appName;
        this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
        this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
        this.maxListItemsPerCall = maxListItemsPerCall;
        this.maxRequestsPerBatch = maxRequestsPerBatch;
        this.batchThreads = batchThreads;
        this.maxHttpRequestRetries = maxHttpRequestRetries;
        this.httpRequestConnectTimeout = httpRequestConnectTimeout;
        this.httpRequestReadTimeout = httpRequestReadTimeout;
        this.transportType = transportType;
        this.proxyAddress = proxyAddress;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.copyWithRewriteEnabled = copyWithRewriteEnabled;
        this.maxBytesRewrittenPerCall = maxBytesRewrittenPerCall;
        this.readChannelOptions = readChannelOptions;
        this.writeChannelOptions = writeChannelOptions;
        this.requesterPaysOptions = requesterPaysOptions;
        this.cooperativeLockingOptions = cooperativeLockingOptions;
        this.httpRequestHeaders = httpRequestHeaders;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.encryptionKey = encryptionKey;
        this.encryptionKeyHash = encryptionKeyHash;
        this.authorizationHandlerImplClass = authorizationHandlerImplClass;
        this.authorizationHandlerProperties = authorizationHandlerProperties;
    }

    @Override
    public boolean isGrpcEnabled() {
        return this.grpcEnabled;
    }

    @Override
    public boolean isDirectPathPreffered() {
        return this.directPathPreffered;
    }

    @Override
    public String getStorageRootUrl() {
        return this.storageRootUrl;
    }

    @Override
    public String getStorageServicePath() {
        return this.storageServicePath;
    }

    @Override
    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @Nullable
    public String getAppName() {
        return this.appName;
    }

    @Override
    public boolean isAutoRepairImplicitDirectoriesEnabled() {
        return this.autoRepairImplicitDirectoriesEnabled;
    }

    @Override
    public int getMaxWaitMillisForEmptyObjectCreation() {
        return this.maxWaitMillisForEmptyObjectCreation;
    }

    @Override
    public long getMaxListItemsPerCall() {
        return this.maxListItemsPerCall;
    }

    @Override
    public long getMaxRequestsPerBatch() {
        return this.maxRequestsPerBatch;
    }

    @Override
    public int getBatchThreads() {
        return this.batchThreads;
    }

    @Override
    public int getMaxHttpRequestRetries() {
        return this.maxHttpRequestRetries;
    }

    @Override
    public int getHttpRequestConnectTimeout() {
        return this.httpRequestConnectTimeout;
    }

    @Override
    public int getHttpRequestReadTimeout() {
        return this.httpRequestReadTimeout;
    }

    @Override
    public HttpTransportFactory.HttpTransportType getTransportType() {
        return this.transportType;
    }

    @Override
    @Nullable
    public String getProxyAddress() {
        return this.proxyAddress;
    }

    @Override
    @Nullable
    public RedactedString getProxyUsername() {
        return this.proxyUsername;
    }

    @Override
    @Nullable
    public RedactedString getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public boolean isCopyWithRewriteEnabled() {
        return this.copyWithRewriteEnabled;
    }

    @Override
    public long getMaxBytesRewrittenPerCall() {
        return this.maxBytesRewrittenPerCall;
    }

    @Override
    public GoogleCloudStorageReadOptions getReadChannelOptions() {
        return this.readChannelOptions;
    }

    @Override
    public AsyncWriteChannelOptions getWriteChannelOptions() {
        return this.writeChannelOptions;
    }

    @Override
    public RequesterPaysOptions getRequesterPaysOptions() {
        return this.requesterPaysOptions;
    }

    @Override
    public CooperativeLockingOptions getCooperativeLockingOptions() {
        return this.cooperativeLockingOptions;
    }

    @Override
    public ImmutableMap<String, String> getHttpRequestHeaders() {
        return this.httpRequestHeaders;
    }

    @Override
    @Nullable
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    @Nullable
    public RedactedString getEncryptionKey() {
        return this.encryptionKey;
    }

    @Override
    @Nullable
    public RedactedString getEncryptionKeyHash() {
        return this.encryptionKeyHash;
    }

    @Override
    @Nullable
    public Class<? extends AuthorizationHandler> getAuthorizationHandlerImplClass() {
        return this.authorizationHandlerImplClass;
    }

    @Override
    public Map<String, String> getAuthorizationHandlerProperties() {
        return this.authorizationHandlerProperties;
    }

    public String toString() {
        return "GoogleCloudStorageOptions{grpcEnabled=" + this.grpcEnabled + ", directPathPreffered=" + this.directPathPreffered + ", storageRootUrl=" + this.storageRootUrl + ", storageServicePath=" + this.storageServicePath + ", projectId=" + this.projectId + ", appName=" + this.appName + ", autoRepairImplicitDirectoriesEnabled=" + this.autoRepairImplicitDirectoriesEnabled + ", maxWaitMillisForEmptyObjectCreation=" + this.maxWaitMillisForEmptyObjectCreation + ", maxListItemsPerCall=" + this.maxListItemsPerCall + ", maxRequestsPerBatch=" + this.maxRequestsPerBatch + ", batchThreads=" + this.batchThreads + ", maxHttpRequestRetries=" + this.maxHttpRequestRetries + ", httpRequestConnectTimeout=" + this.httpRequestConnectTimeout + ", httpRequestReadTimeout=" + this.httpRequestReadTimeout + ", transportType=" + this.transportType + ", proxyAddress=" + this.proxyAddress + ", proxyUsername=" + this.proxyUsername + ", proxyPassword=" + this.proxyPassword + ", copyWithRewriteEnabled=" + this.copyWithRewriteEnabled + ", maxBytesRewrittenPerCall=" + this.maxBytesRewrittenPerCall + ", readChannelOptions=" + this.readChannelOptions + ", writeChannelOptions=" + this.writeChannelOptions + ", requesterPaysOptions=" + this.requesterPaysOptions + ", cooperativeLockingOptions=" + this.cooperativeLockingOptions + ", httpRequestHeaders=" + this.httpRequestHeaders + ", encryptionAlgorithm=" + this.encryptionAlgorithm + ", encryptionKey=" + this.encryptionKey + ", encryptionKeyHash=" + this.encryptionKeyHash + ", authorizationHandlerImplClass=" + this.authorizationHandlerImplClass + ", authorizationHandlerProperties=" + this.authorizationHandlerProperties + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GoogleCloudStorageOptions) {
            GoogleCloudStorageOptions that = (GoogleCloudStorageOptions)o;
            return this.grpcEnabled == that.isGrpcEnabled() && this.directPathPreffered == that.isDirectPathPreffered() && this.storageRootUrl.equals(that.getStorageRootUrl()) && this.storageServicePath.equals(that.getStorageServicePath()) && (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId())) && (this.appName == null ? that.getAppName() == null : this.appName.equals(that.getAppName())) && this.autoRepairImplicitDirectoriesEnabled == that.isAutoRepairImplicitDirectoriesEnabled() && this.maxWaitMillisForEmptyObjectCreation == that.getMaxWaitMillisForEmptyObjectCreation() && this.maxListItemsPerCall == that.getMaxListItemsPerCall() && this.maxRequestsPerBatch == that.getMaxRequestsPerBatch() && this.batchThreads == that.getBatchThreads() && this.maxHttpRequestRetries == that.getMaxHttpRequestRetries() && this.httpRequestConnectTimeout == that.getHttpRequestConnectTimeout() && this.httpRequestReadTimeout == that.getHttpRequestReadTimeout() && this.transportType.equals((Object)that.getTransportType()) && (this.proxyAddress == null ? that.getProxyAddress() == null : this.proxyAddress.equals(that.getProxyAddress())) && (this.proxyUsername == null ? that.getProxyUsername() == null : this.proxyUsername.equals(that.getProxyUsername())) && (this.proxyPassword == null ? that.getProxyPassword() == null : this.proxyPassword.equals(that.getProxyPassword())) && this.copyWithRewriteEnabled == that.isCopyWithRewriteEnabled() && this.maxBytesRewrittenPerCall == that.getMaxBytesRewrittenPerCall() && this.readChannelOptions.equals(that.getReadChannelOptions()) && this.writeChannelOptions.equals(that.getWriteChannelOptions()) && this.requesterPaysOptions.equals(that.getRequesterPaysOptions()) && this.cooperativeLockingOptions.equals(that.getCooperativeLockingOptions()) && this.httpRequestHeaders.equals(that.getHttpRequestHeaders()) && (this.encryptionAlgorithm == null ? that.getEncryptionAlgorithm() == null : this.encryptionAlgorithm.equals(that.getEncryptionAlgorithm())) && (this.encryptionKey == null ? that.getEncryptionKey() == null : this.encryptionKey.equals(that.getEncryptionKey())) && (this.encryptionKeyHash == null ? that.getEncryptionKeyHash() == null : this.encryptionKeyHash.equals(that.getEncryptionKeyHash())) && (this.authorizationHandlerImplClass == null ? that.getAuthorizationHandlerImplClass() == null : this.authorizationHandlerImplClass.equals(that.getAuthorizationHandlerImplClass())) && this.authorizationHandlerProperties.equals(that.getAuthorizationHandlerProperties());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.grpcEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.directPathPreffered ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.storageRootUrl.hashCode();
        h$ *= 1000003;
        h$ ^= this.storageServicePath.hashCode();
        h$ *= 1000003;
        h$ ^= this.projectId == null ? 0 : this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.appName == null ? 0 : this.appName.hashCode();
        h$ *= 1000003;
        h$ ^= this.autoRepairImplicitDirectoriesEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.maxWaitMillisForEmptyObjectCreation;
        h$ *= 1000003;
        h$ ^= (int)(this.maxListItemsPerCall >>> 32 ^ this.maxListItemsPerCall);
        h$ *= 1000003;
        h$ ^= (int)(this.maxRequestsPerBatch >>> 32 ^ this.maxRequestsPerBatch);
        h$ *= 1000003;
        h$ ^= this.batchThreads;
        h$ *= 1000003;
        h$ ^= this.maxHttpRequestRetries;
        h$ *= 1000003;
        h$ ^= this.httpRequestConnectTimeout;
        h$ *= 1000003;
        h$ ^= this.httpRequestReadTimeout;
        h$ *= 1000003;
        h$ ^= this.transportType.hashCode();
        h$ *= 1000003;
        h$ ^= this.proxyAddress == null ? 0 : this.proxyAddress.hashCode();
        h$ *= 1000003;
        h$ ^= this.proxyUsername == null ? 0 : this.proxyUsername.hashCode();
        h$ *= 1000003;
        h$ ^= this.proxyPassword == null ? 0 : this.proxyPassword.hashCode();
        h$ *= 1000003;
        h$ ^= this.copyWithRewriteEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.maxBytesRewrittenPerCall >>> 32 ^ this.maxBytesRewrittenPerCall);
        h$ *= 1000003;
        h$ ^= this.readChannelOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.writeChannelOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.requesterPaysOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.cooperativeLockingOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.httpRequestHeaders.hashCode();
        h$ *= 1000003;
        h$ ^= this.encryptionAlgorithm == null ? 0 : this.encryptionAlgorithm.hashCode();
        h$ *= 1000003;
        h$ ^= this.encryptionKey == null ? 0 : this.encryptionKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.encryptionKeyHash == null ? 0 : this.encryptionKeyHash.hashCode();
        h$ *= 1000003;
        h$ ^= this.authorizationHandlerImplClass == null ? 0 : this.authorizationHandlerImplClass.hashCode();
        h$ *= 1000003;
        return h$ ^= this.authorizationHandlerProperties.hashCode();
    }

    @Override
    public GoogleCloudStorageOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends GoogleCloudStorageOptions.Builder {
        private Boolean grpcEnabled;
        private Boolean directPathPreffered;
        private String storageRootUrl;
        private String storageServicePath;
        private String projectId;
        private String appName;
        private Boolean autoRepairImplicitDirectoriesEnabled;
        private Integer maxWaitMillisForEmptyObjectCreation;
        private Long maxListItemsPerCall;
        private Long maxRequestsPerBatch;
        private Integer batchThreads;
        private Integer maxHttpRequestRetries;
        private Integer httpRequestConnectTimeout;
        private Integer httpRequestReadTimeout;
        private HttpTransportFactory.HttpTransportType transportType;
        private String proxyAddress;
        private RedactedString proxyUsername;
        private RedactedString proxyPassword;
        private Boolean copyWithRewriteEnabled;
        private Long maxBytesRewrittenPerCall;
        private GoogleCloudStorageReadOptions readChannelOptions;
        private AsyncWriteChannelOptions writeChannelOptions;
        private RequesterPaysOptions requesterPaysOptions;
        private CooperativeLockingOptions cooperativeLockingOptions;
        private ImmutableMap<String, String> httpRequestHeaders;
        private String encryptionAlgorithm;
        private RedactedString encryptionKey;
        private RedactedString encryptionKeyHash;
        private Class<? extends AuthorizationHandler> authorizationHandlerImplClass;
        private Map<String, String> authorizationHandlerProperties;

        Builder() {
        }

        private Builder(GoogleCloudStorageOptions source) {
            this.grpcEnabled = source.isGrpcEnabled();
            this.directPathPreffered = source.isDirectPathPreffered();
            this.storageRootUrl = source.getStorageRootUrl();
            this.storageServicePath = source.getStorageServicePath();
            this.projectId = source.getProjectId();
            this.appName = source.getAppName();
            this.autoRepairImplicitDirectoriesEnabled = source.isAutoRepairImplicitDirectoriesEnabled();
            this.maxWaitMillisForEmptyObjectCreation = source.getMaxWaitMillisForEmptyObjectCreation();
            this.maxListItemsPerCall = source.getMaxListItemsPerCall();
            this.maxRequestsPerBatch = source.getMaxRequestsPerBatch();
            this.batchThreads = source.getBatchThreads();
            this.maxHttpRequestRetries = source.getMaxHttpRequestRetries();
            this.httpRequestConnectTimeout = source.getHttpRequestConnectTimeout();
            this.httpRequestReadTimeout = source.getHttpRequestReadTimeout();
            this.transportType = source.getTransportType();
            this.proxyAddress = source.getProxyAddress();
            this.proxyUsername = source.getProxyUsername();
            this.proxyPassword = source.getProxyPassword();
            this.copyWithRewriteEnabled = source.isCopyWithRewriteEnabled();
            this.maxBytesRewrittenPerCall = source.getMaxBytesRewrittenPerCall();
            this.readChannelOptions = source.getReadChannelOptions();
            this.writeChannelOptions = source.getWriteChannelOptions();
            this.requesterPaysOptions = source.getRequesterPaysOptions();
            this.cooperativeLockingOptions = source.getCooperativeLockingOptions();
            this.httpRequestHeaders = source.getHttpRequestHeaders();
            this.encryptionAlgorithm = source.getEncryptionAlgorithm();
            this.encryptionKey = source.getEncryptionKey();
            this.encryptionKeyHash = source.getEncryptionKeyHash();
            this.authorizationHandlerImplClass = source.getAuthorizationHandlerImplClass();
            this.authorizationHandlerProperties = source.getAuthorizationHandlerProperties();
        }

        @Override
        public GoogleCloudStorageOptions.Builder setGrpcEnabled(boolean grpcEnabled) {
            this.grpcEnabled = grpcEnabled;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setDirectPathPreffered(boolean directPathPreffered) {
            this.directPathPreffered = directPathPreffered;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setStorageRootUrl(String storageRootUrl) {
            if (storageRootUrl == null) {
                throw new NullPointerException("Null storageRootUrl");
            }
            this.storageRootUrl = storageRootUrl;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setStorageServicePath(String storageServicePath) {
            if (storageServicePath == null) {
                throw new NullPointerException("Null storageServicePath");
            }
            this.storageServicePath = storageServicePath;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setAutoRepairImplicitDirectoriesEnabled(boolean autoRepairImplicitDirectoriesEnabled) {
            this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxWaitMillisForEmptyObjectCreation(int maxWaitMillisForEmptyObjectCreation) {
            this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxListItemsPerCall(long maxListItemsPerCall) {
            this.maxListItemsPerCall = maxListItemsPerCall;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxRequestsPerBatch(long maxRequestsPerBatch) {
            this.maxRequestsPerBatch = maxRequestsPerBatch;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setBatchThreads(int batchThreads) {
            this.batchThreads = batchThreads;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxHttpRequestRetries(int maxHttpRequestRetries) {
            this.maxHttpRequestRetries = maxHttpRequestRetries;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setHttpRequestConnectTimeout(int httpRequestConnectTimeout) {
            this.httpRequestConnectTimeout = httpRequestConnectTimeout;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setHttpRequestReadTimeout(int httpRequestReadTimeout) {
            this.httpRequestReadTimeout = httpRequestReadTimeout;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setTransportType(HttpTransportFactory.HttpTransportType transportType) {
            if (transportType == null) {
                throw new NullPointerException("Null transportType");
            }
            this.transportType = transportType;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setProxyAddress(String proxyAddress) {
            this.proxyAddress = proxyAddress;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setProxyUsername(RedactedString proxyUsername) {
            this.proxyUsername = proxyUsername;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setProxyPassword(RedactedString proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setCopyWithRewriteEnabled(boolean copyWithRewriteEnabled) {
            this.copyWithRewriteEnabled = copyWithRewriteEnabled;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxBytesRewrittenPerCall(long maxBytesRewrittenPerCall) {
            this.maxBytesRewrittenPerCall = maxBytesRewrittenPerCall;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setReadChannelOptions(GoogleCloudStorageReadOptions readChannelOptions) {
            if (readChannelOptions == null) {
                throw new NullPointerException("Null readChannelOptions");
            }
            this.readChannelOptions = readChannelOptions;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setWriteChannelOptions(AsyncWriteChannelOptions writeChannelOptions) {
            if (writeChannelOptions == null) {
                throw new NullPointerException("Null writeChannelOptions");
            }
            this.writeChannelOptions = writeChannelOptions;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setRequesterPaysOptions(RequesterPaysOptions requesterPaysOptions) {
            if (requesterPaysOptions == null) {
                throw new NullPointerException("Null requesterPaysOptions");
            }
            this.requesterPaysOptions = requesterPaysOptions;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setCooperativeLockingOptions(CooperativeLockingOptions cooperativeLockingOptions) {
            if (cooperativeLockingOptions == null) {
                throw new NullPointerException("Null cooperativeLockingOptions");
            }
            this.cooperativeLockingOptions = cooperativeLockingOptions;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setHttpRequestHeaders(Map<String, String> httpRequestHeaders) {
            this.httpRequestHeaders = ImmutableMap.copyOf(httpRequestHeaders);
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setEncryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setEncryptionKey(RedactedString encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setEncryptionKeyHash(RedactedString encryptionKeyHash) {
            this.encryptionKeyHash = encryptionKeyHash;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setAuthorizationHandlerImplClass(Class<? extends AuthorizationHandler> authorizationHandlerImplClass) {
            this.authorizationHandlerImplClass = authorizationHandlerImplClass;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setAuthorizationHandlerProperties(Map<String, String> authorizationHandlerProperties) {
            if (authorizationHandlerProperties == null) {
                throw new NullPointerException("Null authorizationHandlerProperties");
            }
            this.authorizationHandlerProperties = authorizationHandlerProperties;
            return this;
        }

        @Override
        GoogleCloudStorageOptions autoBuild() {
            String missing = "";
            if (this.grpcEnabled == null) {
                missing = missing + " grpcEnabled";
            }
            if (this.directPathPreffered == null) {
                missing = missing + " directPathPreffered";
            }
            if (this.storageRootUrl == null) {
                missing = missing + " storageRootUrl";
            }
            if (this.storageServicePath == null) {
                missing = missing + " storageServicePath";
            }
            if (this.autoRepairImplicitDirectoriesEnabled == null) {
                missing = missing + " autoRepairImplicitDirectoriesEnabled";
            }
            if (this.maxWaitMillisForEmptyObjectCreation == null) {
                missing = missing + " maxWaitMillisForEmptyObjectCreation";
            }
            if (this.maxListItemsPerCall == null) {
                missing = missing + " maxListItemsPerCall";
            }
            if (this.maxRequestsPerBatch == null) {
                missing = missing + " maxRequestsPerBatch";
            }
            if (this.batchThreads == null) {
                missing = missing + " batchThreads";
            }
            if (this.maxHttpRequestRetries == null) {
                missing = missing + " maxHttpRequestRetries";
            }
            if (this.httpRequestConnectTimeout == null) {
                missing = missing + " httpRequestConnectTimeout";
            }
            if (this.httpRequestReadTimeout == null) {
                missing = missing + " httpRequestReadTimeout";
            }
            if (this.transportType == null) {
                missing = missing + " transportType";
            }
            if (this.copyWithRewriteEnabled == null) {
                missing = missing + " copyWithRewriteEnabled";
            }
            if (this.maxBytesRewrittenPerCall == null) {
                missing = missing + " maxBytesRewrittenPerCall";
            }
            if (this.readChannelOptions == null) {
                missing = missing + " readChannelOptions";
            }
            if (this.writeChannelOptions == null) {
                missing = missing + " writeChannelOptions";
            }
            if (this.requesterPaysOptions == null) {
                missing = missing + " requesterPaysOptions";
            }
            if (this.cooperativeLockingOptions == null) {
                missing = missing + " cooperativeLockingOptions";
            }
            if (this.httpRequestHeaders == null) {
                missing = missing + " httpRequestHeaders";
            }
            if (this.authorizationHandlerProperties == null) {
                missing = missing + " authorizationHandlerProperties";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GoogleCloudStorageOptions(this.grpcEnabled, this.directPathPreffered, this.storageRootUrl, this.storageServicePath, this.projectId, this.appName, this.autoRepairImplicitDirectoriesEnabled, this.maxWaitMillisForEmptyObjectCreation, this.maxListItemsPerCall, this.maxRequestsPerBatch, this.batchThreads, this.maxHttpRequestRetries, this.httpRequestConnectTimeout, this.httpRequestReadTimeout, this.transportType, this.proxyAddress, this.proxyUsername, this.proxyPassword, this.copyWithRewriteEnabled, this.maxBytesRewrittenPerCall, this.readChannelOptions, this.writeChannelOptions, this.requesterPaysOptions, this.cooperativeLockingOptions, this.httpRequestHeaders, this.encryptionAlgorithm, this.encryptionKey, this.encryptionKeyHash, this.authorizationHandlerImplClass, this.authorizationHandlerProperties);
        }
    }
}

