/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.HttpTransport;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import com.google.cloud.hadoop.util.HadoopConfigurationProperty;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RedactedString;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class HadoopCredentialsConfiguration {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String BASE_KEY_PREFIX = "google.cloud";
    public static final String CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    public static final HadoopConfigurationProperty<AuthenticationType> AUTHENTICATION_TYPE_SUFFIX = new HadoopConfigurationProperty<AuthenticationType>(".auth.type", AuthenticationType.COMPUTE_ENGINE, new String[0]);
    public static final HadoopConfigurationProperty<String> SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX = new HadoopConfigurationProperty(".auth.service.account.json.keyfile");
    public static final HadoopConfigurationProperty<String> WORKLOAD_IDENTITY_FEDERATION_CREDENTIAL_CONFIG_FILE_SUFFIX = new HadoopConfigurationProperty(".auth.workload.identity.federation.credential.config.file");
    public static final HadoopConfigurationProperty<Class<? extends AccessTokenProvider>> ACCESS_TOKEN_PROVIDER_SUFFIX = new HadoopConfigurationProperty(".auth.access.token.provider");
    public static final HadoopConfigurationProperty<String> IMPERSONATION_SERVICE_ACCOUNT_SUFFIX = new HadoopConfigurationProperty(".auth.impersonation.service.account");
    public static final HadoopConfigurationProperty<Map<String, String>> USER_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX = new HadoopConfigurationProperty<ImmutableMap>(".auth.impersonation.service.account.for.user.", ImmutableMap.of(), new String[0]);
    public static final HadoopConfigurationProperty<Map<String, String>> GROUP_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX = new HadoopConfigurationProperty<ImmutableMap>(".auth.impersonation.service.account.for.group.", ImmutableMap.of(), new String[0]);
    public static final HadoopConfigurationProperty<String> TOKEN_SERVER_URL_SUFFIX = new HadoopConfigurationProperty(".token.server.url");
    public static final HadoopConfigurationProperty<String> PROXY_ADDRESS_SUFFIX = new HadoopConfigurationProperty(".proxy.address");
    public static final HadoopConfigurationProperty<RedactedString> PROXY_USERNAME_SUFFIX = new HadoopConfigurationProperty(".proxy.username");
    public static final HadoopConfigurationProperty<RedactedString> PROXY_PASSWORD_SUFFIX = new HadoopConfigurationProperty(".proxy.password");
    public static final HadoopConfigurationProperty<Long> READ_TIMEOUT_SUFFIX = new HadoopConfigurationProperty<Long>(".http.read-timeout", 5000L, new String[0]);
    public static final HadoopConfigurationProperty<String> AUTH_CLIENT_ID_SUFFIX = new HadoopConfigurationProperty(".auth.client.id");
    public static final HadoopConfigurationProperty<RedactedString> AUTH_CLIENT_SECRET_SUFFIX = new HadoopConfigurationProperty(".auth.client.secret");
    public static final HadoopConfigurationProperty<RedactedString> AUTH_REFRESH_TOKEN_SUFFIX = new HadoopConfigurationProperty(".auth.refresh.token");

    public static List<String> getConfigKeyPrefixes(String ... keyPrefixes) {
        return ImmutableList.builder().add((Object[])keyPrefixes).add((Object)BASE_KEY_PREFIX).build();
    }

    public static GoogleCredentials getCredentials(Configuration config, String ... keyPrefixesVararg) throws IOException {
        List<String> keyPrefixes = HadoopCredentialsConfiguration.getConfigKeyPrefixes(keyPrefixesVararg);
        return HadoopCredentialsConfiguration.getCredentials(HadoopCredentialsConfiguration.getHttpTransport(config, keyPrefixes), config, keyPrefixes);
    }

    @VisibleForTesting
    static GoogleCredentials getCredentials(Supplier<HttpTransport> transport, Configuration config, List<String> keyPrefixes) throws IOException {
        GoogleCredentials credentials = HadoopCredentialsConfiguration.getCredentialsInternal(transport, config, keyPrefixes);
        return credentials == null ? null : HadoopCredentialsConfiguration.configureCredentials(config, keyPrefixes, credentials);
    }

    private static GoogleCredentials getCredentialsInternal(Supplier<HttpTransport> transport, Configuration config, List<String> keyPrefixes) throws IOException {
        AuthenticationType authenticationType = AUTHENTICATION_TYPE_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1));
        switch (authenticationType) {
            case ACCESS_TOKEN_PROVIDER: {
                AccessTokenProvider accessTokenProvider;
                Class clazz = ACCESS_TOKEN_PROVIDER_SUFFIX.withPrefixes(keyPrefixes).get(config, (k, d) -> config.getClass(k, d, AccessTokenProvider.class));
                try {
                    accessTokenProvider = (AccessTokenProvider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new IOException("Can't instantiate " + clazz.getName(), e);
                }
                accessTokenProvider.setConf(config);
                return new AccessTokenProviderCredentials(accessTokenProvider);
            }
            case APPLICATION_DEFAULT: {
                return GoogleCredentials.getApplicationDefault(transport::get);
            }
            case COMPUTE_ENGINE: {
                return ComputeEngineCredentials.newBuilder().setHttpTransportFactory(transport::get).build();
            }
            case SERVICE_ACCOUNT_JSON_KEYFILE: {
                String keyFile = SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
                try (FileInputStream fis = new FileInputStream(keyFile);){
                    ServiceAccountCredentials serviceAccountCredentials = ServiceAccountCredentials.fromStream((InputStream)fis, transport::get);
                    return serviceAccountCredentials;
                }
            }
            case USER_CREDENTIALS: {
                String clientId = AUTH_CLIENT_ID_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
                RedactedString clientSecret = AUTH_CLIENT_SECRET_SUFFIX.withPrefixes(keyPrefixes).getPassword(config);
                RedactedString refreshToken = AUTH_REFRESH_TOKEN_SUFFIX.withPrefixes(keyPrefixes).getPassword(config);
                return UserCredentials.newBuilder().setClientId(clientId).setClientSecret(clientSecret.value()).setRefreshToken(refreshToken.value()).setHttpTransportFactory(transport::get).build();
            }
            case WORKLOAD_IDENTITY_FEDERATION_CREDENTIAL_CONFIG_FILE: {
                String configFile = WORKLOAD_IDENTITY_FEDERATION_CREDENTIAL_CONFIG_FILE_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
                try (FileInputStream fis = new FileInputStream(configFile);){
                    ExternalAccountCredentials externalAccountCredentials = ExternalAccountCredentials.fromStream((InputStream)fis, transport::get);
                    return externalAccountCredentials;
                }
            }
            case UNAUTHENTICATED: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown authentication type: " + authenticationType);
    }

    public static GoogleCredentials getImpersonatedCredentials(Configuration config, GoogleCredentials sourceCredentials, String ... keyPrefixesVararg) throws IOException {
        List<String> keyPrefixes = HadoopCredentialsConfiguration.getConfigKeyPrefixes(keyPrefixesVararg);
        Map<String, String> userImpersonationServiceAccounts = USER_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.withPrefixes(keyPrefixes).getPropsWithPrefix(config);
        Map<String, String> groupImpersonationServiceAccounts = GROUP_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.withPrefixes(keyPrefixes).getPropsWithPrefix(config);
        String impersonationServiceAccount = IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        if (userImpersonationServiceAccounts.isEmpty() && groupImpersonationServiceAccounts.isEmpty() && Strings.isNullOrEmpty((String)impersonationServiceAccount)) {
            return null;
        }
        Preconditions.checkNotNull((Object)sourceCredentials, (Object)"credentials can not be null");
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        Optional<String> serviceAccountToImpersonate = Stream.of(() -> HadoopCredentialsConfiguration.getServiceAccountToImpersonateForUserGroup(userImpersonationServiceAccounts, (List<String>)ImmutableList.of((Object)currentUser.getShortUserName())), () -> HadoopCredentialsConfiguration.getServiceAccountToImpersonateForUserGroup(groupImpersonationServiceAccounts, (List<String>)ImmutableList.copyOf((Object[])currentUser.getGroupNames())), () -> Optional.ofNullable(impersonationServiceAccount)).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).filter(sa -> !Strings.isNullOrEmpty((String)sa)).findFirst();
        if (serviceAccountToImpersonate.isPresent()) {
            Supplier<HttpTransport> transport = HadoopCredentialsConfiguration.getHttpTransport(config, keyPrefixes);
            ImpersonatedCredentials impersonatedCredentials = ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(serviceAccountToImpersonate.get()).setScopes((List)ImmutableList.of((Object)CLOUD_PLATFORM_SCOPE)).setHttpTransportFactory(transport::get).build();
            ((GoogleLogger.Api)logger.atFine()).log("Impersonating '%s' service account for '%s' user", (Object)serviceAccountToImpersonate.get(), (Object)currentUser);
            return impersonatedCredentials;
        }
        return null;
    }

    private static Optional<String> getServiceAccountToImpersonateForUserGroup(Map<String, String> serviceAccountMapping, List<String> userGroups) {
        return serviceAccountMapping.entrySet().stream().filter(e -> userGroups.contains(e.getKey())).map(Map.Entry::getValue).findFirst();
    }

    private static Supplier<HttpTransport> getHttpTransport(Configuration config, List<String> keyPrefixes) {
        return Suppliers.memoize(() -> {
            try {
                return HttpTransportFactory.createHttpTransport((String)PROXY_ADDRESS_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1)), (RedactedString)PROXY_USERNAME_SUFFIX.withPrefixes(keyPrefixes).getPassword(config), (RedactedString)PROXY_PASSWORD_SUFFIX.withPrefixes(keyPrefixes).getPassword(config), (Duration)READ_TIMEOUT_SUFFIX.withPrefixes(keyPrefixes).getTimeDuration(config));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static GoogleCredentials configureCredentials(Configuration config, List<String> keyPrefixes, GoogleCredentials credentials) {
        credentials = credentials.createScoped(new String[]{CLOUD_PLATFORM_SCOPE});
        String tokenServerUrl = TOKEN_SERVER_URL_SUFFIX.withPrefixes(keyPrefixes).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        if (tokenServerUrl == null) {
            return credentials;
        }
        if (credentials instanceof ServiceAccountCredentials) {
            return ((ServiceAccountCredentials)credentials).toBuilder().setTokenServerUri(URI.create(tokenServerUrl)).build();
        }
        if (credentials instanceof UserCredentials) {
            return ((UserCredentials)credentials).toBuilder().setTokenServerUri(URI.create(tokenServerUrl)).build();
        }
        return credentials;
    }

    protected HadoopCredentialsConfiguration() {
    }

    public static enum AuthenticationType {
        ACCESS_TOKEN_PROVIDER,
        APPLICATION_DEFAULT,
        COMPUTE_ENGINE,
        SERVICE_ACCOUNT_JSON_KEYFILE,
        WORKLOAD_IDENTITY_FEDERATION_CREDENTIAL_CONFIG_FILE,
        UNAUTHENTICATED,
        USER_CREDENTIALS;

    }

    public static final class AccessTokenProviderCredentials
    extends GoogleCredentials {
        private final AccessTokenProvider accessTokenProvider;

        public AccessTokenProviderCredentials(AccessTokenProvider accessTokenProvider) {
            super(AccessTokenProviderCredentials.convertAccessToken(accessTokenProvider.getAccessToken()));
            this.accessTokenProvider = accessTokenProvider;
        }

        private static AccessToken convertAccessToken(AccessTokenProvider.AccessToken accessToken) {
            Preconditions.checkNotNull((Object)accessToken, (Object)"AccessToken cannot be null!");
            String token = (String)Preconditions.checkNotNull((Object)accessToken.getToken(), (Object)"AccessToken value cannot be null!");
            Instant expirationTime = accessToken.getExpirationTime();
            return new AccessToken(token, expirationTime == null ? null : Date.from(expirationTime));
        }

        public AccessTokenProvider getAccessTokenProvider() {
            return this.accessTokenProvider;
        }

        public AccessToken refreshAccessToken() throws IOException {
            this.accessTokenProvider.refresh();
            return AccessTokenProviderCredentials.convertAccessToken(this.accessTokenProvider.getAccessToken());
        }
    }
}

