/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.httpjson;

import com.google.bigtable.repackaged.com.google.api.client.http.EmptyContent;
import com.google.bigtable.repackaged.com.google.api.client.http.GenericUrl;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpContent;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpMediaType;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequest;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpResponse;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpResponseException;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpTransport;
import com.google.bigtable.repackaged.com.google.api.client.http.json.JsonHttpContent;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonFactory;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonObjectParser;
import com.google.bigtable.repackaged.com.google.api.client.json.gson.GsonFactory;
import com.google.bigtable.repackaged.com.google.api.client.util.GenericData;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.AutoValue_HttpRequestRunnable_RunnableResult;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpHeadersUtils;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonMetadata;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.auth.http.HttpCredentialsAdapter;
import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class HttpRequestRunnable<RequestT, ResponseT>
implements Runnable {
    private final RequestT request;
    private final ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor;
    private final String endpoint;
    private final HttpJsonCallOptions httpJsonCallOptions;
    private final HttpTransport httpTransport;
    private final HttpJsonMetadata headers;
    private final ResultListener resultListener;
    private volatile boolean cancelled = false;

    HttpRequestRunnable(RequestT request, ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor, String endpoint, HttpJsonCallOptions httpJsonCallOptions, HttpTransport httpTransport, HttpJsonMetadata headers, ResultListener resultListener) {
        this.request = request;
        this.methodDescriptor = methodDescriptor;
        this.endpoint = endpoint;
        this.httpJsonCallOptions = httpJsonCallOptions;
        this.httpTransport = httpTransport;
        this.headers = headers;
        this.resultListener = resultListener;
    }

    void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RunnableResult.Builder result = RunnableResult.builder();
        HttpJsonMetadata.Builder trailers = HttpJsonMetadata.newBuilder();
        HttpResponse httpResponse = null;
        try {
            if (this.cancelled) {
                return;
            }
            HttpRequest httpRequest = this.createHttpRequest();
            if (this.cancelled) {
                return;
            }
            httpResponse = httpRequest.execute();
            if (this.cancelled) {
                httpResponse.disconnect();
                return;
            }
            result.setResponseHeaders(HttpJsonMetadata.newBuilder().setHeaders(httpResponse.getHeaders()).build());
            result.setStatusCode(httpResponse.getStatusCode());
            result.setResponseContent(httpResponse.getContent());
            trailers.setStatusMessage(httpResponse.getStatusMessage());
        }
        catch (HttpResponseException e) {
            result.setStatusCode(e.getStatusCode());
            result.setResponseHeaders(HttpJsonMetadata.newBuilder().setHeaders(e.getHeaders()).build());
            result.setResponseContent(e.getContent() != null ? new ByteArrayInputStream(e.getContent().getBytes(StandardCharsets.UTF_8)) : null);
            trailers.setStatusMessage(e.getStatusMessage());
            trailers.setException(e);
        }
        catch (Throwable e) {
            if (httpResponse != null) {
                trailers.setStatusMessage(httpResponse.getStatusMessage());
                result.setStatusCode(httpResponse.getStatusCode());
            } else {
                result.setStatusCode(400);
            }
            trailers.setException(e);
        }
        finally {
            if (!this.cancelled) {
                this.resultListener.setResult(result.setTrailers(trailers.build()).build());
            }
        }
    }

    HttpRequest createHttpRequest() throws IOException {
        HttpContent jsonHttpContent;
        GenericData tokenRequest = new GenericData();
        HttpRequestFormatter<RequestT> requestFormatter = this.methodDescriptor.getRequestFormatter();
        Credentials credentials = this.httpJsonCallOptions.getCredentials();
        HttpRequestFactory requestFactory = credentials != null ? this.httpTransport.createRequestFactory(new HttpCredentialsAdapter(credentials)) : this.httpTransport.createRequestFactory();
        GsonFactory jsonFactory = GsonFactory.getDefaultInstance();
        String requestBody = requestFormatter.getRequestBody(this.request);
        if (!Strings.isNullOrEmpty(requestBody)) {
            ((JsonFactory)jsonFactory).createJsonParser(requestBody).parse(tokenRequest);
            jsonHttpContent = new JsonHttpContent(jsonFactory, tokenRequest).setMediaType(new HttpMediaType("application/json; charset=utf-8"));
        } else {
            jsonHttpContent = new EmptyContent();
        }
        String normalizedEndpoint = this.normalizeEndpoint(this.endpoint);
        GenericUrl url = new GenericUrl(normalizedEndpoint + requestFormatter.getPath(this.request));
        Map<String, List<String>> queryParams = requestFormatter.getQueryParamNames(this.request);
        for (Map.Entry<String, List<String>> queryParam : queryParams.entrySet()) {
            if (queryParam.getValue() == null) continue;
            url.set(queryParam.getKey(), queryParam.getValue());
        }
        HttpRequest httpRequest = this.buildRequest(requestFactory, url, jsonHttpContent);
        for (Map.Entry<String, Object> entry : this.headers.getHeaders().entrySet()) {
            HttpHeadersUtils.setHeader(httpRequest.getHeaders(), entry.getKey(), (String)entry.getValue());
        }
        httpRequest.setParser(new JsonObjectParser(jsonFactory));
        return httpRequest;
    }

    private HttpRequest buildRequest(HttpRequestFactory requestFactory, GenericUrl url, HttpContent jsonHttpContent) throws IOException {
        Duration timeout;
        String actualHttpMethod;
        String originalHttpMethod = actualHttpMethod = this.methodDescriptor.getHttpMethod();
        if ("PATCH".equals(actualHttpMethod)) {
            actualHttpMethod = "POST";
        }
        HttpRequest httpRequest = requestFactory.buildRequest(actualHttpMethod, url, jsonHttpContent);
        if (originalHttpMethod != null && !originalHttpMethod.equals(actualHttpMethod)) {
            HttpHeadersUtils.setHeader(httpRequest.getHeaders(), "X-HTTP-Method-Override", originalHttpMethod);
        }
        if ((timeout = this.httpJsonCallOptions.getTimeoutDuration()) != null) {
            long timeoutMs = timeout.toMillis();
            if (this.shouldUpdateTimeout(httpRequest.getReadTimeout(), timeoutMs)) {
                httpRequest.setReadTimeout((int)timeoutMs);
            }
            if (this.shouldUpdateTimeout(httpRequest.getConnectTimeout(), timeoutMs)) {
                httpRequest.setConnectTimeout((int)timeoutMs);
            }
        }
        return httpRequest;
    }

    private boolean shouldUpdateTimeout(int currentTimeoutMs, long newTimeoutMs) {
        return currentTimeoutMs > 0 && (long)currentTimeoutMs < newTimeoutMs && newTimeoutMs < Integer.MAX_VALUE;
    }

    private String normalizeEndpoint(String rawEndpoint) {
        String normalized = rawEndpoint;
        if (!normalized.contains("://")) {
            normalized = "https://" + normalized;
        }
        if (normalized.charAt(normalized.length() - 1) != '/') {
            normalized = normalized + '/';
        }
        return normalized;
    }

    @FunctionalInterface
    static interface ResultListener {
        public void setResult(RunnableResult var1);
    }

    @AutoValue
    static abstract class RunnableResult {
        RunnableResult() {
        }

        @Nullable
        abstract HttpJsonMetadata getResponseHeaders();

        abstract int getStatusCode();

        @Nullable
        abstract InputStream getResponseContent();

        abstract HttpJsonMetadata getTrailers();

        public static Builder builder() {
            return new AutoValue_HttpRequestRunnable_RunnableResult.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setResponseHeaders(HttpJsonMetadata var1);

            public abstract Builder setStatusCode(int var1);

            public abstract Builder setResponseContent(InputStream var1);

            public abstract Builder setTrailers(HttpJsonMetadata var1);

            public abstract RunnableResult build();
        }
    }
}

