/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Backup;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateBackupRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.FieldMask;
import com.google.bigtable.repackaged.com.google.protobuf.util.FieldMaskUtil;
import com.google.bigtable.repackaged.com.google.protobuf.util.Timestamps;
import com.google.bigtable.repackaged.org.threeten.bp.Instant;
import javax.annotation.Nonnull;

public final class UpdateBackupRequest {
    private final UpdateBackupRequest.Builder requestBuilder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateBackupRequest.newBuilder();
    private final String backupId;
    private final String clusterId;

    public static UpdateBackupRequest of(String clusterId, String backupId) {
        UpdateBackupRequest request = new UpdateBackupRequest(clusterId, backupId);
        return request;
    }

    private UpdateBackupRequest(String clusterId, String backupId) {
        Preconditions.checkNotNull(clusterId);
        Preconditions.checkNotNull(backupId);
        this.backupId = backupId;
        this.clusterId = clusterId;
    }

    private void updateFieldMask(int fieldNumber) {
        FieldMask newMask = FieldMaskUtil.fromFieldNumbers(Backup.class, fieldNumber);
        this.requestBuilder.setUpdateMask(FieldMaskUtil.union(this.requestBuilder.getUpdateMask(), newMask, new FieldMask[0]));
    }

    public UpdateBackupRequest setExpireTime(Instant expireTime) {
        Preconditions.checkNotNull(expireTime);
        this.requestBuilder.getBackupBuilder().setExpireTime(Timestamps.fromMillis(expireTime.toEpochMilli()));
        this.updateFieldMask(3);
        return this;
    }

    public UpdateBackupRequest setHotToStandardTime(Instant hotToStandardTime) {
        Preconditions.checkNotNull(hotToStandardTime);
        this.requestBuilder.getBackupBuilder().setHotToStandardTime(Timestamps.fromMillis(hotToStandardTime.toEpochMilli()));
        this.updateFieldMask(12);
        return this;
    }

    public UpdateBackupRequest clearHotToStandardTime() {
        this.requestBuilder.getBackupBuilder().clearHotToStandardTime();
        this.updateFieldMask(12);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateBackupRequest that = (UpdateBackupRequest)o;
        return Objects.equal(this.requestBuilder.getBackupBuilder().getExpireTime(), that.requestBuilder.getBackupBuilder().getExpireTime()) && Objects.equal(this.requestBuilder.getBackupBuilder().getHotToStandardTime(), that.requestBuilder.getBackupBuilder().getHotToStandardTime()) && Objects.equal(this.requestBuilder.getUpdateMask(), that.requestBuilder.getUpdateMask()) && Objects.equal(this.clusterId, that.clusterId) && Objects.equal(this.backupId, that.backupId);
    }

    public int hashCode() {
        return Objects.hashCode(this.requestBuilder.getBackupBuilder().getExpireTime(), this.requestBuilder.getBackupBuilder().getHotToStandardTime(), this.requestBuilder.getUpdateMask(), this.backupId);
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateBackupRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(instanceId);
        this.requestBuilder.getBackupBuilder().setName(NameUtil.formatBackupName(projectId, instanceId, this.clusterId, this.backupId));
        return this.requestBuilder.build();
    }
}

