/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.Batcher;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiExceptions;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStream;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.ResultSetImpl;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ReadChangeStreamQuery;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ResultSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.Statement;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.sql.SqlServerStream;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BigtableDataClient
implements AutoCloseable {
    private final EnhancedBigtableStub stub;

    public static BigtableDataClient create(String projectId, String instanceId) throws IOException {
        BigtableDataSettings settings = BigtableDataSettings.newBuilder().setProjectId(projectId).setInstanceId(instanceId).build();
        return BigtableDataClient.create(settings);
    }

    public static BigtableDataClient create(BigtableDataSettings settings) throws IOException {
        EnhancedBigtableStub stub = EnhancedBigtableStub.create(settings.getStubSettings());
        return new BigtableDataClient(stub);
    }

    static BigtableDataClient createWithClientContext(BigtableDataSettings settings, ClientContext context) throws IOException {
        EnhancedBigtableStub stub = EnhancedBigtableStub.createWithClientContext(settings.getStubSettings(), context);
        return new BigtableDataClient(stub);
    }

    @InternalApi(value="Visible for testing")
    BigtableDataClient(EnhancedBigtableStub stub) {
        this.stub = stub;
    }

    @Deprecated
    public boolean exists(String tableId, String rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.existsAsync(tableId, rowKey));
    }

    @Deprecated
    public boolean exists(String tableId, ByteString rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.existsAsync(tableId, rowKey));
    }

    public boolean exists(TargetId targetId, String rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.existsAsync(targetId, rowKey));
    }

    public boolean exists(TargetId targetId, ByteString rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.existsAsync(targetId, rowKey));
    }

    @Deprecated
    public ApiFuture<Boolean> existsAsync(String tableId, String rowKey) {
        return this.existsAsync(tableId, ByteString.copyFromUtf8(rowKey));
    }

    @Deprecated
    public ApiFuture<Boolean> existsAsync(String tableId, ByteString rowKey) {
        return this.existsAsync((TargetId)TableId.of(tableId), rowKey);
    }

    public ApiFuture<Boolean> existsAsync(TargetId targetId, String rowKey) {
        return this.existsAsync(targetId, ByteString.copyFromUtf8(rowKey));
    }

    public ApiFuture<Boolean> existsAsync(TargetId targetId, ByteString rowKey) {
        Query query = Query.create(targetId).rowKey(rowKey).filter(Filters.FILTERS.chain().filter(Filters.FILTERS.limit().cellsPerRow(1)).filter(Filters.FILTERS.value().strip()));
        ApiFuture<Row> resultFuture = this.stub.readRowCallable().futureCall(query);
        return ApiFutures.transform(resultFuture, new ApiFunction<Row, Boolean>(){

            @Override
            public Boolean apply(Row row) {
                return row != null;
            }
        }, MoreExecutors.directExecutor());
    }

    @Deprecated
    public Row readRow(String tableId, ByteString rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, rowKey, null));
    }

    @Deprecated
    public Row readRow(String tableId, String rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, ByteString.copyFromUtf8(rowKey), null));
    }

    @Deprecated
    public Row readRow(String tableId, String rowKey, @Nullable Filters.Filter filter) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, ByteString.copyFromUtf8(rowKey), filter));
    }

    @Deprecated
    public Row readRow(String tableId, ByteString rowKey, @Nullable Filters.Filter filter) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, rowKey, filter));
    }

    public Row readRow(TargetId targetId, ByteString rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(targetId, rowKey, null));
    }

    public Row readRow(TargetId targetId, String rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(targetId, ByteString.copyFromUtf8(rowKey), null));
    }

    public Row readRow(TargetId targetId, String rowKey, @Nullable Filters.Filter filter) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(targetId, ByteString.copyFromUtf8(rowKey), filter));
    }

    public Row readRow(TargetId targetId, ByteString rowKey, @Nullable Filters.Filter filter) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(targetId, rowKey, filter));
    }

    @Deprecated
    public ApiFuture<Row> readRowAsync(String tableId, String rowKey) {
        return this.readRowAsync(tableId, ByteString.copyFromUtf8(rowKey), null);
    }

    @Deprecated
    public ApiFuture<Row> readRowAsync(String tableId, ByteString rowKey) {
        return this.readRowAsync(tableId, rowKey, null);
    }

    @Deprecated
    public ApiFuture<Row> readRowAsync(String tableId, String rowKey, @Nullable Filters.Filter filter) {
        return this.readRowAsync(tableId, ByteString.copyFromUtf8(rowKey), filter);
    }

    @Deprecated
    public ApiFuture<Row> readRowAsync(String tableId, ByteString rowKey, @Nullable Filters.Filter filter) {
        return this.readRowAsync((TargetId)TableId.of(tableId), rowKey, filter);
    }

    public ApiFuture<Row> readRowAsync(TargetId targetId, String rowKey) {
        return this.readRowAsync(targetId, ByteString.copyFromUtf8(rowKey), null);
    }

    public ApiFuture<Row> readRowAsync(TargetId targetId, ByteString rowKey) {
        return this.readRowAsync(targetId, rowKey, null);
    }

    public ApiFuture<Row> readRowAsync(TargetId targetId, String rowKey, @Nullable Filters.Filter filter) {
        return this.readRowAsync(targetId, ByteString.copyFromUtf8(rowKey), filter);
    }

    public ApiFuture<Row> readRowAsync(TargetId targetId, ByteString rowKey, @Nullable Filters.Filter filter) {
        Query query = Query.create(targetId).rowKey(rowKey);
        if (filter != null) {
            query = query.filter(filter);
        }
        return this.readRowCallable().futureCall(query);
    }

    public UnaryCallable<Query, Row> readRowCallable() {
        return this.stub.readRowCallable();
    }

    public <RowT> UnaryCallable<Query, RowT> readRowCallable(RowAdapter<RowT> rowAdapter) {
        return this.stub.createReadRowCallable(rowAdapter);
    }

    public ServerStream<Row> readRows(Query query) {
        return this.readRowsCallable().call(query);
    }

    public void readRowsAsync(Query query, ResponseObserver<Row> observer) {
        this.readRowsCallable().call(query, observer);
    }

    public ServerStreamingCallable<Query, Row> readRowsCallable() {
        return this.stub.readRowsCallable();
    }

    public <RowT> ServerStreamingCallable<Query, RowT> readRowsCallable(RowAdapter<RowT> rowAdapter) {
        return this.stub.createReadRowsCallable(rowAdapter);
    }

    @Deprecated
    public List<KeyOffset> sampleRowKeys(String tableId) {
        return ApiExceptions.callAndTranslateApiException(this.sampleRowKeysAsync(tableId));
    }

    public List<KeyOffset> sampleRowKeys(TargetId targetId) {
        return ApiExceptions.callAndTranslateApiException(this.sampleRowKeysAsync(targetId));
    }

    @Deprecated
    public ApiFuture<List<KeyOffset>> sampleRowKeysAsync(String tableId) {
        return this.sampleRowKeysAsync(TableId.of(tableId));
    }

    public ApiFuture<List<KeyOffset>> sampleRowKeysAsync(TargetId targetId) {
        return this.sampleRowKeysCallableWithRequest().futureCall(SampleRowKeysRequest.create(targetId));
    }

    @Deprecated
    public UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable() {
        return this.stub.sampleRowKeysCallable();
    }

    public UnaryCallable<SampleRowKeysRequest, List<KeyOffset>> sampleRowKeysCallableWithRequest() {
        return this.stub.sampleRowKeysCallableWithRequest();
    }

    public void mutateRow(RowMutation rowMutation) {
        ApiExceptions.callAndTranslateApiException(this.mutateRowAsync(rowMutation));
    }

    public ApiFuture<Void> mutateRowAsync(RowMutation rowMutation) {
        return this.mutateRowCallable().futureCall(rowMutation);
    }

    public UnaryCallable<RowMutation, Void> mutateRowCallable() {
        return this.stub.mutateRowCallable();
    }

    public void bulkMutateRows(BulkMutation mutation) {
        ApiExceptions.callAndTranslateApiException(this.bulkMutateRowsAsync(mutation));
    }

    @Deprecated
    public Batcher<RowMutationEntry, Void> newBulkMutationBatcher(@Nonnull String tableId) {
        return this.newBulkMutationBatcher(tableId, null);
    }

    @Deprecated
    @BetaApi(value="This surface is likely to change as the batching surface evolves.")
    public Batcher<RowMutationEntry, Void> newBulkMutationBatcher(@Nonnull String tableId, @Nullable GrpcCallContext ctx) {
        return this.stub.newMutateRowsBatcher(tableId, ctx);
    }

    @BetaApi(value="This surface is likely to change as the batching surface evolves.")
    public Batcher<RowMutationEntry, Void> newBulkMutationBatcher(TargetId targetId) {
        return this.newBulkMutationBatcher(targetId, null);
    }

    @BetaApi(value="This surface is likely to change as the batching surface evolves.")
    public Batcher<RowMutationEntry, Void> newBulkMutationBatcher(TargetId targetId, @Nullable GrpcCallContext ctx) {
        return this.stub.newMutateRowsBatcher(targetId, ctx);
    }

    @Deprecated
    public Batcher<ByteString, Row> newBulkReadRowsBatcher(String tableId) {
        return this.newBulkReadRowsBatcher(tableId, null);
    }

    @Deprecated
    public Batcher<ByteString, Row> newBulkReadRowsBatcher(String tableId, @Nullable Filters.Filter filter) {
        return this.newBulkReadRowsBatcher(tableId, filter, null);
    }

    @Deprecated
    public Batcher<ByteString, Row> newBulkReadRowsBatcher(String tableId, @Nullable Filters.Filter filter, @Nullable GrpcCallContext ctx) {
        return this.newBulkReadRowsBatcher(TableId.of(tableId), filter, ctx);
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(TargetId targetId) {
        return this.newBulkReadRowsBatcher(targetId, null);
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(TargetId targetId, @Nullable Filters.Filter filter) {
        return this.newBulkReadRowsBatcher(targetId, filter, null);
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(TargetId targetId, @Nullable Filters.Filter filter, @Nullable GrpcCallContext ctx) {
        Query query = Query.create(targetId);
        if (filter != null) {
            query = query.filter(filter);
        }
        return this.stub.newBulkReadRowsBatcher(query, ctx);
    }

    public ApiFuture<Void> bulkMutateRowsAsync(BulkMutation mutation) {
        return this.bulkMutationCallable().futureCall(mutation);
    }

    public UnaryCallable<BulkMutation, Void> bulkMutationCallable() {
        return this.stub.bulkMutateRowsCallable();
    }

    public Boolean checkAndMutateRow(ConditionalRowMutation mutation) {
        return ApiExceptions.callAndTranslateApiException(this.checkAndMutateRowAsync(mutation));
    }

    public ApiFuture<Boolean> checkAndMutateRowAsync(ConditionalRowMutation mutation) {
        return this.checkAndMutateRowCallable().futureCall(mutation);
    }

    public UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable() {
        return this.stub.checkAndMutateRowCallable();
    }

    public Row readModifyWriteRow(ReadModifyWriteRow mutation) {
        return ApiExceptions.callAndTranslateApiException(this.readModifyWriteRowAsync(mutation));
    }

    public ApiFuture<Row> readModifyWriteRowAsync(ReadModifyWriteRow mutation) {
        return this.readModifyWriteRowCallable().futureCall(mutation);
    }

    public UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable() {
        return this.stub.readModifyWriteRowCallable();
    }

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    public ServerStream<Range.ByteStringRange> generateInitialChangeStreamPartitions(String tableId) {
        return this.generateInitialChangeStreamPartitionsCallable().call(tableId);
    }

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    public void generateInitialChangeStreamPartitionsAsync(String tableId, ResponseObserver<Range.ByteStringRange> observer) {
        this.generateInitialChangeStreamPartitionsCallable().call(tableId, observer);
    }

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    public ServerStreamingCallable<String, Range.ByteStringRange> generateInitialChangeStreamPartitionsCallable() {
        return this.stub.generateInitialChangeStreamPartitionsCallable();
    }

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    public ServerStream<ChangeStreamRecord> readChangeStream(ReadChangeStreamQuery query) {
        return this.readChangeStreamCallable().call(query);
    }

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    public void readChangeStreamAsync(ReadChangeStreamQuery query, ResponseObserver<ChangeStreamRecord> observer) {
        this.readChangeStreamCallable().call(query, observer);
    }

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    public ServerStreamingCallable<ReadChangeStreamQuery, ChangeStreamRecord> readChangeStreamCallable() {
        return this.stub.readChangeStreamCallable();
    }

    @BetaApi
    public ResultSet executeQuery(Statement statement) {
        SqlServerStream stream = this.stub.createExecuteQueryCallable().call(statement);
        return ResultSetImpl.create(stream);
    }

    @Override
    public void close() {
        this.stub.close();
    }
}

