/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ColumnMetadata;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ProtoSchema;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ResultSetMetadata;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Type;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.ColumnMetadataImpl;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.ColumnToIndexMapper;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

@InternalApi
public class ProtoResultSetMetadata
extends ColumnToIndexMapper
implements ResultSetMetadata {
    private final List<com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ColumnMetadata> columns;

    public static ResultSetMetadata create(List<com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ColumnMetadata> columns) {
        return new ProtoResultSetMetadata(columns);
    }

    private ProtoResultSetMetadata(List<com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ColumnMetadata> columns) {
        super(columns);
        this.columns = ImmutableList.copyOf(columns);
    }

    @Override
    public List<com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ColumnMetadata> getColumns() {
        return this.columns;
    }

    @Override
    public SqlType<?> getColumnType(int columnIndex) {
        return this.columns.get(columnIndex).type();
    }

    @Override
    public SqlType<?> getColumnType(String columnName) {
        return this.getColumnType(this.getColumnIndex(columnName));
    }

    @InternalApi
    public static ResultSetMetadata fromProto(com.google.bigtable.repackaged.com.google.bigtable.v2.ResultSetMetadata proto) {
        Preconditions.checkState(proto.getSchemaCase().equals(ResultSetMetadata.SchemaCase.PROTO_SCHEMA), "Unsupported schema type: %s", (Object)proto.getSchemaCase().name());
        ProtoSchema schema = proto.getProtoSchema();
        ProtoResultSetMetadata.validateSchema(schema);
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        for (ColumnMetadata protoColumn : schema.getColumnsList()) {
            columnsBuilder.add(ColumnMetadataImpl.fromProto(protoColumn));
        }
        return ProtoResultSetMetadata.create((List<com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ColumnMetadata>)((Object)columnsBuilder.build()));
    }

    private static void validateSchema(ProtoSchema schema) {
        List<ColumnMetadata> columns = schema.getColumnsList();
        Preconditions.checkState(!columns.isEmpty(), "columns cannot be empty");
        for (ColumnMetadata column : columns) {
            Preconditions.checkState(column.getType().getKindCase() != Type.KindCase.KIND_NOT_SET, "Column type cannot be empty");
        }
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof ProtoResultSetMetadata) {
            ProtoResultSetMetadata o = (ProtoResultSetMetadata)other;
            return this.columns.equals(o.columns);
        }
        return false;
    }
}

