/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.FixedCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.ChannelPrimer;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;

@BetaApi(value="Channel priming is not currently stable and might change in the future")
class BigtableChannelPrimer
implements ChannelPrimer {
    private static Logger LOG = Logger.getLogger(BigtableChannelPrimer.class.toString());
    private final EnhancedBigtableStubSettings settingsTemplate;

    static BigtableChannelPrimer create(Credentials credentials, String projectId, String instanceId, String appProfileId) {
        EnhancedBigtableStubSettings.Builder builder = (EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)EnhancedBigtableStubSettings.newBuilder().setProjectId(projectId).setInstanceId(instanceId).setAppProfileId(appProfileId).setCredentialsProvider(FixedCredentialsProvider.create(credentials))).setRefreshingChannel(false).setExecutorProvider(InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(1).build());
        return new BigtableChannelPrimer(builder.build());
    }

    private BigtableChannelPrimer(EnhancedBigtableStubSettings settingsTemplate) {
        Preconditions.checkNotNull(settingsTemplate, "settingsTemplate can't be null");
        this.settingsTemplate = settingsTemplate;
    }

    @Override
    public void primeChannel(ManagedChannel managedChannel) {
        try {
            this.primeChannelUnsafe(managedChannel);
        }
        catch (IOException | RuntimeException e) {
            LOG.warning(String.format("Unexpected error while trying to prime a channel: %s", e.getMessage()));
        }
    }

    private void primeChannelUnsafe(ManagedChannel managedChannel) throws IOException {
        this.sendPrimeRequests(managedChannel);
    }

    private void sendPrimeRequests(ManagedChannel managedChannel) throws IOException {
        EnhancedBigtableStubSettings primingSettings = ((EnhancedBigtableStubSettings.Builder)this.settingsTemplate.toBuilder().setTransportChannelProvider(FixedTransportChannelProvider.create(GrpcTransportChannel.create(managedChannel)))).build();
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create(primingSettings);){
            PingAndWarmRequest request = PingAndWarmRequest.newBuilder().setName(NameUtil.formatInstanceName(primingSettings.getProjectId(), primingSettings.getInstanceId())).setAppProfileId(primingSettings.getAppProfileId()).build();
            try {
                stub.pingAndWarmCallable().call(request);
            }
            catch (Throwable e) {
                if (e instanceof ExecutionException) {
                    e = e.getCause();
                }
                LOG.warning(String.format("Failed to prime channel: %s", e));
            }
        }
    }
}

