/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.InternalException;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StreamController;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.SafeResponseObserver;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;

final class ConvertExceptionCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> innerCallable;

    public ConvertExceptionCallable(ServerStreamingCallable<RequestT, ResponseT> innerCallable) {
        this.innerCallable = innerCallable;
    }

    @Override
    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        ConvertExceptionResponseObserver<ResponseT> observer = new ConvertExceptionResponseObserver<ResponseT>(responseObserver);
        this.innerCallable.call(request, observer, context);
    }

    private Throwable convertException(Throwable t) {
        if (this.isRstStreamError(t) || this.isGoAway(t) || this.isRetriableAuthError(t)) {
            return new InternalException(t, ((InternalException)t).getStatusCode(), true);
        }
        return t;
    }

    private boolean isRetriableAuthError(Throwable t) {
        if (t instanceof InternalException && t.getMessage() != null) {
            String error = t.getMessage();
            return error.contains("Authentication backend internal server error. Please retry");
        }
        return false;
    }

    private boolean isRstStreamError(Throwable t) {
        if (t instanceof InternalException && t.getMessage() != null) {
            String error = t.getMessage().toLowerCase();
            return error.contains("rst_stream") || error.contains("rst stream");
        }
        return false;
    }

    private boolean isGoAway(Throwable t) {
        if (t instanceof InternalException) {
            Throwable rootCause = Throwables.getRootCause(t);
            String rootCauseMessage = rootCause.getMessage();
            return rootCauseMessage != null && rootCauseMessage.contains("Stream closed before write could take place");
        }
        return false;
    }

    private class ConvertExceptionResponseObserver<ResponseT>
    extends SafeResponseObserver<ResponseT> {
        private final ResponseObserver<ResponseT> outerObserver;

        ConvertExceptionResponseObserver(ResponseObserver<ResponseT> outerObserver) {
            super(outerObserver);
            this.outerObserver = outerObserver;
        }

        @Override
        protected void onStartImpl(StreamController controller) {
            this.outerObserver.onStart(controller);
        }

        @Override
        protected void onResponseImpl(ResponseT response) {
            this.outerObserver.onResponse(response);
        }

        @Override
        protected void onErrorImpl(Throwable t) {
            this.outerObserver.onError(ConvertExceptionCallable.this.convertException(t));
        }

        @Override
        protected void onCompleteImpl() {
            this.outerObserver.onComplete();
        }
    }
}

