/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableCloudMonitoringExporter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentSelector;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.View;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;

public class BuiltinMetricsView {
    private BuiltinMetricsView() {
    }

    public static void registerBuiltinMetrics(String projectId, SdkMeterProviderBuilder builder) throws IOException {
        BuiltinMetricsView.registerBuiltinMetrics(projectId, GoogleCredentials.getApplicationDefault(), builder);
    }

    public static void registerBuiltinMetrics(String projectId, @Nullable Credentials credentials, SdkMeterProviderBuilder builder) throws IOException {
        BuiltinMetricsView.registerBuiltinMetrics(projectId, credentials, builder, null);
    }

    public static void registerBuiltinMetrics(String projectId, @Nullable Credentials credentials, SdkMeterProviderBuilder builder, @Nullable String endpoint) throws IOException {
        BigtableCloudMonitoringExporter metricExporter = BigtableCloudMonitoringExporter.create(projectId, credentials, endpoint);
        for (Map.Entry<InstrumentSelector, View> entry : BuiltinMetricsConstants.getAllViews().entrySet()) {
            builder.registerView(entry.getKey(), entry.getValue());
        }
        builder.registerMetricReader(PeriodicMetricReader.create(metricExporter));
    }
}

