/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.SettableApiFuture;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StreamController;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.ProtoResultSetMetadata;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.SafeResponseObserver;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.sql.ExecuteQueryCallContext;

@InternalApi(value="For internal use only")
public class MetadataResolvingCallable
extends ServerStreamingCallable<ExecuteQueryCallContext, ExecuteQueryResponse> {
    private final ServerStreamingCallable<ExecuteQueryRequest, ExecuteQueryResponse> inner;

    public MetadataResolvingCallable(ServerStreamingCallable<ExecuteQueryRequest, ExecuteQueryResponse> inner) {
        this.inner = inner;
    }

    @Override
    public void call(ExecuteQueryCallContext callContext, ResponseObserver<ExecuteQueryResponse> responseObserver, ApiCallContext apiCallContext) {
        MetadataObserver observer = new MetadataObserver(responseObserver, callContext.resultSetMetadataFuture());
        this.inner.call(callContext.request(), observer, apiCallContext);
    }

    static final class MetadataObserver
    extends SafeResponseObserver<ExecuteQueryResponse> {
        private final SettableApiFuture<ResultSetMetadata> metadataFuture;
        private final ResponseObserver<ExecuteQueryResponse> outerObserver;
        private boolean isFirstResponse;

        MetadataObserver(ResponseObserver<ExecuteQueryResponse> outerObserver, SettableApiFuture<ResultSetMetadata> metadataFuture) {
            super(outerObserver);
            this.outerObserver = outerObserver;
            this.metadataFuture = metadataFuture;
            this.isFirstResponse = true;
        }

        @Override
        protected void onStartImpl(StreamController streamController) {
            this.outerObserver.onStart(streamController);
        }

        @Override
        protected void onResponseImpl(ExecuteQueryResponse response) {
            if (this.isFirstResponse && !response.hasMetadata()) {
                IllegalStateException e = new IllegalStateException("First response must always contain metadata");
                this.metadataFuture.setException(e);
                throw e;
            }
            this.isFirstResponse = false;
            if (response.hasMetadata()) {
                try {
                    ResultSetMetadata md = ProtoResultSetMetadata.fromProto(response.getMetadata());
                    this.metadataFuture.set(md);
                }
                catch (Throwable t) {
                    this.metadataFuture.setException(t);
                    throw t;
                }
            }
            this.outerObserver.onResponse(response);
        }

        @Override
        protected void onErrorImpl(Throwable throwable) {
            this.metadataFuture.setException(throwable);
            this.outerObserver.onError(throwable);
        }

        @Override
        protected void onCompleteImpl() {
            if (!this.metadataFuture.isDone()) {
                IllegalStateException missingMetadataException = new IllegalStateException("Unexpected Stream complete without receiving metadata");
                this.metadataFuture.setException(missingMetadataException);
                throw missingMetadataException;
            }
            this.outerObserver.onComplete();
        }
    }
}

