/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ObsoleteApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.GaxProperties;
import com.google.bigtable.repackaged.com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PageContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedListDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StubSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.QueryServiceClient;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub.GrpcQueryServiceStub;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub.QueryServiceStub;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.com.google.monitoring.v3.QueryTimeSeriesRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.QueryTimeSeriesResponse;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TimeSeriesData;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public class QueryServiceStubSettings
extends StubSettings<QueryServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/monitoring")).add("https://www.googleapis.com/auth/monitoring.read")).build();
    private final PagedCallSettings<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse> queryTimeSeriesSettings;
    private static final PagedListDescriptor<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData> QUERY_TIME_SERIES_PAGE_STR_DESC = new PagedListDescriptor<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public QueryTimeSeriesRequest injectToken(QueryTimeSeriesRequest payload, String token) {
            return QueryTimeSeriesRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public QueryTimeSeriesRequest injectPageSize(QueryTimeSeriesRequest payload, int pageSize) {
            return QueryTimeSeriesRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(QueryTimeSeriesRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(QueryTimeSeriesResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<TimeSeriesData> extractResources(QueryTimeSeriesResponse payload) {
            return payload.getTimeSeriesDataList();
        }
    };
    private static final PagedListResponseFactory<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse> QUERY_TIME_SERIES_PAGE_STR_FACT = new PagedListResponseFactory<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse>(){

        @Override
        public ApiFuture<QueryServiceClient.QueryTimeSeriesPagedResponse> getFuturePagedResponse(UnaryCallable<QueryTimeSeriesRequest, QueryTimeSeriesResponse> callable, QueryTimeSeriesRequest request, ApiCallContext context, ApiFuture<QueryTimeSeriesResponse> futureResponse) {
            PageContext<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData> pageContext = PageContext.create(callable, QUERY_TIME_SERIES_PAGE_STR_DESC, request, context);
            return QueryServiceClient.QueryTimeSeriesPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public PagedCallSettings<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse> queryTimeSeriesSettings() {
        return this.queryTimeSeriesSettings;
    }

    public QueryServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcQueryServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    @Override
    public String getServiceName() {
        return "monitoring";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "monitoring.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.MAX_VALUE);
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return QueryServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(QueryServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected QueryServiceStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.queryTimeSeriesSettings = settingsBuilder.queryTimeSeriesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<QueryServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse> queryTimeSeriesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.queryTimeSeriesSettings = PagedCallSettings.newBuilder(QUERY_TIME_SERIES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.queryTimeSeriesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(QueryServiceStubSettings settings) {
            super(settings);
            this.queryTimeSeriesSettings = settings.queryTimeSeriesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.queryTimeSeriesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(QueryServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(QueryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(QueryServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(QueryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            ((PagedCallSettings.Builder)builder.queryTimeSeriesSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<QueryTimeSeriesRequest, QueryTimeSeriesResponse, QueryServiceClient.QueryTimeSeriesPagedResponse> queryTimeSeriesSettings() {
            return this.queryTimeSeriesSettings;
        }

        public QueryServiceStubSettings build() throws IOException {
            return new QueryServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("no_retry_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put("no_retry_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

