/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection;

import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.DetectedPlatform;
import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.EnvironmentVariables;
import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.GCPMetadataConfig;
import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.GCPPlatformDetector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class GoogleAppEngine
implements DetectedPlatform {
    private final EnvironmentVariables environmentVariables;
    private final GCPMetadataConfig metadataConfig;
    private final Map<String, String> availableAttributes;

    GoogleAppEngine(EnvironmentVariables environmentVariables, GCPMetadataConfig metadataConfig) {
        this.environmentVariables = environmentVariables;
        this.metadataConfig = metadataConfig;
        this.availableAttributes = this.prepareAttributes();
    }

    private Map<String, String> prepareAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("gae_module_name", this.environmentVariables.get("GAE_SERVICE"));
        map.put("gae_app_version", this.environmentVariables.get("GAE_VERSION"));
        map.put("instance_id", this.environmentVariables.get("GAE_INSTANCE"));
        map.put("availability_zone", this.metadataConfig.getZone());
        map.put("cloud_region", this.getCloudRegion());
        return Collections.unmodifiableMap(map);
    }

    private String getCloudRegion() {
        if (this.environmentVariables.get("GAE_ENV") != null && this.environmentVariables.get("GAE_ENV").equals("standard")) {
            return this.metadataConfig.getRegion();
        }
        return this.metadataConfig.getRegionFromZone();
    }

    @Override
    public GCPPlatformDetector.SupportedPlatform getSupportedPlatform() {
        return GCPPlatformDetector.SupportedPlatform.GOOGLE_APP_ENGINE;
    }

    @Override
    public String getProjectId() {
        return this.metadataConfig.getProjectId();
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.availableAttributes;
    }
}

