/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.metrics.ocagent;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.metrics.v1.ExportMetricsServiceRequest;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.metrics.v1.ExportMetricsServiceResponse;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.metrics.v1.MetricsServiceGrpc;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class OcAgentMetricsServiceExportRpcHandler {
    private static final Logger logger = Logger.getLogger(OcAgentMetricsServiceExportRpcHandler.class.getName());
    @Nullable
    @GuardedBy(value="this")
    private StreamObserver<ExportMetricsServiceRequest> exportRequestObserver;
    @Nullable
    @GuardedBy(value="this")
    private Status terminateStatus;

    private OcAgentMetricsServiceExportRpcHandler() {
    }

    private synchronized void setExportRequestObserver(StreamObserver<ExportMetricsServiceRequest> exportRequestObserver) {
        this.exportRequestObserver = exportRequestObserver;
    }

    static OcAgentMetricsServiceExportRpcHandler create(MetricsServiceGrpc.MetricsServiceStub stub) {
        OcAgentMetricsServiceExportRpcHandler exportRpcHandler = new OcAgentMetricsServiceExportRpcHandler();
        ExportResponseObserver exportResponseObserver = new ExportResponseObserver(exportRpcHandler);
        try {
            StreamObserver<ExportMetricsServiceRequest> exportRequestObserver = stub.export(exportResponseObserver);
            exportRpcHandler.setExportRequestObserver(exportRequestObserver);
        }
        catch (StatusRuntimeException e) {
            exportRpcHandler.onComplete(e);
        }
        return exportRpcHandler;
    }

    synchronized void onExport(ExportMetricsServiceRequest request) {
        if (this.isCompleted() || this.exportRequestObserver == null) {
            return;
        }
        try {
            this.exportRequestObserver.onNext(request);
        }
        catch (Exception e) {
            this.onComplete(e);
        }
    }

    synchronized void onComplete(@Nullable Throwable error) {
        if (this.isCompleted()) {
            return;
        }
        Status status = error == null ? Status.OK : (error instanceof StatusRuntimeException ? ((StatusRuntimeException)error).getStatus() : Status.UNKNOWN);
        this.terminateStatus = status;
    }

    synchronized boolean isCompleted() {
        return this.terminateStatus != null;
    }

    @Nullable
    synchronized Status getTerminateStatus() {
        return this.terminateStatus;
    }

    @VisibleForTesting
    static class ExportResponseObserver
    implements StreamObserver<ExportMetricsServiceResponse> {
        private final OcAgentMetricsServiceExportRpcHandler exportRpcHandler;

        ExportResponseObserver(OcAgentMetricsServiceExportRpcHandler exportRpcHandler) {
            this.exportRpcHandler = exportRpcHandler;
        }

        @Override
        public void onNext(ExportMetricsServiceResponse value) {
        }

        @Override
        public void onError(Throwable t) {
            logger.log(Level.WARNING, "Export stream is disconnected.", t);
            this.exportRpcHandler.onComplete(t);
        }

        @Override
        public void onCompleted() {
            this.exportRpcHandler.onComplete(null);
        }
    }
}

