/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.trace.v1.ExportTraceServiceRequest;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.trace.v1.ExportTraceServiceResponse;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.trace.v1.TraceServiceGrpc;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class OcAgentTraceServiceExportRpcHandler {
    private static final Logger logger = Logger.getLogger(OcAgentTraceServiceExportRpcHandler.class.getName());
    @Nullable
    @GuardedBy(value="this")
    private StreamObserver<ExportTraceServiceRequest> exportRequestObserver;
    @Nullable
    @GuardedBy(value="this")
    private Status terminateStatus;

    private OcAgentTraceServiceExportRpcHandler() {
    }

    private synchronized void setExportRequestObserver(StreamObserver<ExportTraceServiceRequest> exportRequestObserver) {
        this.exportRequestObserver = exportRequestObserver;
    }

    static OcAgentTraceServiceExportRpcHandler create(TraceServiceGrpc.TraceServiceStub stub) {
        OcAgentTraceServiceExportRpcHandler exportRpcHandler = new OcAgentTraceServiceExportRpcHandler();
        ExportResponseObserver exportResponseObserver = new ExportResponseObserver(exportRpcHandler);
        try {
            StreamObserver<ExportTraceServiceRequest> exportRequestObserver = stub.export(exportResponseObserver);
            exportRpcHandler.setExportRequestObserver(exportRequestObserver);
        }
        catch (StatusRuntimeException e) {
            exportRpcHandler.onComplete(e);
        }
        return exportRpcHandler;
    }

    synchronized void onExport(ExportTraceServiceRequest request) {
        if (this.isCompleted() || this.exportRequestObserver == null) {
            return;
        }
        try {
            this.exportRequestObserver.onNext(request);
        }
        catch (Exception e) {
            this.onComplete(e);
        }
    }

    synchronized void onComplete(@Nullable Throwable error) {
        if (this.isCompleted()) {
            return;
        }
        Status status = error == null ? Status.OK : (error instanceof StatusRuntimeException ? ((StatusRuntimeException)error).getStatus() : Status.UNKNOWN);
        this.terminateStatus = status;
    }

    synchronized boolean isCompleted() {
        return this.terminateStatus != null;
    }

    @Nullable
    @VisibleForTesting
    synchronized Status getTerminateStatus() {
        return this.terminateStatus;
    }

    @VisibleForTesting
    static class ExportResponseObserver
    implements StreamObserver<ExportTraceServiceResponse> {
        private final OcAgentTraceServiceExportRpcHandler exportRpcHandler;

        ExportResponseObserver(OcAgentTraceServiceExportRpcHandler exportRpcHandler) {
            this.exportRpcHandler = exportRpcHandler;
        }

        @Override
        public void onNext(ExportTraceServiceResponse value) {
        }

        @Override
        public void onError(Throwable t) {
            logger.log(Level.WARNING, "Export stream is disconnected.", t);
            this.exportRpcHandler.onComplete(t);
        }

        @Override
        public void onCompleted() {
            this.exportRpcHandler.onComplete(null);
        }
    }
}

