/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.api.common;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.Value;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.ValueType;
import java.util.Objects;

final class ValueString
implements Value<String> {
    private final String value;

    private ValueString(String value) {
        this.value = value;
    }

    static Value<String> create(String value) {
        Objects.requireNonNull(value, "value must not be null");
        return new ValueString(value);
    }

    @Override
    public ValueType getType() {
        return ValueType.STRING;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.value;
    }

    public String toString() {
        return "ValueString{" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Value && Objects.equals(this.value, ((Value)o).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

