/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.api.incubator.propagation;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

class CaseInsensitiveMap
extends HashMap<String, String> {
    private static final long serialVersionUID = -4202518750189126871L;

    CaseInsensitiveMap() {
    }

    CaseInsensitiveMap(Map<String, String> carrier) {
        if (carrier != null) {
            this.putAll((Map<? extends String, ? extends String>)carrier);
        }
    }

    @Override
    public String put(String key, String value) {
        return super.put(CaseInsensitiveMap.getKeyLowerCase(key), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        m.forEach(this::put);
    }

    private static String getKeyLowerCase(String key) {
        return key.toLowerCase(Locale.ROOT);
    }

    @Override
    @Nullable
    public String get(Object key) {
        return (String)super.get(CaseInsensitiveMap.getKeyLowerCase((String)key));
    }
}

