/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics;

import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.Clock;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.internal.ScopeConfigurator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.internal.ScopeConfiguratorBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentSelector;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.View;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.export.MetricProducer;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.export.MetricReader;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.MeterConfig;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.export.CardinalityLimitSelector;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public final class SdkMeterProviderBuilder {
    private static final ExemplarFilter DEFAULT_EXEMPLAR_FILTER = ExemplarFilter.traceBased();
    private Clock clock = Clock.getDefault();
    private Resource resource = Resource.getDefault();
    private final IdentityHashMap<MetricReader, CardinalityLimitSelector> metricReaders = new IdentityHashMap();
    private final List<MetricProducer> metricProducers = new ArrayList<MetricProducer>();
    private final List<RegisteredView> registeredViews = new ArrayList<RegisteredView>();
    private ExemplarFilter exemplarFilter = DEFAULT_EXEMPLAR_FILTER;
    private ScopeConfiguratorBuilder<MeterConfig> meterConfiguratorBuilder = MeterConfig.configuratorBuilder();

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkMeterProviderBuilder addResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = this.resource.merge(resource);
        return this;
    }

    SdkMeterProviderBuilder setExemplarFilter(ExemplarFilter filter) {
        this.exemplarFilter = filter;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector selector, View view) {
        Objects.requireNonNull(selector, "selector");
        Objects.requireNonNull(view, "view");
        this.registeredViews.add(RegisteredView.create(selector, view, view.getAttributesProcessor(), view.getCardinalityLimit(), SourceInfo.fromCurrentStack()));
        return this;
    }

    public SdkMeterProviderBuilder registerMetricReader(MetricReader reader) {
        this.metricReaders.put(reader, CardinalityLimitSelector.defaultCardinalityLimitSelector());
        return this;
    }

    SdkMeterProviderBuilder registerMetricReader(MetricReader reader, CardinalityLimitSelector cardinalityLimitSelector) {
        this.metricReaders.put(reader, cardinalityLimitSelector);
        return this;
    }

    public SdkMeterProviderBuilder registerMetricProducer(MetricProducer metricProducer) {
        this.metricProducers.add(metricProducer);
        return this;
    }

    SdkMeterProviderBuilder setMeterConfigurator(ScopeConfigurator<MeterConfig> meterConfigurator) {
        this.meterConfiguratorBuilder = meterConfigurator.toBuilder();
        return this;
    }

    SdkMeterProviderBuilder addMeterConfiguratorCondition(Predicate<InstrumentationScopeInfo> scopeMatcher, MeterConfig meterConfig) {
        this.meterConfiguratorBuilder.addCondition(scopeMatcher, meterConfig);
        return this;
    }

    public SdkMeterProvider build() {
        return new SdkMeterProvider(this.registeredViews, this.metricReaders, this.metricProducers, this.clock, this.resource, this.exemplarFilter, this.meterConfiguratorBuilder.build());
    }
}

