/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.exemplar;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.api.trace.Span;
import com.google.bigtable.repackaged.io.opentelemetry.context.Context;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;

public final class TraceBasedExemplarFilter
implements ExemplarFilter {
    static final ExemplarFilter INSTANCE = new TraceBasedExemplarFilter();

    private TraceBasedExemplarFilter() {
    }

    @Override
    public boolean shouldSampleMeasurement(long value, Attributes attributes, Context context) {
        return TraceBasedExemplarFilter.hasSampledTrace(context);
    }

    @Override
    public boolean shouldSampleMeasurement(double value, Attributes attributes, Context context) {
        return TraceBasedExemplarFilter.hasSampledTrace(context);
    }

    private static boolean hasSampledTrace(Context context) {
        return Span.fromContext(context).getSpanContext().isSampled();
    }
}

