/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.internal;

import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.internal.ScopeConfigurator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.internal.TracerConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Predicate;

public final class SdkTracerProviderUtil {
    private SdkTracerProviderUtil() {
    }

    public static void setTracerConfigurator(SdkTracerProviderBuilder sdkTracerProviderBuilder, ScopeConfigurator<TracerConfig> tracerConfigurator) {
        try {
            Method method = SdkTracerProviderBuilder.class.getDeclaredMethod("setTracerConfigurator", ScopeConfigurator.class);
            method.setAccessible(true);
            method.invoke((Object)sdkTracerProviderBuilder, tracerConfigurator);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setTracerConfigurator on SdkTracerProviderBuilder", e);
        }
    }

    public static void addTracerConfiguratorCondition(SdkTracerProviderBuilder sdkTracerProviderBuilder, Predicate<InstrumentationScopeInfo> scopeMatcher, TracerConfig tracerConfig) {
        try {
            Method method = SdkTracerProviderBuilder.class.getDeclaredMethod("addTracerConfiguratorCondition", Predicate.class, TracerConfig.class);
            method.setAccessible(true);
            method.invoke((Object)sdkTracerProviderBuilder, scopeMatcher, tracerConfig);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling addTracerConfiguratorCondition on SdkTracerProviderBuilder", e);
        }
    }
}

