/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public class ColumnRangeFilterAdapter
extends TypedFilterAdapterBase<ColumnRangeFilter> {
    private static final String REQUIRE_SINGLE_FAMILY_MESSAGE = "Scan or Get operations using ColumnRangeFilter must have a single family specified with #addFamily().";
    private static final FilterSupportStatus UNSUPPORTED_STATUS = FilterSupportStatus.newNotSupported("Scan or Get operations using ColumnRangeFilter must have a single family specified with #addFamily().");

    @Override
    public Filters.Filter adapt(FilterAdapterContext context, ColumnRangeFilter filter) throws IOException {
        byte[] familyName = this.getSingleFamily(context.getScan());
        Filters.QualifierRangeFilter rangeBuilder = Filters.FILTERS.qualifier().rangeWithinFamily(Bytes.toString((byte[])familyName));
        if (filter.getMinColumn() != null) {
            ByteString startQualifier = ByteString.copyFrom(filter.getMinColumn());
            if (filter.getMinColumnInclusive()) {
                rangeBuilder.startClosed(startQualifier);
            } else {
                rangeBuilder.startOpen(startQualifier);
            }
        }
        if (filter.getMaxColumn() != null) {
            ByteString endQualifier = ByteString.copyFrom(filter.getMaxColumn());
            if (filter.getMaxColumnInclusive()) {
                rangeBuilder.endClosed(endQualifier);
            } else {
                rangeBuilder.endOpen(endQualifier);
            }
        }
        return rangeBuilder;
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, ColumnRangeFilter filter) {
        int familyCount = context.getScan().numFamilies();
        if (familyCount != 1) {
            return UNSUPPORTED_STATUS;
        }
        return FilterSupportStatus.SUPPORTED;
    }

    byte[] getSingleFamily(Scan scan) {
        return scan.getFamilies()[0];
    }
}

