/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.api.core.InternalApi;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;

@InternalApi(value="For internal usage only")
public class RowCell
implements Cell {
    private final byte[] rowArray;
    private final byte[] familyArray;
    private final byte[] qualifierArray;
    private final long timestamp;
    private final byte[] valueArray;
    private final List<String> labels;

    public RowCell(byte[] rowArray, byte[] familyArray, byte[] qualifierArray, long timestamp, byte[] valueArray) {
        this(rowArray, familyArray, qualifierArray, timestamp, valueArray, (List<String>)ImmutableList.of());
    }

    public RowCell(byte[] rowArray, byte[] familyArray, byte[] qualifierArray, long timestamp, byte[] valueArray, List<String> labels) {
        this.rowArray = rowArray;
        this.familyArray = familyArray;
        this.qualifierArray = qualifierArray;
        this.timestamp = timestamp;
        this.valueArray = valueArray;
        this.labels = labels;
    }

    public byte[] getRowArray() {
        return this.rowArray;
    }

    public int getRowOffset() {
        return 0;
    }

    public short getRowLength() {
        return (short)this.rowArray.length;
    }

    public byte[] getFamilyArray() {
        return this.familyArray;
    }

    public int getFamilyOffset() {
        return 0;
    }

    public byte getFamilyLength() {
        return (byte)this.familyArray.length;
    }

    public byte[] getQualifierArray() {
        return this.qualifierArray;
    }

    public int getQualifierOffset() {
        return 0;
    }

    public int getQualifierLength() {
        return this.qualifierArray.length;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte getTypeByte() {
        return KeyValue.Type.Put.getCode();
    }

    @Deprecated
    public long getMvccVersion() {
        return 0L;
    }

    public long getSequenceId() {
        return 0L;
    }

    public byte[] getValueArray() {
        return this.valueArray;
    }

    public int getValueOffset() {
        return 0;
    }

    public int getValueLength() {
        return this.valueArray.length;
    }

    public byte[] getTagsArray() {
        return HConstants.EMPTY_BYTE_ARRAY;
    }

    public int getTagsOffset() {
        return 0;
    }

    public int getTagsLength() {
        return 0;
    }

    @Deprecated
    public byte[] getValue() {
        return Bytes.copy((byte[])this.valueArray);
    }

    @Deprecated
    public byte[] getFamily() {
        return Bytes.copy((byte[])this.familyArray);
    }

    @Deprecated
    public byte[] getQualifier() {
        return Bytes.copy((byte[])this.qualifierArray);
    }

    @Deprecated
    public byte[] getRow() {
        return Bytes.copy((byte[])this.rowArray);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Cell)) {
            return false;
        }
        return CellUtil.equals((Cell)this, (Cell)((Cell)other));
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.rowArray), Arrays.hashCode(this.familyArray), Arrays.hashCode(this.qualifierArray), this.timestamp, this.getTypeByte());
    }

    public String toString() {
        if (this.rowArray == null || this.rowArray.length == 0) {
            return "";
        }
        return Bytes.toStringBinary((byte[])this.rowArray) + "/" + (this.familyArray.length > 0 ? Bytes.toStringBinary((byte[])this.familyArray) : "") + (this.familyArray.length > 0 ? ":" : "") + (this.qualifierArray.length > 0 ? Bytes.toStringBinary((byte[])this.qualifierArray) : "") + "/" + KeyValue.humanReadableTimestamp((long)this.timestamp) + "/" + KeyValue.Type.codeToType((byte)this.getTypeByte());
    }

    public long heapSize() {
        long labelSize = ClassSize.ARRAYLIST;
        for (String label : this.labels) {
            labelSize += (long)(ClassSize.STRING + ClassSize.align((int)label.length()));
        }
        return (long)(ClassSize.align((int)this.rowArray.length) + ClassSize.ARRAY + ClassSize.align((int)this.familyArray.length) + ClassSize.ARRAY + ClassSize.align((int)this.qualifierArray.length) + ClassSize.ARRAY + 8 + ClassSize.align((int)this.valueArray.length) + ClassSize.ARRAY) + labelSize + (long)ClassSize.OBJECT;
    }
}

