/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.r2dbc.TransactionInProgressException;
import com.google.cloud.spanner.r2dbc.v2.DatabaseClientReactiveAdapter;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseClientTransactionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseClientTransactionManager.class);
    private final DatabaseClient dbClient;
    private AsyncTransactionManager transactionManager;
    private AsyncTransactionManager.TransactionContextFuture txnContextFuture;
    private ReadOnlyTransaction readOnlyTransaction;
    private AsyncTransactionManager.AsyncTransactionStep<?, ? extends Object> lastStep;

    public DatabaseClientTransactionManager(DatabaseClient dbClient) {
        this.dbClient = dbClient;
    }

    boolean isInReadWriteTransaction() {
        return this.txnContextFuture != null;
    }

    boolean isInReadonlyTransaction() {
        return this.readOnlyTransaction != null;
    }

    boolean isInTransaction() {
        return this.isInReadWriteTransaction() || this.isInReadonlyTransaction();
    }

    AsyncTransactionManager.TransactionContextFuture beginTransaction() {
        if (this.isInTransaction()) {
            throw new TransactionInProgressException(this.isInReadWriteTransaction());
        }
        this.transactionManager = this.dbClient.transactionManagerAsync(new Options.TransactionOption[0]);
        this.txnContextFuture = this.transactionManager.beginAsync();
        return this.txnContextFuture;
    }

    void beginReadonlyTransaction(TimestampBound timestampBound) {
        if (this.isInTransaction()) {
            throw new TransactionInProgressException(this.isInReadWriteTransaction());
        }
        this.readOnlyTransaction = this.dbClient.readOnlyTransaction(timestampBound);
    }

    ApiFuture<Void> clearTransactionManager() {
        this.txnContextFuture = null;
        this.lastStep = null;
        ApiFuture returnFuture = ApiFutures.immediateFuture(null);
        if (this.transactionManager != null) {
            returnFuture = this.transactionManager.closeAsync();
            this.transactionManager = null;
        }
        if (this.isInReadonlyTransaction()) {
            this.closeReadOnlyTransaction();
        }
        return returnFuture;
    }

    ApiFuture<Timestamp> commitTransaction() {
        if (this.isInReadWriteTransaction()) {
            if (this.lastStep == null) {
                LOGGER.warn("Read/Write transaction committing without any statements.");
                return ApiFutures.immediateFuture(null);
            }
            return this.lastStep.commitAsync();
        }
        if (this.isInReadonlyTransaction()) {
            this.closeReadOnlyTransaction();
        } else {
            LOGGER.warn("Commit called outside of an active transaction.");
        }
        return ApiFutures.immediateFuture(null);
    }

    private void closeReadOnlyTransaction() {
        this.readOnlyTransaction.close();
        this.readOnlyTransaction = null;
    }

    ApiFuture<Void> rollbackTransaction() {
        if (this.isInReadWriteTransaction()) {
            if (this.lastStep == null) {
                LOGGER.warn("Read/Write transaction rolling back without any statements.");
            }
            return this.transactionManager.rollbackAsync();
        }
        LOGGER.warn("Rollback called outside of an active read/write transaction.");
        return ApiFutures.immediateFuture(null);
    }

    <T> ApiFuture<T> runInTransaction(Function<? super TransactionContext, ApiFuture<T>> operation) {
        AsyncTransactionManager.AsyncTransactionStep updateStatementFuture;
        this.lastStep = updateStatementFuture = this.lastStep == null ? this.txnContextFuture.then((ctx, unusedVoid) -> (ApiFuture)operation.apply(ctx), DatabaseClientReactiveAdapter.REACTOR_EXECUTOR) : this.lastStep.then((ctx, unusedPreviousResult) -> (ApiFuture)operation.apply(ctx), DatabaseClientReactiveAdapter.REACTOR_EXECUTOR);
        return updateStatementFuture;
    }

    ReadContext getReadContext() {
        return this.readOnlyTransaction == null ? this.dbClient.singleUse() : this.readOnlyTransaction;
    }
}

