/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.jackson.JsonCloudEventData;
import io.cloudevents.jackson.JsonFormat;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.function.Consumer;

class CloudEventDeserializer
extends StdDeserializer<CloudEvent> {
    private final boolean forceExtensionNameLowerCaseDeserialization;
    private final boolean forceIgnoreInvalidExtensionNameDeserialization;

    protected CloudEventDeserializer() {
        this(false, false);
    }

    protected CloudEventDeserializer(boolean forceExtensionNameLowerCaseDeserialization, boolean forceIgnoreInvalidExtensionNameDeserialization) {
        super(CloudEvent.class);
        this.forceExtensionNameLowerCaseDeserialization = forceExtensionNameLowerCaseDeserialization;
        this.forceIgnoreInvalidExtensionNameDeserialization = forceIgnoreInvalidExtensionNameDeserialization;
    }

    @Override
    public CloudEvent deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = ctxt.readValue(p, ObjectNode.class);
        try {
            return (CloudEvent)new JsonMessage(p, node, this.forceExtensionNameLowerCaseDeserialization, this.forceIgnoreInvalidExtensionNameDeserialization).read(CloudEventBuilder::fromSpecVersion);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw MismatchedInputException.from(p, CloudEvent.class, e.getMessage());
        }
    }

    private static class JsonMessage
    implements CloudEventReader {
        private final JsonParser p;
        private final ObjectNode node;
        private final boolean forceExtensionNameLowerCaseDeserialization;
        private final boolean forceIgnoreInvalidExtensionNameDeserialization;

        public JsonMessage(JsonParser p, ObjectNode node, boolean forceExtensionNameLowerCaseDeserialization, boolean forceIgnoreInvalidExtensionNameDeserialization) {
            this.p = p;
            this.node = node;
            this.forceExtensionNameLowerCaseDeserialization = forceExtensionNameLowerCaseDeserialization;
            this.forceIgnoreInvalidExtensionNameDeserialization = forceIgnoreInvalidExtensionNameDeserialization;
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        public <T extends CloudEventWriter<V>, V> V read(CloudEventWriterFactory<T, V> writerFactory, CloudEventDataMapper<? extends CloudEventData> mapper) throws CloudEventRWException, IllegalStateException {
            try {
                specVersion = SpecVersion.parse(this.getStringNode(this.node, this.p, "specversion"));
                writer = writerFactory.create(specVersion);
                for (Object attr : specVersion.getMandatoryAttributes()) {
                    if ("specversion".equals(attr)) continue;
                    writer.withContextAttribute((String)attr, this.getStringNode(this.node, this.p, (String)attr));
                }
                contentType = this.getOptionalStringNode(this.node, this.p, "datacontenttype");
                if (contentType != null) {
                    writer.withContextAttribute("datacontenttype", contentType);
                }
                for (String attr : specVersion.getOptionalAttributes()) {
                    if ("datacontentencoding".equals(attr) || (val = this.getOptionalStringNode(this.node, this.p, attr)) == null) continue;
                    writer.withContextAttribute(attr, val);
                }
                data /* !! */  = null;
                switch (1.$SwitchMap$io$cloudevents$SpecVersion[specVersion.ordinal()]) {
                    case 1: {
                        isBase64 = "base64".equals(this.getOptionalStringNode(this.node, this.p, "datacontentencoding"));
                        if (!this.node.has("data")) ** GOTO lbl32
                        if (!isBase64) ** GOTO lbl26
                        data /* !! */  = BytesCloudEventData.wrap(this.node.remove("data").binaryValue());
                        ** GOTO lbl32
lbl26:
                        // 1 sources

                        if (JsonFormat.dataIsJsonContentType(contentType)) {
                            data /* !! */  = new JsonCloudEventData(this.node.remove("data"));
                        } else {
                            dataNode = this.node.remove("data");
                            this.assertNodeType(dataNode, JsonNodeType.STRING, "data", "Because content type is not a json, only a string is accepted as data");
                            data /* !! */  = BytesCloudEventData.wrap(dataNode.asText().getBytes());
                        }
                    }
lbl32:
                    // 5 sources

                    case 2: {
                        if (this.node.has("data_base64") && this.node.has("data")) {
                            throw MismatchedInputException.from(this.p, CloudEvent.class, "CloudEvent cannot have both 'data' and 'data_base64' fields");
                        }
                        if (this.node.has("data_base64")) {
                            data /* !! */  = BytesCloudEventData.wrap(this.node.remove("data_base64").binaryValue());
                            break;
                        }
                        if (!this.node.has("data")) break;
                        if (JsonFormat.dataIsJsonContentType(contentType)) {
                            data /* !! */  = new JsonCloudEventData(this.node.remove("data"));
                            break;
                        }
                        dataNode = this.node.remove("data");
                        this.assertNodeType(dataNode, JsonNodeType.STRING, "data", "Because content type is not a json, only a string is accepted as data");
                        data /* !! */  = BytesCloudEventData.wrap(dataNode.asText().getBytes());
                    }
                }
                this.node.fields().forEachRemaining((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$read$0(io.cloudevents.rw.CloudEventWriter java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((JsonMessage)this, writer));
                if (data /* !! */  != null) {
                    return writer.end(mapper.map(data /* !! */ ));
                }
                return writer.end();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(MismatchedInputException.from(this.p, CloudEvent.class, e.getMessage()));
            }
        }

        private String getStringNode(ObjectNode objNode, JsonParser p, String attributeName) throws JsonProcessingException {
            String val = this.getOptionalStringNode(objNode, p, attributeName);
            if (val == null) {
                throw MismatchedInputException.from(p, CloudEvent.class, "Missing mandatory " + attributeName + " attribute");
            }
            return val;
        }

        private String getOptionalStringNode(ObjectNode objNode, JsonParser p, String attributeName) throws JsonProcessingException {
            JsonNode unparsedAttribute = objNode.remove(attributeName);
            if (unparsedAttribute == null || unparsedAttribute instanceof NullNode) {
                return null;
            }
            this.assertNodeType(unparsedAttribute, JsonNodeType.STRING, attributeName, null);
            return unparsedAttribute.asText();
        }

        private void assertNodeType(JsonNode node, JsonNodeType type, String attributeName, String desc) throws JsonProcessingException {
            if (node.getNodeType() != type) {
                throw MismatchedInputException.from(this.p, CloudEvent.class, "Wrong type " + (Object)((Object)node.getNodeType()) + " for attribute " + attributeName + ", expecting " + (Object)((Object)type) + (desc != null ? ". " + desc : ""));
            }
        }

        private boolean shouldSkipExtensionName(String extensionName) {
            return this.forceIgnoreInvalidExtensionNameDeserialization && !this.isValidExtensionName(extensionName);
        }

        private boolean isValidExtensionName(String name) {
            for (int i = 0; i < name.length(); ++i) {
                if (this.isValidChar(name.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private boolean isValidChar(char c) {
            return c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
        }

        private /* synthetic */ void lambda$read$0(CloudEventWriter writer, Map.Entry entry) {
            String extensionName = (String)entry.getKey();
            if (this.forceExtensionNameLowerCaseDeserialization) {
                extensionName = extensionName.toLowerCase();
            }
            if (this.shouldSkipExtensionName(extensionName)) {
                return;
            }
            JsonNode extensionValue = (JsonNode)entry.getValue();
            switch (extensionValue.getNodeType()) {
                case BOOLEAN: {
                    writer.withContextAttribute(extensionName, extensionValue.booleanValue());
                    break;
                }
                case NUMBER: {
                    Number numericValue = extensionValue.numberValue();
                    if (numericValue instanceof Integer) {
                        writer.withContextAttribute(extensionName, (Integer)numericValue);
                        break;
                    }
                    throw CloudEventRWException.newInvalidAttributeType(extensionName, numericValue);
                }
                case STRING: {
                    writer.withContextAttribute(extensionName, extensionValue.textValue());
                    break;
                }
                default: {
                    writer.withContextAttribute(extensionName, extensionValue.toString());
                }
            }
        }
    }
}

