/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.BatchCancelPipelineJobsOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.BatchCancelPipelineJobsRequest;
import com.google.cloud.aiplatform.v1beta1.BatchCancelPipelineJobsResponse;
import com.google.cloud.aiplatform.v1beta1.BatchDeletePipelineJobsRequest;
import com.google.cloud.aiplatform.v1beta1.BatchDeletePipelineJobsResponse;
import com.google.cloud.aiplatform.v1beta1.CancelPipelineJobRequest;
import com.google.cloud.aiplatform.v1beta1.CancelTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1beta1.CreatePipelineJobRequest;
import com.google.cloud.aiplatform.v1beta1.CreateTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeletePipelineJobRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1beta1.GetPipelineJobRequest;
import com.google.cloud.aiplatform.v1beta1.GetTrainingPipelineRequest;
import com.google.cloud.aiplatform.v1beta1.ListPipelineJobsRequest;
import com.google.cloud.aiplatform.v1beta1.ListPipelineJobsResponse;
import com.google.cloud.aiplatform.v1beta1.ListTrainingPipelinesRequest;
import com.google.cloud.aiplatform.v1beta1.ListTrainingPipelinesResponse;
import com.google.cloud.aiplatform.v1beta1.PipelineJob;
import com.google.cloud.aiplatform.v1beta1.PipelineServiceClient;
import com.google.cloud.aiplatform.v1beta1.TrainingPipeline;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcPipelineServiceCallableFactory;
import com.google.cloud.aiplatform.v1beta1.stub.PipelineServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.PipelineServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcPipelineServiceStub
extends PipelineServiceStub {
    private static final MethodDescriptor<CreateTrainingPipelineRequest, TrainingPipeline> createTrainingPipelineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/CreateTrainingPipeline").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTrainingPipelineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TrainingPipeline.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetTrainingPipelineRequest, TrainingPipeline> getTrainingPipelineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/GetTrainingPipeline").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTrainingPipelineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TrainingPipeline.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse> listTrainingPipelinesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/ListTrainingPipelines").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTrainingPipelinesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTrainingPipelinesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteTrainingPipelineRequest, Operation> deleteTrainingPipelineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/DeleteTrainingPipeline").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTrainingPipelineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CancelTrainingPipelineRequest, Empty> cancelTrainingPipelineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/CancelTrainingPipeline").setRequestMarshaller(ProtoUtils.marshaller((Message)CancelTrainingPipelineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreatePipelineJobRequest, PipelineJob> createPipelineJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/CreatePipelineJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePipelineJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PipelineJob.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetPipelineJobRequest, PipelineJob> getPipelineJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/GetPipelineJob").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPipelineJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PipelineJob.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListPipelineJobsRequest, ListPipelineJobsResponse> listPipelineJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/ListPipelineJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPipelineJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPipelineJobsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeletePipelineJobRequest, Operation> deletePipelineJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/DeletePipelineJob").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePipelineJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<BatchDeletePipelineJobsRequest, Operation> batchDeletePipelineJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/BatchDeletePipelineJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchDeletePipelineJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CancelPipelineJobRequest, Empty> cancelPipelineJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/CancelPipelineJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CancelPipelineJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<BatchCancelPipelineJobsRequest, Operation> batchCancelPipelineJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PipelineService/BatchCancelPipelineJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchCancelPipelineJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateTrainingPipelineRequest, TrainingPipeline> createTrainingPipelineCallable;
    private final UnaryCallable<GetTrainingPipelineRequest, TrainingPipeline> getTrainingPipelineCallable;
    private final UnaryCallable<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse> listTrainingPipelinesCallable;
    private final UnaryCallable<ListTrainingPipelinesRequest, PipelineServiceClient.ListTrainingPipelinesPagedResponse> listTrainingPipelinesPagedCallable;
    private final UnaryCallable<DeleteTrainingPipelineRequest, Operation> deleteTrainingPipelineCallable;
    private final OperationCallable<DeleteTrainingPipelineRequest, Empty, DeleteOperationMetadata> deleteTrainingPipelineOperationCallable;
    private final UnaryCallable<CancelTrainingPipelineRequest, Empty> cancelTrainingPipelineCallable;
    private final UnaryCallable<CreatePipelineJobRequest, PipelineJob> createPipelineJobCallable;
    private final UnaryCallable<GetPipelineJobRequest, PipelineJob> getPipelineJobCallable;
    private final UnaryCallable<ListPipelineJobsRequest, ListPipelineJobsResponse> listPipelineJobsCallable;
    private final UnaryCallable<ListPipelineJobsRequest, PipelineServiceClient.ListPipelineJobsPagedResponse> listPipelineJobsPagedCallable;
    private final UnaryCallable<DeletePipelineJobRequest, Operation> deletePipelineJobCallable;
    private final OperationCallable<DeletePipelineJobRequest, Empty, DeleteOperationMetadata> deletePipelineJobOperationCallable;
    private final UnaryCallable<BatchDeletePipelineJobsRequest, Operation> batchDeletePipelineJobsCallable;
    private final OperationCallable<BatchDeletePipelineJobsRequest, BatchDeletePipelineJobsResponse, DeleteOperationMetadata> batchDeletePipelineJobsOperationCallable;
    private final UnaryCallable<CancelPipelineJobRequest, Empty> cancelPipelineJobCallable;
    private final UnaryCallable<BatchCancelPipelineJobsRequest, Operation> batchCancelPipelineJobsCallable;
    private final OperationCallable<BatchCancelPipelineJobsRequest, BatchCancelPipelineJobsResponse, BatchCancelPipelineJobsOperationMetadata> batchCancelPipelineJobsOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, PipelineServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPipelineServiceStub create(PipelineServiceStubSettings settings) throws IOException {
        return new GrpcPipelineServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPipelineServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcPipelineServiceStub(PipelineServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPipelineServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPipelineServiceStub(PipelineServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPipelineServiceStub(PipelineServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPipelineServiceCallableFactory());
    }

    protected GrpcPipelineServiceStub(PipelineServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createTrainingPipelineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTrainingPipelineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getTrainingPipelineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTrainingPipelineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listTrainingPipelinesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTrainingPipelinesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteTrainingPipelineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTrainingPipelineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings cancelTrainingPipelineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(cancelTrainingPipelineMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createPipelineJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPipelineJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getPipelineJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPipelineJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listPipelineJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPipelineJobsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deletePipelineJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePipelineJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings batchDeletePipelineJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchDeletePipelineJobsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings cancelPipelineJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(cancelPipelineJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings batchCancelPipelineJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchCancelPipelineJobsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createTrainingPipelineCallable = callableFactory.createUnaryCallable(createTrainingPipelineTransportSettings, settings.createTrainingPipelineSettings(), clientContext);
        this.getTrainingPipelineCallable = callableFactory.createUnaryCallable(getTrainingPipelineTransportSettings, settings.getTrainingPipelineSettings(), clientContext);
        this.listTrainingPipelinesCallable = callableFactory.createUnaryCallable(listTrainingPipelinesTransportSettings, settings.listTrainingPipelinesSettings(), clientContext);
        this.listTrainingPipelinesPagedCallable = callableFactory.createPagedCallable(listTrainingPipelinesTransportSettings, settings.listTrainingPipelinesSettings(), clientContext);
        this.deleteTrainingPipelineCallable = callableFactory.createUnaryCallable(deleteTrainingPipelineTransportSettings, settings.deleteTrainingPipelineSettings(), clientContext);
        this.deleteTrainingPipelineOperationCallable = callableFactory.createOperationCallable(deleteTrainingPipelineTransportSettings, settings.deleteTrainingPipelineOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.cancelTrainingPipelineCallable = callableFactory.createUnaryCallable(cancelTrainingPipelineTransportSettings, settings.cancelTrainingPipelineSettings(), clientContext);
        this.createPipelineJobCallable = callableFactory.createUnaryCallable(createPipelineJobTransportSettings, settings.createPipelineJobSettings(), clientContext);
        this.getPipelineJobCallable = callableFactory.createUnaryCallable(getPipelineJobTransportSettings, settings.getPipelineJobSettings(), clientContext);
        this.listPipelineJobsCallable = callableFactory.createUnaryCallable(listPipelineJobsTransportSettings, settings.listPipelineJobsSettings(), clientContext);
        this.listPipelineJobsPagedCallable = callableFactory.createPagedCallable(listPipelineJobsTransportSettings, settings.listPipelineJobsSettings(), clientContext);
        this.deletePipelineJobCallable = callableFactory.createUnaryCallable(deletePipelineJobTransportSettings, settings.deletePipelineJobSettings(), clientContext);
        this.deletePipelineJobOperationCallable = callableFactory.createOperationCallable(deletePipelineJobTransportSettings, settings.deletePipelineJobOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.batchDeletePipelineJobsCallable = callableFactory.createUnaryCallable(batchDeletePipelineJobsTransportSettings, settings.batchDeletePipelineJobsSettings(), clientContext);
        this.batchDeletePipelineJobsOperationCallable = callableFactory.createOperationCallable(batchDeletePipelineJobsTransportSettings, settings.batchDeletePipelineJobsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.cancelPipelineJobCallable = callableFactory.createUnaryCallable(cancelPipelineJobTransportSettings, settings.cancelPipelineJobSettings(), clientContext);
        this.batchCancelPipelineJobsCallable = callableFactory.createUnaryCallable(batchCancelPipelineJobsTransportSettings, settings.batchCancelPipelineJobsSettings(), clientContext);
        this.batchCancelPipelineJobsOperationCallable = callableFactory.createOperationCallable(batchCancelPipelineJobsTransportSettings, settings.batchCancelPipelineJobsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateTrainingPipelineRequest, TrainingPipeline> createTrainingPipelineCallable() {
        return this.createTrainingPipelineCallable;
    }

    @Override
    public UnaryCallable<GetTrainingPipelineRequest, TrainingPipeline> getTrainingPipelineCallable() {
        return this.getTrainingPipelineCallable;
    }

    @Override
    public UnaryCallable<ListTrainingPipelinesRequest, ListTrainingPipelinesResponse> listTrainingPipelinesCallable() {
        return this.listTrainingPipelinesCallable;
    }

    @Override
    public UnaryCallable<ListTrainingPipelinesRequest, PipelineServiceClient.ListTrainingPipelinesPagedResponse> listTrainingPipelinesPagedCallable() {
        return this.listTrainingPipelinesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteTrainingPipelineRequest, Operation> deleteTrainingPipelineCallable() {
        return this.deleteTrainingPipelineCallable;
    }

    @Override
    public OperationCallable<DeleteTrainingPipelineRequest, Empty, DeleteOperationMetadata> deleteTrainingPipelineOperationCallable() {
        return this.deleteTrainingPipelineOperationCallable;
    }

    @Override
    public UnaryCallable<CancelTrainingPipelineRequest, Empty> cancelTrainingPipelineCallable() {
        return this.cancelTrainingPipelineCallable;
    }

    @Override
    public UnaryCallable<CreatePipelineJobRequest, PipelineJob> createPipelineJobCallable() {
        return this.createPipelineJobCallable;
    }

    @Override
    public UnaryCallable<GetPipelineJobRequest, PipelineJob> getPipelineJobCallable() {
        return this.getPipelineJobCallable;
    }

    @Override
    public UnaryCallable<ListPipelineJobsRequest, ListPipelineJobsResponse> listPipelineJobsCallable() {
        return this.listPipelineJobsCallable;
    }

    @Override
    public UnaryCallable<ListPipelineJobsRequest, PipelineServiceClient.ListPipelineJobsPagedResponse> listPipelineJobsPagedCallable() {
        return this.listPipelineJobsPagedCallable;
    }

    @Override
    public UnaryCallable<DeletePipelineJobRequest, Operation> deletePipelineJobCallable() {
        return this.deletePipelineJobCallable;
    }

    @Override
    public OperationCallable<DeletePipelineJobRequest, Empty, DeleteOperationMetadata> deletePipelineJobOperationCallable() {
        return this.deletePipelineJobOperationCallable;
    }

    @Override
    public UnaryCallable<BatchDeletePipelineJobsRequest, Operation> batchDeletePipelineJobsCallable() {
        return this.batchDeletePipelineJobsCallable;
    }

    @Override
    public OperationCallable<BatchDeletePipelineJobsRequest, BatchDeletePipelineJobsResponse, DeleteOperationMetadata> batchDeletePipelineJobsOperationCallable() {
        return this.batchDeletePipelineJobsOperationCallable;
    }

    @Override
    public UnaryCallable<CancelPipelineJobRequest, Empty> cancelPipelineJobCallable() {
        return this.cancelPipelineJobCallable;
    }

    @Override
    public UnaryCallable<BatchCancelPipelineJobsRequest, Operation> batchCancelPipelineJobsCallable() {
        return this.batchCancelPipelineJobsCallable;
    }

    @Override
    public OperationCallable<BatchCancelPipelineJobsRequest, BatchCancelPipelineJobsResponse, BatchCancelPipelineJobsOperationMetadata> batchCancelPipelineJobsOperationCallable() {
        return this.batchCancelPipelineJobsOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, PipelineServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

