/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.beyondcorp.clientgateways.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.beyondcorp.clientgateways.v1.ClientGateway;
import com.google.cloud.beyondcorp.clientgateways.v1.ClientGatewayName;
import com.google.cloud.beyondcorp.clientgateways.v1.ClientGatewayOperationMetadata;
import com.google.cloud.beyondcorp.clientgateways.v1.ClientGatewaysServiceSettings;
import com.google.cloud.beyondcorp.clientgateways.v1.CreateClientGatewayRequest;
import com.google.cloud.beyondcorp.clientgateways.v1.DeleteClientGatewayRequest;
import com.google.cloud.beyondcorp.clientgateways.v1.GetClientGatewayRequest;
import com.google.cloud.beyondcorp.clientgateways.v1.ListClientGatewaysRequest;
import com.google.cloud.beyondcorp.clientgateways.v1.ListClientGatewaysResponse;
import com.google.cloud.beyondcorp.clientgateways.v1.LocationName;
import com.google.cloud.beyondcorp.clientgateways.v1.stub.ClientGatewaysServiceStub;
import com.google.cloud.beyondcorp.clientgateways.v1.stub.ClientGatewaysServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ClientGatewaysServiceClient
implements BackgroundResource {
    private final ClientGatewaysServiceSettings settings;
    private final ClientGatewaysServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ClientGatewaysServiceClient create() throws IOException {
        return ClientGatewaysServiceClient.create(ClientGatewaysServiceSettings.newBuilder().build());
    }

    public static final ClientGatewaysServiceClient create(ClientGatewaysServiceSettings settings) throws IOException {
        return new ClientGatewaysServiceClient(settings);
    }

    public static final ClientGatewaysServiceClient create(ClientGatewaysServiceStub stub) {
        return new ClientGatewaysServiceClient(stub);
    }

    protected ClientGatewaysServiceClient(ClientGatewaysServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ClientGatewaysServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected ClientGatewaysServiceClient(ClientGatewaysServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ClientGatewaysServiceSettings getSettings() {
        return this.settings;
    }

    public ClientGatewaysServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListClientGatewaysPagedResponse listClientGateways(LocationName parent) {
        ListClientGatewaysRequest request = ListClientGatewaysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listClientGateways(request);
    }

    public final ListClientGatewaysPagedResponse listClientGateways(String parent) {
        ListClientGatewaysRequest request = ListClientGatewaysRequest.newBuilder().setParent(parent).build();
        return this.listClientGateways(request);
    }

    public final ListClientGatewaysPagedResponse listClientGateways(ListClientGatewaysRequest request) {
        return (ListClientGatewaysPagedResponse)((Object)this.listClientGatewaysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListClientGatewaysRequest, ListClientGatewaysPagedResponse> listClientGatewaysPagedCallable() {
        return this.stub.listClientGatewaysPagedCallable();
    }

    public final UnaryCallable<ListClientGatewaysRequest, ListClientGatewaysResponse> listClientGatewaysCallable() {
        return this.stub.listClientGatewaysCallable();
    }

    public final ClientGateway getClientGateway(ClientGatewayName name) {
        GetClientGatewayRequest request = GetClientGatewayRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getClientGateway(request);
    }

    public final ClientGateway getClientGateway(String name) {
        GetClientGatewayRequest request = GetClientGatewayRequest.newBuilder().setName(name).build();
        return this.getClientGateway(request);
    }

    public final ClientGateway getClientGateway(GetClientGatewayRequest request) {
        return (ClientGateway)this.getClientGatewayCallable().call((Object)request);
    }

    public final UnaryCallable<GetClientGatewayRequest, ClientGateway> getClientGatewayCallable() {
        return this.stub.getClientGatewayCallable();
    }

    public final OperationFuture<ClientGateway, ClientGatewayOperationMetadata> createClientGatewayAsync(LocationName parent, ClientGateway clientGateway, String clientGatewayId) {
        CreateClientGatewayRequest request = CreateClientGatewayRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setClientGateway(clientGateway).setClientGatewayId(clientGatewayId).build();
        return this.createClientGatewayAsync(request);
    }

    public final OperationFuture<ClientGateway, ClientGatewayOperationMetadata> createClientGatewayAsync(String parent, ClientGateway clientGateway, String clientGatewayId) {
        CreateClientGatewayRequest request = CreateClientGatewayRequest.newBuilder().setParent(parent).setClientGateway(clientGateway).setClientGatewayId(clientGatewayId).build();
        return this.createClientGatewayAsync(request);
    }

    public final OperationFuture<ClientGateway, ClientGatewayOperationMetadata> createClientGatewayAsync(CreateClientGatewayRequest request) {
        return this.createClientGatewayOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateClientGatewayRequest, ClientGateway, ClientGatewayOperationMetadata> createClientGatewayOperationCallable() {
        return this.stub.createClientGatewayOperationCallable();
    }

    public final UnaryCallable<CreateClientGatewayRequest, Operation> createClientGatewayCallable() {
        return this.stub.createClientGatewayCallable();
    }

    public final OperationFuture<Empty, ClientGatewayOperationMetadata> deleteClientGatewayAsync(ClientGatewayName name) {
        DeleteClientGatewayRequest request = DeleteClientGatewayRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteClientGatewayAsync(request);
    }

    public final OperationFuture<Empty, ClientGatewayOperationMetadata> deleteClientGatewayAsync(String name) {
        DeleteClientGatewayRequest request = DeleteClientGatewayRequest.newBuilder().setName(name).build();
        return this.deleteClientGatewayAsync(request);
    }

    public final OperationFuture<Empty, ClientGatewayOperationMetadata> deleteClientGatewayAsync(DeleteClientGatewayRequest request) {
        return this.deleteClientGatewayOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteClientGatewayRequest, Empty, ClientGatewayOperationMetadata> deleteClientGatewayOperationCallable() {
        return this.stub.deleteClientGatewayOperationCallable();
    }

    public final UnaryCallable<DeleteClientGatewayRequest, Operation> deleteClientGatewayCallable() {
        return this.stub.deleteClientGatewayCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListClientGatewaysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGateway, ListClientGatewaysPage, ListClientGatewaysFixedSizeCollection> {
        private ListClientGatewaysFixedSizeCollection(List<ListClientGatewaysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListClientGatewaysFixedSizeCollection createEmptyCollection() {
            return new ListClientGatewaysFixedSizeCollection(null, 0);
        }

        protected ListClientGatewaysFixedSizeCollection createCollection(List<ListClientGatewaysPage> pages, int collectionSize) {
            return new ListClientGatewaysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListClientGatewaysPage
    extends AbstractPage<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGateway, ListClientGatewaysPage> {
        private ListClientGatewaysPage(PageContext<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGateway> context, ListClientGatewaysResponse response) {
            super(context, (Object)response);
        }

        private static ListClientGatewaysPage createEmptyPage() {
            return new ListClientGatewaysPage(null, null);
        }

        protected ListClientGatewaysPage createPage(PageContext<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGateway> context, ListClientGatewaysResponse response) {
            return new ListClientGatewaysPage(context, response);
        }

        public ApiFuture<ListClientGatewaysPage> createPageAsync(PageContext<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGateway> context, ApiFuture<ListClientGatewaysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListClientGatewaysPagedResponse
    extends AbstractPagedListResponse<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGateway, ListClientGatewaysPage, ListClientGatewaysFixedSizeCollection> {
        public static ApiFuture<ListClientGatewaysPagedResponse> createAsync(PageContext<ListClientGatewaysRequest, ListClientGatewaysResponse, ClientGateway> context, ApiFuture<ListClientGatewaysResponse> futureResponse) {
            ApiFuture<ListClientGatewaysPage> futurePage = ListClientGatewaysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListClientGatewaysPagedResponse((ListClientGatewaysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListClientGatewaysPagedResponse(ListClientGatewaysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListClientGatewaysFixedSizeCollection.createEmptyCollection());
        }
    }
}

