/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.testing;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.TransportOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.http.HttpTransportOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

public class RemoteBigQueryHelper {
    private static final Logger log = Logger.getLogger(RemoteBigQueryHelper.class.getName());
    private static final String DATASET_NAME_PREFIX = "gcloud_test_dataset_temp_";
    private static final String MODEL_NAME_PREFIX = "model_";
    private static final String ROUTINE_NAME_PREFIX = "routine_";
    private final BigQueryOptions options;
    private static final int connectTimeout = 60000;

    private RemoteBigQueryHelper(BigQueryOptions options) {
        this.options = options;
    }

    public BigQueryOptions getOptions() {
        return this.options;
    }

    public static boolean forceDelete(BigQuery bigquery, String dataset) {
        return bigquery.delete(dataset, BigQuery.DatasetDeleteOption.deleteContents());
    }

    public static String generateDatasetName() {
        return DATASET_NAME_PREFIX + UUID.randomUUID().toString().replace('-', '_');
    }

    public static String generateModelName() {
        return MODEL_NAME_PREFIX + UUID.randomUUID().toString().replace('-', '_');
    }

    public static String generateRoutineName() {
        return ROUTINE_NAME_PREFIX + UUID.randomUUID().toString().replace('-', '_');
    }

    public static RemoteBigQueryHelper create(String projectId, InputStream keyStream) throws BigQueryHelperException {
        try {
            HttpTransportOptions transportOptions = BigQueryOptions.getDefaultHttpTransportOptions();
            transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
            BigQueryOptions bigqueryOptions = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)keyStream))).setProjectId(projectId)).setRetrySettings(RemoteBigQueryHelper.retrySettings())).setTransportOptions((TransportOptions)transportOptions).build();
            return new RemoteBigQueryHelper(bigqueryOptions);
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, ex.getMessage());
            }
            throw BigQueryHelperException.translate(ex);
        }
    }

    public static RemoteBigQueryHelper create() {
        HttpTransportOptions transportOptions = BigQueryOptions.getDefaultHttpTransportOptions();
        transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
        BigQueryOptions bigqueryOptions = ((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setRetrySettings(RemoteBigQueryHelper.retrySettings())).setTransportOptions((TransportOptions)transportOptions).build();
        return new RemoteBigQueryHelper(bigqueryOptions);
    }

    private static RetrySettings retrySettings() {
        double retryDelayMultiplier = 1.0;
        int maxAttempts = 10;
        long initialRetryDelay = 250L;
        long maxRetryDelay = 30000L;
        long totalTimeOut = 120000L;
        return RetrySettings.newBuilder().setMaxAttempts(maxAttempts).setMaxRetryDelay(Duration.ofMillis((long)maxRetryDelay)).setTotalTimeout(Duration.ofMillis((long)totalTimeOut)).setInitialRetryDelay(Duration.ofMillis((long)initialRetryDelay)).setRetryDelayMultiplier(retryDelayMultiplier).setInitialRpcTimeout(Duration.ofMillis((long)totalTimeOut)).setRpcTimeoutMultiplier(retryDelayMultiplier).setMaxRpcTimeout(Duration.ofMillis((long)totalTimeOut)).build();
    }

    public static class BigQueryHelperException
    extends RuntimeException {
        private static final long serialVersionUID = 3984993496060055562L;

        public BigQueryHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        public static BigQueryHelperException translate(Exception ex) {
            return new BigQueryHelperException(ex.getMessage(), ex);
        }
    }
}

