package com.google.cloud.bigquery;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_QueryParameterValue extends QueryParameterValue {

  @Nullable
  private final String value;

  @Nullable
  private final ImmutableList<QueryParameterValue> arrayValuesInner;

  @Nullable
  private final Map<String, QueryParameterValue> structValuesInner;

  @Nullable
  private final Range rangeValuesInner;

  private final StandardSQLTypeName type;

  @Nullable
  private final StandardSQLTypeName arrayType;

  @Nullable
  private final Map<String, QueryParameterValue> structTypesInner;

  private AutoValue_QueryParameterValue(
      @Nullable String value,
      @Nullable ImmutableList<QueryParameterValue> arrayValuesInner,
      @Nullable Map<String, QueryParameterValue> structValuesInner,
      @Nullable Range rangeValuesInner,
      StandardSQLTypeName type,
      @Nullable StandardSQLTypeName arrayType,
      @Nullable Map<String, QueryParameterValue> structTypesInner) {
    this.value = value;
    this.arrayValuesInner = arrayValuesInner;
    this.structValuesInner = structValuesInner;
    this.rangeValuesInner = rangeValuesInner;
    this.type = type;
    this.arrayType = arrayType;
    this.structTypesInner = structTypesInner;
  }

  @Nullable
  @Override
  public String getValue() {
    return value;
  }

  @Nullable
  @Override
  ImmutableList<QueryParameterValue> getArrayValuesInner() {
    return arrayValuesInner;
  }

  @Nullable
  @Override
  Map<String, QueryParameterValue> getStructValuesInner() {
    return structValuesInner;
  }

  @Nullable
  @Override
  Range getRangeValuesInner() {
    return rangeValuesInner;
  }

  @Override
  public StandardSQLTypeName getType() {
    return type;
  }

  @Nullable
  @Override
  public StandardSQLTypeName getArrayType() {
    return arrayType;
  }

  @Nullable
  @Override
  Map<String, QueryParameterValue> getStructTypesInner() {
    return structTypesInner;
  }

  @Override
  public String toString() {
    return "QueryParameterValue{"
        + "value=" + value + ", "
        + "arrayValuesInner=" + arrayValuesInner + ", "
        + "structValuesInner=" + structValuesInner + ", "
        + "rangeValuesInner=" + rangeValuesInner + ", "
        + "type=" + type + ", "
        + "arrayType=" + arrayType + ", "
        + "structTypesInner=" + structTypesInner
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryParameterValue) {
      QueryParameterValue that = (QueryParameterValue) o;
      return (this.value == null ? that.getValue() == null : this.value.equals(that.getValue()))
          && (this.arrayValuesInner == null ? that.getArrayValuesInner() == null : this.arrayValuesInner.equals(that.getArrayValuesInner()))
          && (this.structValuesInner == null ? that.getStructValuesInner() == null : this.structValuesInner.equals(that.getStructValuesInner()))
          && (this.rangeValuesInner == null ? that.getRangeValuesInner() == null : this.rangeValuesInner.equals(that.getRangeValuesInner()))
          && this.type.equals(that.getType())
          && (this.arrayType == null ? that.getArrayType() == null : this.arrayType.equals(that.getArrayType()))
          && (this.structTypesInner == null ? that.getStructTypesInner() == null : this.structTypesInner.equals(that.getStructTypesInner()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (value == null) ? 0 : value.hashCode();
    h$ *= 1000003;
    h$ ^= (arrayValuesInner == null) ? 0 : arrayValuesInner.hashCode();
    h$ *= 1000003;
    h$ ^= (structValuesInner == null) ? 0 : structValuesInner.hashCode();
    h$ *= 1000003;
    h$ ^= (rangeValuesInner == null) ? 0 : rangeValuesInner.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (arrayType == null) ? 0 : arrayType.hashCode();
    h$ *= 1000003;
    h$ ^= (structTypesInner == null) ? 0 : structTypesInner.hashCode();
    return h$;
  }

  private static final long serialVersionUID = -5620695863123562896L;

  @Override
  public QueryParameterValue.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends QueryParameterValue.Builder {
    private String value;
    private ImmutableList<QueryParameterValue> arrayValuesInner;
    private Map<String, QueryParameterValue> structValuesInner;
    private Range rangeValuesInner;
    private StandardSQLTypeName type;
    private StandardSQLTypeName arrayType;
    private Map<String, QueryParameterValue> structTypesInner;
    Builder() {
    }
    private Builder(QueryParameterValue source) {
      this.value = source.getValue();
      this.arrayValuesInner = source.getArrayValuesInner();
      this.structValuesInner = source.getStructValuesInner();
      this.rangeValuesInner = source.getRangeValuesInner();
      this.type = source.getType();
      this.arrayType = source.getArrayType();
      this.structTypesInner = source.getStructTypesInner();
    }
    @Override
    public QueryParameterValue.Builder setValue(String value) {
      this.value = value;
      return this;
    }
    @Override
    QueryParameterValue.Builder setArrayValuesInner(ImmutableList<QueryParameterValue> arrayValuesInner) {
      this.arrayValuesInner = arrayValuesInner;
      return this;
    }
    @Override
    QueryParameterValue.Builder setStructValuesInner(Map<String, QueryParameterValue> structValuesInner) {
      this.structValuesInner = structValuesInner;
      return this;
    }
    @Override
    QueryParameterValue.Builder setRangeValuesInner(Range rangeValuesInner) {
      this.rangeValuesInner = rangeValuesInner;
      return this;
    }
    @Override
    public QueryParameterValue.Builder setType(StandardSQLTypeName type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public QueryParameterValue.Builder setArrayType(StandardSQLTypeName arrayType) {
      this.arrayType = arrayType;
      return this;
    }
    @Override
    QueryParameterValue.Builder setStructTypesInner(Map<String, QueryParameterValue> structTypesInner) {
      this.structTypesInner = structTypesInner;
      return this;
    }
    @Override
    public QueryParameterValue build() {
      if (this.type == null) {
        String missing = " type";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QueryParameterValue(
          this.value,
          this.arrayValuesInner,
          this.structValuesInner,
          this.rangeValuesInner,
          this.type,
          this.arrayType,
          this.structTypesInner);
    }
  }

}
