/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.cloud.bigquery.FieldElementType;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.PolicyTags;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class Field
implements Serializable {
    static final Function<TableFieldSchema, Field> FROM_PB_FUNCTION = new Function<TableFieldSchema, Field>(){

        public Field apply(TableFieldSchema pb) {
            return Field.fromPb(pb);
        }
    };
    static final Function<Field, TableFieldSchema> TO_PB_FUNCTION = new Function<Field, TableFieldSchema>(){

        public TableFieldSchema apply(Field field) {
            return field.toPb();
        }
    };
    private static final long serialVersionUID = 8827990270251118556L;
    private final String name;
    private final LegacySQLTypeName type;
    private final FieldList subFields;
    private final String mode;
    private final String description;
    private final PolicyTags policyTags;
    private final Long maxLength;
    private final Long scale;
    private final Long precision;
    private final Long timestampPrecision;
    private final String defaultValueExpression;
    private final String collation;
    private final FieldElementType rangeElementType;

    private Field(Builder builder) {
        this.name = (String)Preconditions.checkNotNull((Object)builder.name);
        this.type = (LegacySQLTypeName)((Object)Preconditions.checkNotNull((Object)((Object)builder.type)));
        this.subFields = builder.subFields;
        this.mode = builder.mode;
        this.description = builder.description;
        this.policyTags = builder.policyTags;
        this.maxLength = builder.maxLength;
        this.scale = builder.scale;
        this.precision = builder.precision;
        this.timestampPrecision = builder.timestampPrecision;
        this.defaultValueExpression = builder.defaultValueExpression;
        this.collation = builder.collation;
        this.rangeElementType = builder.rangeElementType;
    }

    public String getName() {
        return this.name;
    }

    public LegacySQLTypeName getType() {
        return this.type;
    }

    public Mode getMode() {
        return this.mode != null ? Mode.valueOf(this.mode) : null;
    }

    public String getDescription() {
        return Data.isNull((Object)this.description) ? null : this.description;
    }

    public PolicyTags getPolicyTags() {
        return this.policyTags;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Long getScale() {
        return this.scale;
    }

    public Long getPrecision() {
        return this.precision;
    }

    public Long getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public String getDefaultValueExpression() {
        return this.defaultValueExpression;
    }

    public String getCollation() {
        return this.collation;
    }

    public FieldElementType getRangeElementType() {
        return this.rangeElementType;
    }

    public FieldList getSubFields() {
        return this.subFields;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("mode", (Object)this.mode).add("description", (Object)this.description).add("policyTags", (Object)this.policyTags).add("maxLength", (Object)this.maxLength).add("scale", (Object)this.scale).add("precision", (Object)this.precision).add("timestampPrecision", (Object)this.timestampPrecision).add("defaultValueExpression", (Object)this.defaultValueExpression).add("collation", (Object)this.collation).add("rangeElementType", (Object)this.rangeElementType).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.mode, this.description, this.policyTags, this.maxLength, this.scale, this.precision, this.timestampPrecision, this.defaultValueExpression, this.collation, this.rangeElementType});
    }

    public boolean equals(Object obj) {
        return obj instanceof Field && Objects.equals(this.toPb(), ((Field)obj).toPb());
    }

    public static Field of(String name, LegacySQLTypeName type, Field ... subFields) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Provided name is null or empty");
        return Field.newBuilder(name, type, subFields).build();
    }

    public static Field of(String name, StandardSQLTypeName type, Field ... subFields) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Provided name is null or empty");
        return Field.newBuilder(name, type, subFields).build();
    }

    public static Field of(String name, LegacySQLTypeName type, FieldList subFields) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Provided name is null or empty");
        return Field.newBuilder(name, type, subFields).build();
    }

    public static Field of(String name, StandardSQLTypeName type, FieldList subFields) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Provided name is null or empty");
        return Field.newBuilder(name, type, subFields).build();
    }

    public static Builder newBuilder(String name, LegacySQLTypeName type, Field ... subFields) {
        return new Builder().setName(name).setType(type, subFields);
    }

    public static Builder newBuilder(String name, StandardSQLTypeName type, Field ... subFields) {
        return new Builder().setName(name).setType(type, subFields);
    }

    public static Builder newBuilder(String name, LegacySQLTypeName type, FieldList subFields) {
        return new Builder().setName(name).setType(type, subFields);
    }

    public static Builder newBuilder(String name, StandardSQLTypeName type, FieldList subFields) {
        return new Builder().setName(name).setType(type, subFields);
    }

    TableFieldSchema toPb() {
        TableFieldSchema fieldSchemaPb = new TableFieldSchema();
        fieldSchemaPb.setName(this.name);
        fieldSchemaPb.setType(this.type.name());
        if (this.mode != null) {
            fieldSchemaPb.setMode(this.mode);
        }
        if (this.description != null) {
            fieldSchemaPb.setDescription(this.description);
        }
        if (this.policyTags != null) {
            fieldSchemaPb.setPolicyTags(this.policyTags.toPb());
        }
        if (this.maxLength != null) {
            fieldSchemaPb.setMaxLength(this.maxLength);
        }
        if (this.scale != null) {
            fieldSchemaPb.setScale(this.scale);
        }
        if (this.precision != null) {
            fieldSchemaPb.setPrecision(this.precision);
        }
        if (this.timestampPrecision != null) {
            fieldSchemaPb.setTimestampPrecision(this.timestampPrecision);
        }
        if (this.defaultValueExpression != null) {
            fieldSchemaPb.setDefaultValueExpression(this.defaultValueExpression);
        }
        if (this.getSubFields() != null) {
            List fieldsPb = Lists.transform((List)this.getSubFields(), TO_PB_FUNCTION);
            fieldSchemaPb.setFields(fieldsPb);
        }
        if (this.collation != null) {
            fieldSchemaPb.setCollation(this.collation);
        }
        if (this.rangeElementType != null) {
            fieldSchemaPb.setRangeElementType(this.rangeElementType.toPb());
        }
        return fieldSchemaPb;
    }

    static Field fromPb(TableFieldSchema fieldSchemaPb) {
        Builder fieldBuilder = new Builder();
        fieldBuilder.setName(fieldSchemaPb.getName());
        if (fieldSchemaPb.getMode() != null) {
            fieldBuilder.setMode(Mode.valueOf(fieldSchemaPb.getMode()));
        }
        if (fieldSchemaPb.getDescription() != null) {
            fieldBuilder.setDescription(fieldSchemaPb.getDescription());
        }
        if (fieldSchemaPb.getPolicyTags() != null) {
            fieldBuilder.setPolicyTags(PolicyTags.fromPb(fieldSchemaPb.getPolicyTags()));
        }
        if (fieldSchemaPb.getMaxLength() != null) {
            fieldBuilder.setMaxLength(fieldSchemaPb.getMaxLength());
        }
        if (fieldSchemaPb.getScale() != null) {
            fieldBuilder.setScale(fieldSchemaPb.getScale());
        }
        if (fieldSchemaPb.getPrecision() != null) {
            fieldBuilder.setPrecision(fieldSchemaPb.getPrecision());
        }
        if (fieldSchemaPb.getTimestampPrecision() != null) {
            fieldBuilder.setTimestampPrecision(fieldSchemaPb.getTimestampPrecision());
        }
        if (fieldSchemaPb.getDefaultValueExpression() != null) {
            fieldBuilder.setDefaultValueExpression(fieldSchemaPb.getDefaultValueExpression());
        }
        FieldList subFields = fieldSchemaPb.getFields() != null ? FieldList.of(Lists.transform((List)fieldSchemaPb.getFields(), FROM_PB_FUNCTION)) : null;
        fieldBuilder.setType(LegacySQLTypeName.valueOf(fieldSchemaPb.getType()), subFields);
        if (fieldSchemaPb.getCollation() != null) {
            fieldBuilder.setCollation(fieldSchemaPb.getCollation());
        }
        if (fieldSchemaPb.getRangeElementType() != null) {
            fieldBuilder.setRangeElementType(FieldElementType.fromPb(fieldSchemaPb.getRangeElementType()));
        }
        return fieldBuilder.build();
    }

    public static final class Builder {
        private String name;
        private LegacySQLTypeName type;
        private FieldList subFields;
        private String mode;
        private String description;
        private PolicyTags policyTags;
        private Long maxLength;
        private Long scale;
        private Long precision;
        private Long timestampPrecision;
        private String defaultValueExpression;
        private String collation;
        private FieldElementType rangeElementType;

        private Builder() {
        }

        private Builder(Field field) {
            this.name = field.name;
            this.type = field.type;
            this.subFields = field.subFields;
            this.mode = field.mode;
            this.description = field.description;
            this.policyTags = field.policyTags;
            this.maxLength = field.maxLength;
            this.scale = field.scale;
            this.precision = field.precision;
            this.timestampPrecision = field.timestampPrecision;
            this.defaultValueExpression = field.defaultValueExpression;
            this.collation = field.collation;
            this.rangeElementType = field.rangeElementType;
        }

        public Builder setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        public Builder setType(LegacySQLTypeName type, Field ... subFields) {
            return this.setType(type, subFields.length > 0 ? FieldList.of(subFields) : null);
        }

        public Builder setType(StandardSQLTypeName type, Field ... subFields) {
            return this.setType(LegacySQLTypeName.legacySQLTypeName(type), subFields.length > 0 ? FieldList.of(subFields) : null);
        }

        public Builder setType(LegacySQLTypeName type, FieldList subFields) {
            if (LegacySQLTypeName.RECORD.equals((Object)type)) {
                if (subFields == null || subFields.isEmpty()) {
                    throw new IllegalArgumentException("The " + (Object)((Object)type) + " field must have at least one sub-field");
                }
            } else if (subFields != null) {
                throw new IllegalArgumentException("Only " + (Object)((Object)LegacySQLTypeName.RECORD) + " fields can have sub-fields");
            }
            this.type = type;
            this.subFields = subFields;
            return this;
        }

        public Builder setType(StandardSQLTypeName type, FieldList subFields) {
            return this.setType(LegacySQLTypeName.legacySQLTypeName(type), subFields);
        }

        public Builder setMode(Mode mode) {
            this.mode = mode != null ? mode.name() : null;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = (String)MoreObjects.firstNonNull((Object)description, (Object)((String)Data.nullOf(String.class)));
            return this;
        }

        public Builder setPolicyTags(PolicyTags policyTags) {
            this.policyTags = policyTags;
            return this;
        }

        public Builder setMaxLength(Long maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder setScale(Long scale) {
            this.scale = scale;
            return this;
        }

        public Builder setPrecision(Long precision) {
            this.precision = precision;
            return this;
        }

        public Builder setTimestampPrecision(Long timestampPrecision) {
            Preconditions.checkArgument((timestampPrecision == 6L || timestampPrecision == 12L ? 1 : 0) != 0, (Object)"Timestamp Precision must be 6 (microsecond) or 12 (picosecond)");
            this.timestampPrecision = timestampPrecision;
            return this;
        }

        public Builder setDefaultValueExpression(String defaultValueExpression) {
            this.defaultValueExpression = defaultValueExpression;
            return this;
        }

        public Builder setCollation(String collation) {
            this.collation = collation;
            return this;
        }

        public Builder setRangeElementType(FieldElementType rangeElementType) {
            this.rangeElementType = rangeElementType;
            return this;
        }

        public Field build() {
            return new Field(this);
        }
    }

    public static enum Mode {
        NULLABLE,
        REQUIRED,
        REPEATED;

    }
}

