/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.emulator.v2;

import com.google.api.core.BetaApi;
import com.google.cloud.bigtable.emulator.core.EmulatorController;
import com.google.common.base.Preconditions;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

@BetaApi(value="Surface for Bigtable emulator is not yet stable")
public class Emulator {
    private static final Logger LOGGER = Logger.getLogger(Emulator.class.getName());
    private final EmulatorController controller;
    private ManagedChannel dataChannel;
    private ManagedChannel adminChannel;

    public static Emulator createFromPath(Path path) {
        return new Emulator(EmulatorController.createFromPath((Path)path));
    }

    public static Emulator createBundled() throws IOException {
        return new Emulator(EmulatorController.createBundled());
    }

    private Emulator(EmulatorController controller) {
        this.controller = controller;
    }

    public synchronized void start() throws IOException, TimeoutException, InterruptedException {
        this.controller.start();
    }

    public synchronized void stop() {
        this.controller.stop();
        try {
            if (this.dataChannel != null) {
                this.dataChannel.shutdownNow();
            }
            if (this.adminChannel != null) {
                this.adminChannel.shutdownNow();
            }
            if (this.dataChannel != null) {
                this.dataChannel.awaitTermination(1L, TimeUnit.MINUTES);
                this.dataChannel = null;
            }
            if (this.adminChannel != null) {
                this.adminChannel.awaitTermination(1L, TimeUnit.MINUTES);
                this.adminChannel = null;
            }
        }
        catch (InterruptedException e) {
            LOGGER.warning("Interrupted while waiting for client channels to close");
            Thread.currentThread().interrupt();
        }
    }

    public synchronized int getPort() {
        return this.controller.getPort();
    }

    public synchronized ManagedChannel getDataChannel() {
        Preconditions.checkState((boolean)this.controller.isRunning(), (Object)"Emulator is not running");
        if (this.dataChannel == null) {
            this.dataChannel = Emulator.newChannelBuilder(this.controller.getPort()).maxInboundMessageSize(0x10000000).keepAliveTimeout(10L, TimeUnit.SECONDS).keepAliveTime(10L, TimeUnit.SECONDS).keepAliveWithoutCalls(true).build();
        }
        return this.dataChannel;
    }

    public synchronized ManagedChannel getAdminChannel() {
        Preconditions.checkState((boolean)this.controller.isRunning(), (Object)"Emulator is not running");
        if (this.adminChannel == null) {
            this.adminChannel = Emulator.newChannelBuilder(this.controller.getPort()).build();
        }
        return this.adminChannel;
    }

    private static ManagedChannelBuilder<?> newChannelBuilder(int port) {
        return ManagedChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext();
    }
}

