/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.stats;

import com.google.api.Distribution;
import com.google.api.Metric;
import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResource;
import com.google.bigtable.veneer.repackaged.io.opencensus.common.Function;
import com.google.bigtable.veneer.repackaged.io.opencensus.common.Functions;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.LabelKey;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.LabelValue;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Distribution;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.MetricDescriptor;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Summary;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.TimeSeries;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Value;
import com.google.cloud.bigtable.stats.BuiltinMeasureConstants;
import com.google.cloud.bigtable.stats.BuiltinViewConstants;
import com.google.cloud.bigtable.stats.ConsumerEnvironmentUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.monitoring.v3.Point;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.monitoring.v3.TypedValue;
import com.google.protobuf.Timestamp;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class BigtableStackdriverExportUtils {
    private static final String BIGTABLE_RESOURCE_TYPE = "bigtable_client_raw";
    @VisibleForTesting
    static final String GCE_RESOURCE_TYPE = "gce_instance";
    @VisibleForTesting
    static final String GKE_RESOURCE_TYPE = "k8s_container";
    @VisibleForTesting
    static final String GCE_OR_GKE_PROJECT_ID_KEY = "project_id";
    private static final Logger logger = Logger.getLogger(BigtableStackdriverExportUtils.class.getName());
    private static final Function<Double, TypedValue> typedValueDoubleFunction = arg -> {
        TypedValue.Builder builder = TypedValue.newBuilder();
        builder.setDoubleValue(arg.doubleValue());
        return builder.build();
    };
    private static final Function<Long, TypedValue> typedValueLongFunction = arg -> {
        TypedValue.Builder builder = TypedValue.newBuilder();
        builder.setInt64Value(arg.longValue());
        return builder.build();
    };
    private static final Function<com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Distribution, TypedValue> typedValueDistributionFunction = arg -> {
        TypedValue.Builder builder = TypedValue.newBuilder();
        return builder.setDistributionValue(BigtableStackdriverExportUtils.createDistribution(arg)).build();
    };
    private static final Function<Summary, TypedValue> typedValueSummaryFunction = arg -> {
        TypedValue.Builder builder = TypedValue.newBuilder();
        return builder.build();
    };
    private static final Function<Distribution.BucketOptions.ExplicitOptions, Distribution.BucketOptions> bucketOptionsExplicitFunction = arg -> {
        Distribution.BucketOptions.Builder builder = Distribution.BucketOptions.newBuilder();
        Distribution.BucketOptions.Explicit.Builder explicitBuilder = Distribution.BucketOptions.Explicit.newBuilder();
        explicitBuilder.addBounds(0.0);
        explicitBuilder.addAllBounds(arg.getBucketBoundaries());
        builder.setExplicitBuckets(explicitBuilder.build());
        return builder.build();
    };
    private static final Set<String> PROMOTED_BIGTABLE_RESOURCE_LABELS = ImmutableSet.of((Object)BuiltinMeasureConstants.PROJECT_ID.getName(), (Object)BuiltinMeasureConstants.INSTANCE_ID.getName(), (Object)BuiltinMeasureConstants.CLUSTER.getName(), (Object)BuiltinMeasureConstants.ZONE.getName(), (Object)BuiltinMeasureConstants.TABLE.getName());
    private static final LabelKey CLIENT_UID_LABEL_KEY = LabelKey.create(BuiltinMeasureConstants.CLIENT_UID.getName(), "client uid");

    BigtableStackdriverExportUtils() {
    }

    static boolean isBigtableTableMetric(MetricDescriptor metricDescriptor) {
        return metricDescriptor.getName().contains("bigtable") && !metricDescriptor.getName().equals(BuiltinViewConstants.PER_CONNECTION_ERROR_COUNT_VIEW.getName().asString());
    }

    static boolean shouldExportMetric(MetricDescriptor metricDescriptor) {
        return BigtableStackdriverExportUtils.isBigtableTableMetric(metricDescriptor) || metricDescriptor.getName().equals(BuiltinViewConstants.PER_CONNECTION_ERROR_COUNT_VIEW.getName().asString()) && (ConsumerEnvironmentUtils.isEnvGce() || ConsumerEnvironmentUtils.isEnvGke());
    }

    static com.google.monitoring.v3.TimeSeries convertTimeSeries(MetricDescriptor metricDescriptor, TimeSeries timeSeries, String clientId, MonitoredResource gceOrGkeMonitoredResource) {
        TimeSeries.Builder builder;
        MetricDescriptor.Type metricType = metricDescriptor.getType();
        if (BigtableStackdriverExportUtils.isBigtableTableMetric(metricDescriptor)) {
            builder = BigtableStackdriverExportUtils.setupBuilderForBigtableResource(metricDescriptor, MonitoredResource.newBuilder().setType(BIGTABLE_RESOURCE_TYPE), timeSeries, clientId);
        } else if (ConsumerEnvironmentUtils.isEnvGce() || ConsumerEnvironmentUtils.isEnvGke()) {
            builder = BigtableStackdriverExportUtils.setupBuilderForGceOrGKEResource(metricDescriptor, gceOrGkeMonitoredResource, timeSeries, clientId);
        } else {
            logger.warning("Trying to export metric " + metricDescriptor.getName() + " in a non-GCE/GKE environment.");
            return com.google.monitoring.v3.TimeSeries.newBuilder().build();
        }
        builder.setMetricKind(BigtableStackdriverExportUtils.createMetricKind(metricType));
        builder.setValueType(BigtableStackdriverExportUtils.createValueType(metricType));
        com.google.bigtable.veneer.repackaged.io.opencensus.common.Timestamp startTimeStamp = timeSeries.getStartTimestamp();
        for (com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Point point : timeSeries.getPoints()) {
            builder.addPoints(BigtableStackdriverExportUtils.createPoint(point, startTimeStamp));
        }
        return builder.build();
    }

    private static TimeSeries.Builder setupBuilderForBigtableResource(MetricDescriptor metricDescriptor, MonitoredResource.Builder monitoredResourceBuilder, TimeSeries timeSeries, String clientId) {
        List<LabelKey> labelKeys = metricDescriptor.getLabelKeys();
        String metricName = metricDescriptor.getName();
        ArrayList<LabelKey> metricTagKeys = new ArrayList<LabelKey>();
        ArrayList<LabelValue> metricTagValues = new ArrayList<LabelValue>();
        List<LabelValue> labelValues = timeSeries.getLabelValues();
        for (int i = 0; i < labelValues.size(); ++i) {
            if (PROMOTED_BIGTABLE_RESOURCE_LABELS.contains(labelKeys.get(i).getKey())) {
                monitoredResourceBuilder.putLabels(labelKeys.get(i).getKey(), labelValues.get(i).getValue());
                continue;
            }
            metricTagKeys.add(labelKeys.get(i));
            metricTagValues.add(labelValues.get(i));
        }
        metricTagKeys.add(CLIENT_UID_LABEL_KEY);
        metricTagValues.add(LabelValue.create(clientId));
        TimeSeries.Builder builder = com.google.monitoring.v3.TimeSeries.newBuilder();
        builder.setResource(monitoredResourceBuilder.build());
        builder.setMetric(BigtableStackdriverExportUtils.createMetric(metricName, metricTagKeys, metricTagValues));
        return builder;
    }

    private static TimeSeries.Builder setupBuilderForGceOrGKEResource(MetricDescriptor metricDescriptor, MonitoredResource gceOrGkeMonitoredResource, TimeSeries timeSeries, String clientId) {
        List<LabelKey> labelKeys = metricDescriptor.getLabelKeys();
        String metricName = metricDescriptor.getName();
        ArrayList<LabelKey> metricTagKeys = new ArrayList<LabelKey>();
        ArrayList<LabelValue> metricTagValues = new ArrayList<LabelValue>();
        List<LabelValue> labelValues = timeSeries.getLabelValues();
        for (int i = 0; i < labelValues.size(); ++i) {
            metricTagKeys.add(labelKeys.get(i));
            metricTagValues.add(labelValues.get(i));
        }
        metricTagKeys.add(CLIENT_UID_LABEL_KEY);
        metricTagValues.add(LabelValue.create(clientId));
        TimeSeries.Builder builder = com.google.monitoring.v3.TimeSeries.newBuilder();
        builder.setResource(gceOrGkeMonitoredResource);
        builder.setMetric(BigtableStackdriverExportUtils.createMetric(metricName, metricTagKeys, metricTagValues));
        return builder;
    }

    static String getProjectId(MetricDescriptor metricDescriptor, TimeSeries timeSeries, MonitoredResource gceOrGkeMonitoredResource) {
        if (BigtableStackdriverExportUtils.isBigtableTableMetric(metricDescriptor)) {
            return BigtableStackdriverExportUtils.getProjectIdForBigtableTableResource(metricDescriptor, timeSeries);
        }
        return BigtableStackdriverExportUtils.getProjectIdForGceOrGkeResource(gceOrGkeMonitoredResource);
    }

    static String getProjectIdForBigtableTableResource(MetricDescriptor metricDescriptor, TimeSeries timeSeries) {
        List<LabelKey> labelKeys = metricDescriptor.getLabelKeys();
        List<LabelValue> labelValues = timeSeries.getLabelValues();
        for (int i = 0; i < labelKeys.size(); ++i) {
            if (!labelKeys.get(i).getKey().equals(BuiltinMeasureConstants.PROJECT_ID.getName())) continue;
            return labelValues.get(i).getValue();
        }
        throw new IllegalStateException("Can't find project id for the current timeseries");
    }

    static String getProjectIdForGceOrGkeResource(MonitoredResource gceOrGkeMonitoredResource) {
        if (!gceOrGkeMonitoredResource.getType().equals(GCE_RESOURCE_TYPE) && !gceOrGkeMonitoredResource.getType().equals(GKE_RESOURCE_TYPE)) {
            throw new IllegalStateException("Expected GCE or GKE resource type, but found " + gceOrGkeMonitoredResource);
        }
        return gceOrGkeMonitoredResource.getLabelsOrThrow(GCE_OR_GKE_PROJECT_ID_KEY);
    }

    static String getDefaultTaskValue() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        if (jvmName.indexOf(64) < 1) {
            String hostname = "localhost";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.log(Level.INFO, "Unable to get the hostname.", e);
            }
            return "java-" + new SecureRandom().nextInt() + "@" + hostname;
        }
        return "java-" + UUID.randomUUID() + jvmName;
    }

    private static MetricDescriptor.MetricKind createMetricKind(MetricDescriptor.Type type) {
        switch (type) {
            case CUMULATIVE_DOUBLE: 
            case CUMULATIVE_INT64: 
            case CUMULATIVE_DISTRIBUTION: {
                return MetricDescriptor.MetricKind.CUMULATIVE;
            }
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    private static MetricDescriptor.ValueType createValueType(MetricDescriptor.Type type) {
        switch (type) {
            case CUMULATIVE_DOUBLE: {
                return MetricDescriptor.ValueType.DOUBLE;
            }
            case CUMULATIVE_INT64: {
                return MetricDescriptor.ValueType.INT64;
            }
            case CUMULATIVE_DISTRIBUTION: {
                return MetricDescriptor.ValueType.DISTRIBUTION;
            }
        }
        return MetricDescriptor.ValueType.UNRECOGNIZED;
    }

    private static Metric createMetric(String metricName, List<LabelKey> labelKeys, List<LabelValue> labelValues) {
        Metric.Builder builder = Metric.newBuilder();
        builder.setType(metricName);
        HashMap stringTagMap = Maps.newHashMap();
        for (int i = 0; i < labelValues.size(); ++i) {
            String value = labelValues.get(i).getValue();
            if (value == null) continue;
            stringTagMap.put(labelKeys.get(i).getKey(), value);
        }
        builder.putAllLabels((Map)stringTagMap);
        return builder.build();
    }

    private static Point createPoint(com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Point point, com.google.bigtable.veneer.repackaged.io.opencensus.common.Timestamp startTimestamp) {
        TimeInterval.Builder timeIntervalBuilder = TimeInterval.newBuilder();
        timeIntervalBuilder.setStartTime(BigtableStackdriverExportUtils.convertTimestamp(startTimestamp));
        timeIntervalBuilder.setEndTime(BigtableStackdriverExportUtils.convertTimestamp(point.getTimestamp()));
        Point.Builder builder = Point.newBuilder();
        builder.setInterval(timeIntervalBuilder.build());
        builder.setValue(BigtableStackdriverExportUtils.createTypedValue(point.getValue()));
        return builder.build();
    }

    private static TypedValue createTypedValue(Value value) {
        return value.match(typedValueDoubleFunction, typedValueLongFunction, typedValueDistributionFunction, typedValueSummaryFunction, Functions.throwIllegalArgumentException());
    }

    private static Distribution createDistribution(com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Distribution distribution) {
        Distribution.Builder builder = Distribution.newBuilder().setBucketOptions(BigtableStackdriverExportUtils.createBucketOptions(distribution.getBucketOptions())).setCount(distribution.getCount()).setMean(distribution.getCount() == 0L ? 0.0 : distribution.getSum() / (double)distribution.getCount()).setSumOfSquaredDeviation(distribution.getSumOfSquaredDeviations());
        BigtableStackdriverExportUtils.setBucketCounts(distribution.getBuckets(), builder);
        return builder.build();
    }

    private static Distribution.BucketOptions createBucketOptions(@Nullable Distribution.BucketOptions bucketOptions) {
        Distribution.BucketOptions.Builder builder = Distribution.BucketOptions.newBuilder();
        return bucketOptions == null ? builder.build() : bucketOptions.match(bucketOptionsExplicitFunction, Functions.throwIllegalArgumentException());
    }

    private static void setBucketCounts(List<Distribution.Bucket> buckets, Distribution.Builder builder) {
        builder.addBucketCounts(0L);
        for (Distribution.Bucket bucket : buckets) {
            builder.addBucketCounts(bucket.getCount());
        }
    }

    private static Timestamp convertTimestamp(com.google.bigtable.veneer.repackaged.io.opencensus.common.Timestamp censusTimestamp) {
        return censusTimestamp.getSeconds() < 0L ? Timestamp.newBuilder().build() : Timestamp.newBuilder().setSeconds(censusTimestamp.getSeconds()).setNanos(censusTimestamp.getNanos()).build();
    }
}

