/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.stats;

import com.google.api.core.InternalApi;
import com.google.bigtable.veneer.repackaged.io.opencensus.stats.MeasureMap;
import com.google.bigtable.veneer.repackaged.io.opencensus.stats.StatsRecorder;
import com.google.bigtable.veneer.repackaged.io.opencensus.tags.TagContext;
import com.google.bigtable.veneer.repackaged.io.opencensus.tags.TagContextBuilder;
import com.google.bigtable.veneer.repackaged.io.opencensus.tags.TagKey;
import com.google.bigtable.veneer.repackaged.io.opencensus.tags.TagValue;
import com.google.bigtable.veneer.repackaged.io.opencensus.tags.Tagger;
import com.google.bigtable.veneer.repackaged.io.opencensus.tags.Tags;
import com.google.cloud.bigtable.stats.BuiltinMeasureConstants;
import java.util.Map;

@InternalApi(value="For internal use only")
public class StatsRecorderWrapperForConnection {
    private final StatsRecorder statsRecorder;
    private final TagContext tagContext;
    private MeasureMap perConnectionErrorCountMeasureMap;

    public StatsRecorderWrapperForConnection(Map<String, String> statsAttributes, StatsRecorder statsRecorder) {
        this.statsRecorder = statsRecorder;
        this.perConnectionErrorCountMeasureMap = statsRecorder.newMeasureMap();
        Tagger tagger = Tags.getTagger();
        TagContextBuilder tagContextBuilder = tagger.toBuilder(tagger.getCurrentTagContext());
        for (Map.Entry<String, String> entry : statsAttributes.entrySet()) {
            tagContextBuilder.putLocal(TagKey.create(entry.getKey()), TagValue.create(entry.getValue()));
        }
        this.tagContext = tagContextBuilder.build();
    }

    public void putAndRecordPerConnectionErrorCount(long errorCount) {
        this.perConnectionErrorCountMeasureMap.put(BuiltinMeasureConstants.PER_CONNECTION_ERROR_COUNT, errorCount);
        this.perConnectionErrorCountMeasureMap.record(this.tagContext);
        this.perConnectionErrorCountMeasureMap = this.statsRecorder.newMeasureMap();
    }
}

