/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.stub.readrows.StateMachine;
import com.google.cloud.bigtable.gaxx.reframing.Reframer;
import com.google.common.base.Preconditions;

@InternalApi
public class RowMerger<RowT>
implements Reframer<RowT, ReadRowsResponse> {
    private final StateMachine<RowT> stateMachine;
    private ReadRowsResponse buffer;
    private int nextChunk;
    private RowT nextRow;

    public RowMerger(RowAdapter.RowBuilder<RowT> rowBuilder) {
        this.stateMachine = new StateMachine<RowT>(rowBuilder);
        this.nextChunk = 0;
        this.buffer = ReadRowsResponse.getDefaultInstance();
    }

    @Override
    public void push(ReadRowsResponse response) {
        Preconditions.checkState((this.buffer.getChunksCount() <= this.nextChunk ? 1 : 0) != 0, (Object)"Previous response not fully consumed");
        this.buffer = response;
        this.nextChunk = 0;
        if (!response.getLastScannedRowKey().isEmpty()) {
            this.stateMachine.handleLastScannedRow(response.getLastScannedRowKey());
        }
    }

    @Override
    public boolean hasFullFrame() {
        if (this.nextRow != null) {
            return true;
        }
        boolean newRowCompleted = this.readNextRow();
        return newRowCompleted;
    }

    @Override
    public boolean hasPartialFrame() {
        if (this.hasFullFrame()) {
            return true;
        }
        return this.stateMachine.isRowInProgress();
    }

    @Override
    public RowT pop() {
        RowT row = this.nextRow;
        this.nextRow = null;
        return row;
    }

    private boolean readNextRow() {
        if (this.stateMachine.hasCompleteRow()) {
            this.nextRow = this.stateMachine.consumeRow();
            return true;
        }
        while (this.nextChunk < this.buffer.getChunksCount()) {
            this.stateMachine.handleChunk(this.buffer.getChunks(this.nextChunk++));
            if (!this.stateMachine.hasCompleteRow()) continue;
            this.nextRow = this.stateMachine.consumeRow();
            return true;
        }
        return false;
    }
}

