/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConnectionErrorCountInterceptor
implements ClientInterceptor {
    private static final Logger LOG = Logger.getLogger(ConnectionErrorCountInterceptor.class.toString());
    private final LongAdder numOfErrors = new LongAdder();
    private final LongAdder numOfSuccesses = new LongAdder();

    ConnectionErrorCountInterceptor() {
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(methodDescriptor, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onClose(Status status, Metadata trailers) {
                        try {
                            this.handleOnCloseUnsafe(status);
                        }
                        catch (Throwable t) {
                            if (t instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                            }
                            LOG.log(Level.WARNING, "Unexpected error while updating connection error stats", t);
                        }
                        super.onClose(status, trailers);
                    }

                    private void handleOnCloseUnsafe(Status status) {
                        if (status.isOk()) {
                            ConnectionErrorCountInterceptor.this.numOfSuccesses.increment();
                        } else {
                            ConnectionErrorCountInterceptor.this.numOfErrors.increment();
                        }
                    }
                }, headers);
            }
        };
    }

    long getAndResetNumOfErrors() {
        return this.numOfErrors.sumThenReset();
    }

    long getAndResetNumOfSuccesses() {
        return this.numOfSuccesses.sumThenReset();
    }
}

