/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.binaryauthorization.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.binaryauthorization.v1beta1.Attestor;
import com.google.cloud.binaryauthorization.v1beta1.AttestorName;
import com.google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1Settings;
import com.google.cloud.binaryauthorization.v1beta1.CreateAttestorRequest;
import com.google.cloud.binaryauthorization.v1beta1.DeleteAttestorRequest;
import com.google.cloud.binaryauthorization.v1beta1.GetAttestorRequest;
import com.google.cloud.binaryauthorization.v1beta1.GetPolicyRequest;
import com.google.cloud.binaryauthorization.v1beta1.ListAttestorsRequest;
import com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse;
import com.google.cloud.binaryauthorization.v1beta1.Policy;
import com.google.cloud.binaryauthorization.v1beta1.PolicyName;
import com.google.cloud.binaryauthorization.v1beta1.ProjectName;
import com.google.cloud.binaryauthorization.v1beta1.UpdateAttestorRequest;
import com.google.cloud.binaryauthorization.v1beta1.UpdatePolicyRequest;
import com.google.cloud.binaryauthorization.v1beta1.stub.BinauthzManagementServiceV1Beta1Stub;
import com.google.cloud.binaryauthorization.v1beta1.stub.BinauthzManagementServiceV1Beta1StubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BinauthzManagementServiceV1Beta1Client
implements BackgroundResource {
    private final BinauthzManagementServiceV1Beta1Settings settings;
    private final BinauthzManagementServiceV1Beta1Stub stub;

    public static final BinauthzManagementServiceV1Beta1Client create() throws IOException {
        return BinauthzManagementServiceV1Beta1Client.create(BinauthzManagementServiceV1Beta1Settings.newBuilder().build());
    }

    public static final BinauthzManagementServiceV1Beta1Client create(BinauthzManagementServiceV1Beta1Settings settings) throws IOException {
        return new BinauthzManagementServiceV1Beta1Client(settings);
    }

    public static final BinauthzManagementServiceV1Beta1Client create(BinauthzManagementServiceV1Beta1Stub stub) {
        return new BinauthzManagementServiceV1Beta1Client(stub);
    }

    protected BinauthzManagementServiceV1Beta1Client(BinauthzManagementServiceV1Beta1Settings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BinauthzManagementServiceV1Beta1StubSettings)settings.getStubSettings()).createStub();
    }

    protected BinauthzManagementServiceV1Beta1Client(BinauthzManagementServiceV1Beta1Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BinauthzManagementServiceV1Beta1Settings getSettings() {
        return this.settings;
    }

    public BinauthzManagementServiceV1Beta1Stub getStub() {
        return this.stub;
    }

    public final Policy getPolicy(PolicyName name) {
        GetPolicyRequest request = GetPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPolicy(request);
    }

    public final Policy getPolicy(String name) {
        GetPolicyRequest request = GetPolicyRequest.newBuilder().setName(name).build();
        return this.getPolicy(request);
    }

    public final Policy getPolicy(GetPolicyRequest request) {
        return (Policy)this.getPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetPolicyRequest, Policy> getPolicyCallable() {
        return this.stub.getPolicyCallable();
    }

    public final Policy updatePolicy(Policy policy) {
        UpdatePolicyRequest request = UpdatePolicyRequest.newBuilder().setPolicy(policy).build();
        return this.updatePolicy(request);
    }

    public final Policy updatePolicy(UpdatePolicyRequest request) {
        return (Policy)this.updatePolicyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePolicyRequest, Policy> updatePolicyCallable() {
        return this.stub.updatePolicyCallable();
    }

    public final Attestor createAttestor(ProjectName parent, String attestorId, Attestor attestor) {
        CreateAttestorRequest request = CreateAttestorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAttestorId(attestorId).setAttestor(attestor).build();
        return this.createAttestor(request);
    }

    public final Attestor createAttestor(String parent, String attestorId, Attestor attestor) {
        CreateAttestorRequest request = CreateAttestorRequest.newBuilder().setParent(parent).setAttestorId(attestorId).setAttestor(attestor).build();
        return this.createAttestor(request);
    }

    public final Attestor createAttestor(CreateAttestorRequest request) {
        return (Attestor)this.createAttestorCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAttestorRequest, Attestor> createAttestorCallable() {
        return this.stub.createAttestorCallable();
    }

    public final Attestor getAttestor(AttestorName name) {
        GetAttestorRequest request = GetAttestorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAttestor(request);
    }

    public final Attestor getAttestor(String name) {
        GetAttestorRequest request = GetAttestorRequest.newBuilder().setName(name).build();
        return this.getAttestor(request);
    }

    public final Attestor getAttestor(GetAttestorRequest request) {
        return (Attestor)this.getAttestorCallable().call((Object)request);
    }

    public final UnaryCallable<GetAttestorRequest, Attestor> getAttestorCallable() {
        return this.stub.getAttestorCallable();
    }

    public final Attestor updateAttestor(Attestor attestor) {
        UpdateAttestorRequest request = UpdateAttestorRequest.newBuilder().setAttestor(attestor).build();
        return this.updateAttestor(request);
    }

    public final Attestor updateAttestor(UpdateAttestorRequest request) {
        return (Attestor)this.updateAttestorCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAttestorRequest, Attestor> updateAttestorCallable() {
        return this.stub.updateAttestorCallable();
    }

    public final ListAttestorsPagedResponse listAttestors(ProjectName parent) {
        ListAttestorsRequest request = ListAttestorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAttestors(request);
    }

    public final ListAttestorsPagedResponse listAttestors(String parent) {
        ListAttestorsRequest request = ListAttestorsRequest.newBuilder().setParent(parent).build();
        return this.listAttestors(request);
    }

    public final ListAttestorsPagedResponse listAttestors(ListAttestorsRequest request) {
        return (ListAttestorsPagedResponse)((Object)this.listAttestorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAttestorsRequest, ListAttestorsPagedResponse> listAttestorsPagedCallable() {
        return this.stub.listAttestorsPagedCallable();
    }

    public final UnaryCallable<ListAttestorsRequest, ListAttestorsResponse> listAttestorsCallable() {
        return this.stub.listAttestorsCallable();
    }

    public final void deleteAttestor(AttestorName name) {
        DeleteAttestorRequest request = DeleteAttestorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAttestor(request);
    }

    public final void deleteAttestor(String name) {
        DeleteAttestorRequest request = DeleteAttestorRequest.newBuilder().setName(name).build();
        this.deleteAttestor(request);
    }

    public final void deleteAttestor(DeleteAttestorRequest request) {
        this.deleteAttestorCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAttestorRequest, Empty> deleteAttestorCallable() {
        return this.stub.deleteAttestorCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAttestorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAttestorsRequest, ListAttestorsResponse, Attestor, ListAttestorsPage, ListAttestorsFixedSizeCollection> {
        private ListAttestorsFixedSizeCollection(List<ListAttestorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAttestorsFixedSizeCollection createEmptyCollection() {
            return new ListAttestorsFixedSizeCollection(null, 0);
        }

        protected ListAttestorsFixedSizeCollection createCollection(List<ListAttestorsPage> pages, int collectionSize) {
            return new ListAttestorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAttestorsPage
    extends AbstractPage<ListAttestorsRequest, ListAttestorsResponse, Attestor, ListAttestorsPage> {
        private ListAttestorsPage(PageContext<ListAttestorsRequest, ListAttestorsResponse, Attestor> context, ListAttestorsResponse response) {
            super(context, (Object)response);
        }

        private static ListAttestorsPage createEmptyPage() {
            return new ListAttestorsPage(null, null);
        }

        protected ListAttestorsPage createPage(PageContext<ListAttestorsRequest, ListAttestorsResponse, Attestor> context, ListAttestorsResponse response) {
            return new ListAttestorsPage(context, response);
        }

        public ApiFuture<ListAttestorsPage> createPageAsync(PageContext<ListAttestorsRequest, ListAttestorsResponse, Attestor> context, ApiFuture<ListAttestorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAttestorsPagedResponse
    extends AbstractPagedListResponse<ListAttestorsRequest, ListAttestorsResponse, Attestor, ListAttestorsPage, ListAttestorsFixedSizeCollection> {
        public static ApiFuture<ListAttestorsPagedResponse> createAsync(PageContext<ListAttestorsRequest, ListAttestorsResponse, Attestor> context, ApiFuture<ListAttestorsResponse> futureResponse) {
            ApiFuture<ListAttestorsPage> futurePage = ListAttestorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAttestorsPagedResponse((ListAttestorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAttestorsPagedResponse(ListAttestorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAttestorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

