/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.channel.v1.CloudChannelReportsServiceClient;
import com.google.cloud.channel.v1.FetchReportResultsRequest;
import com.google.cloud.channel.v1.FetchReportResultsResponse;
import com.google.cloud.channel.v1.ListReportsRequest;
import com.google.cloud.channel.v1.ListReportsResponse;
import com.google.cloud.channel.v1.OperationMetadata;
import com.google.cloud.channel.v1.RunReportJobRequest;
import com.google.cloud.channel.v1.RunReportJobResponse;
import com.google.cloud.channel.v1.stub.CloudChannelReportsServiceStub;
import com.google.cloud.channel.v1.stub.CloudChannelReportsServiceStubSettings;
import com.google.cloud.channel.v1.stub.HttpJsonCloudChannelReportsServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCloudChannelReportsServiceStub
extends CloudChannelReportsServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(RunReportJobResponse.getDescriptor()).add(OperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<RunReportJobRequest, Operation> runReportJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.channel.v1.CloudChannelReportsService/RunReportJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=accounts/*/reports/*}:run", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<FetchReportResultsRequest, FetchReportResultsResponse> fetchReportResultsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.channel.v1.CloudChannelReportsService/FetchReportResults").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{reportJob=accounts/*/reportJobs/*}:fetchReportResults", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "reportJob", (Object)request.getReportJob());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearReportJob().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchReportResultsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListReportsRequest, ListReportsResponse> listReportsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.channel.v1.CloudChannelReportsService/ListReports").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=accounts/*}/reports", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "languageCode", (Object)request.getLanguageCode());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListReportsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<RunReportJobRequest, Operation> runReportJobCallable;
    private final OperationCallable<RunReportJobRequest, RunReportJobResponse, OperationMetadata> runReportJobOperationCallable;
    private final UnaryCallable<FetchReportResultsRequest, FetchReportResultsResponse> fetchReportResultsCallable;
    private final UnaryCallable<FetchReportResultsRequest, CloudChannelReportsServiceClient.FetchReportResultsPagedResponse> fetchReportResultsPagedCallable;
    private final UnaryCallable<ListReportsRequest, ListReportsResponse> listReportsCallable;
    private final UnaryCallable<ListReportsRequest, CloudChannelReportsServiceClient.ListReportsPagedResponse> listReportsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCloudChannelReportsServiceStub create(CloudChannelReportsServiceStubSettings settings) throws IOException {
        return new HttpJsonCloudChannelReportsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCloudChannelReportsServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCloudChannelReportsServiceStub(CloudChannelReportsServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCloudChannelReportsServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCloudChannelReportsServiceStub(CloudChannelReportsServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCloudChannelReportsServiceStub(CloudChannelReportsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCloudChannelReportsServiceCallableFactory());
    }

    protected HttpJsonCloudChannelReportsServiceStub(CloudChannelReportsServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings runReportJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(runReportJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings fetchReportResultsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchReportResultsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listReportsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listReportsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.runReportJobCallable = callableFactory.createUnaryCallable(runReportJobTransportSettings, settings.runReportJobSettings(), clientContext);
        this.runReportJobOperationCallable = callableFactory.createOperationCallable(runReportJobTransportSettings, settings.runReportJobOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.fetchReportResultsCallable = callableFactory.createUnaryCallable(fetchReportResultsTransportSettings, settings.fetchReportResultsSettings(), clientContext);
        this.fetchReportResultsPagedCallable = callableFactory.createPagedCallable(fetchReportResultsTransportSettings, settings.fetchReportResultsSettings(), clientContext);
        this.listReportsCallable = callableFactory.createUnaryCallable(listReportsTransportSettings, settings.listReportsSettings(), clientContext);
        this.listReportsPagedCallable = callableFactory.createPagedCallable(listReportsTransportSettings, settings.listReportsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(runReportJobMethodDescriptor);
        methodDescriptors.add(fetchReportResultsMethodDescriptor);
        methodDescriptors.add(listReportsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<RunReportJobRequest, Operation> runReportJobCallable() {
        return this.runReportJobCallable;
    }

    @Override
    public OperationCallable<RunReportJobRequest, RunReportJobResponse, OperationMetadata> runReportJobOperationCallable() {
        return this.runReportJobOperationCallable;
    }

    @Override
    public UnaryCallable<FetchReportResultsRequest, FetchReportResultsResponse> fetchReportResultsCallable() {
        return this.fetchReportResultsCallable;
    }

    @Override
    public UnaryCallable<FetchReportResultsRequest, CloudChannelReportsServiceClient.FetchReportResultsPagedResponse> fetchReportResultsPagedCallable() {
        return this.fetchReportResultsPagedCallable;
    }

    @Override
    public UnaryCallable<ListReportsRequest, ListReportsResponse> listReportsCallable() {
        return this.listReportsCallable;
    }

    @Override
    public UnaryCallable<ListReportsRequest, CloudChannelReportsServiceClient.ListReportsPagedResponse> listReportsPagedCallable() {
        return this.listReportsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

