/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2.Attachment;
import com.google.cloud.support.v2.CaseAttachmentServiceSettings;
import com.google.cloud.support.v2.CaseName;
import com.google.cloud.support.v2.ListAttachmentsRequest;
import com.google.cloud.support.v2.ListAttachmentsResponse;
import com.google.cloud.support.v2.stub.CaseAttachmentServiceStub;
import com.google.cloud.support.v2.stub.CaseAttachmentServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CaseAttachmentServiceClient
implements BackgroundResource {
    private final CaseAttachmentServiceSettings settings;
    private final CaseAttachmentServiceStub stub;

    public static final CaseAttachmentServiceClient create() throws IOException {
        return CaseAttachmentServiceClient.create(CaseAttachmentServiceSettings.newBuilder().build());
    }

    public static final CaseAttachmentServiceClient create(CaseAttachmentServiceSettings settings) throws IOException {
        return new CaseAttachmentServiceClient(settings);
    }

    public static final CaseAttachmentServiceClient create(CaseAttachmentServiceStub stub) {
        return new CaseAttachmentServiceClient(stub);
    }

    protected CaseAttachmentServiceClient(CaseAttachmentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CaseAttachmentServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CaseAttachmentServiceClient(CaseAttachmentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CaseAttachmentServiceSettings getSettings() {
        return this.settings;
    }

    public CaseAttachmentServiceStub getStub() {
        return this.stub;
    }

    public final ListAttachmentsPagedResponse listAttachments(CaseName parent) {
        ListAttachmentsRequest request = ListAttachmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAttachments(request);
    }

    public final ListAttachmentsPagedResponse listAttachments(String parent) {
        ListAttachmentsRequest request = ListAttachmentsRequest.newBuilder().setParent(parent).build();
        return this.listAttachments(request);
    }

    public final ListAttachmentsPagedResponse listAttachments(ListAttachmentsRequest request) {
        return (ListAttachmentsPagedResponse)((Object)this.listAttachmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAttachmentsRequest, ListAttachmentsPagedResponse> listAttachmentsPagedCallable() {
        return this.stub.listAttachmentsPagedCallable();
    }

    public final UnaryCallable<ListAttachmentsRequest, ListAttachmentsResponse> listAttachmentsCallable() {
        return this.stub.listAttachmentsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAttachmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAttachmentsRequest, ListAttachmentsResponse, Attachment, ListAttachmentsPage, ListAttachmentsFixedSizeCollection> {
        private ListAttachmentsFixedSizeCollection(List<ListAttachmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAttachmentsFixedSizeCollection createEmptyCollection() {
            return new ListAttachmentsFixedSizeCollection(null, 0);
        }

        protected ListAttachmentsFixedSizeCollection createCollection(List<ListAttachmentsPage> pages, int collectionSize) {
            return new ListAttachmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAttachmentsPage
    extends AbstractPage<ListAttachmentsRequest, ListAttachmentsResponse, Attachment, ListAttachmentsPage> {
        private ListAttachmentsPage(PageContext<ListAttachmentsRequest, ListAttachmentsResponse, Attachment> context, ListAttachmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListAttachmentsPage createEmptyPage() {
            return new ListAttachmentsPage(null, null);
        }

        protected ListAttachmentsPage createPage(PageContext<ListAttachmentsRequest, ListAttachmentsResponse, Attachment> context, ListAttachmentsResponse response) {
            return new ListAttachmentsPage(context, response);
        }

        public ApiFuture<ListAttachmentsPage> createPageAsync(PageContext<ListAttachmentsRequest, ListAttachmentsResponse, Attachment> context, ApiFuture<ListAttachmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAttachmentsPagedResponse
    extends AbstractPagedListResponse<ListAttachmentsRequest, ListAttachmentsResponse, Attachment, ListAttachmentsPage, ListAttachmentsFixedSizeCollection> {
        public static ApiFuture<ListAttachmentsPagedResponse> createAsync(PageContext<ListAttachmentsRequest, ListAttachmentsResponse, Attachment> context, ApiFuture<ListAttachmentsResponse> futureResponse) {
            ApiFuture<ListAttachmentsPage> futurePage = ListAttachmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAttachmentsPagedResponse((ListAttachmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAttachmentsPagedResponse(ListAttachmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAttachmentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

