/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.BulkInsertRegionInstanceRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.stub.HttpJsonRegionInstancesCallableFactory;
import com.google.cloud.compute.v1.stub.HttpJsonRegionOperationsStub;
import com.google.cloud.compute.v1.stub.RegionInstancesStub;
import com.google.cloud.compute.v1.stub.RegionInstancesStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonRegionInstancesStub
extends RegionInstancesStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Operation.getDescriptor()).build();
    private static final ApiMethodDescriptor<BulkInsertRegionInstanceRequest, Operation> bulkInsertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionInstances/BulkInsert").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/instances/bulkInsert", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("bulkInsertInstanceResourceResource", (Message)request.getBulkInsertInstanceResourceResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getRegion());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private final UnaryCallable<BulkInsertRegionInstanceRequest, Operation> bulkInsertCallable;
    private final OperationCallable<BulkInsertRegionInstanceRequest, Operation, Operation> bulkInsertOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonRegionOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRegionInstancesStub create(RegionInstancesStubSettings settings) throws IOException {
        return new HttpJsonRegionInstancesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRegionInstancesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRegionInstancesStub(RegionInstancesStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonRegionInstancesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRegionInstancesStub(RegionInstancesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRegionInstancesStub(RegionInstancesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRegionInstancesCallableFactory());
    }

    protected HttpJsonRegionInstancesStub(RegionInstancesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonRegionOperationsStub.create(clientContext, callableFactory);
        HttpJsonCallSettings bulkInsertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(bulkInsertMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.bulkInsertCallable = callableFactory.createUnaryCallable(bulkInsertTransportSettings, settings.bulkInsertSettings(), clientContext);
        this.bulkInsertOperationCallable = callableFactory.createOperationCallable(bulkInsertTransportSettings, settings.bulkInsertOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(bulkInsertMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<BulkInsertRegionInstanceRequest, Operation> bulkInsertCallable() {
        return this.bulkInsertCallable;
    }

    @Override
    public OperationCallable<BulkInsertRegionInstanceRequest, Operation, Operation> bulkInsertOperationCallable() {
        return this.bulkInsertOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

