/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataform.v1alpha2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataform.v1alpha2.CancelWorkflowInvocationRequest;
import com.google.cloud.dataform.v1alpha2.CommitWorkspaceChangesRequest;
import com.google.cloud.dataform.v1alpha2.CompilationResult;
import com.google.cloud.dataform.v1alpha2.CompilationResultAction;
import com.google.cloud.dataform.v1alpha2.CompilationResultName;
import com.google.cloud.dataform.v1alpha2.CreateCompilationResultRequest;
import com.google.cloud.dataform.v1alpha2.CreateRepositoryRequest;
import com.google.cloud.dataform.v1alpha2.CreateWorkflowInvocationRequest;
import com.google.cloud.dataform.v1alpha2.CreateWorkspaceRequest;
import com.google.cloud.dataform.v1alpha2.DataformSettings;
import com.google.cloud.dataform.v1alpha2.DeleteRepositoryRequest;
import com.google.cloud.dataform.v1alpha2.DeleteWorkflowInvocationRequest;
import com.google.cloud.dataform.v1alpha2.DeleteWorkspaceRequest;
import com.google.cloud.dataform.v1alpha2.FetchFileDiffRequest;
import com.google.cloud.dataform.v1alpha2.FetchFileDiffResponse;
import com.google.cloud.dataform.v1alpha2.FetchFileGitStatusesRequest;
import com.google.cloud.dataform.v1alpha2.FetchFileGitStatusesResponse;
import com.google.cloud.dataform.v1alpha2.FetchGitAheadBehindRequest;
import com.google.cloud.dataform.v1alpha2.FetchGitAheadBehindResponse;
import com.google.cloud.dataform.v1alpha2.FetchRemoteBranchesRequest;
import com.google.cloud.dataform.v1alpha2.FetchRemoteBranchesResponse;
import com.google.cloud.dataform.v1alpha2.GetCompilationResultRequest;
import com.google.cloud.dataform.v1alpha2.GetRepositoryRequest;
import com.google.cloud.dataform.v1alpha2.GetWorkflowInvocationRequest;
import com.google.cloud.dataform.v1alpha2.GetWorkspaceRequest;
import com.google.cloud.dataform.v1alpha2.InstallNpmPackagesRequest;
import com.google.cloud.dataform.v1alpha2.InstallNpmPackagesResponse;
import com.google.cloud.dataform.v1alpha2.ListCompilationResultsRequest;
import com.google.cloud.dataform.v1alpha2.ListCompilationResultsResponse;
import com.google.cloud.dataform.v1alpha2.ListRepositoriesRequest;
import com.google.cloud.dataform.v1alpha2.ListRepositoriesResponse;
import com.google.cloud.dataform.v1alpha2.ListWorkflowInvocationsRequest;
import com.google.cloud.dataform.v1alpha2.ListWorkflowInvocationsResponse;
import com.google.cloud.dataform.v1alpha2.ListWorkspacesRequest;
import com.google.cloud.dataform.v1alpha2.ListWorkspacesResponse;
import com.google.cloud.dataform.v1alpha2.LocationName;
import com.google.cloud.dataform.v1alpha2.MakeDirectoryRequest;
import com.google.cloud.dataform.v1alpha2.MakeDirectoryResponse;
import com.google.cloud.dataform.v1alpha2.MoveDirectoryRequest;
import com.google.cloud.dataform.v1alpha2.MoveDirectoryResponse;
import com.google.cloud.dataform.v1alpha2.MoveFileRequest;
import com.google.cloud.dataform.v1alpha2.MoveFileResponse;
import com.google.cloud.dataform.v1alpha2.PullGitCommitsRequest;
import com.google.cloud.dataform.v1alpha2.PushGitCommitsRequest;
import com.google.cloud.dataform.v1alpha2.QueryCompilationResultActionsRequest;
import com.google.cloud.dataform.v1alpha2.QueryCompilationResultActionsResponse;
import com.google.cloud.dataform.v1alpha2.QueryDirectoryContentsRequest;
import com.google.cloud.dataform.v1alpha2.QueryDirectoryContentsResponse;
import com.google.cloud.dataform.v1alpha2.QueryWorkflowInvocationActionsRequest;
import com.google.cloud.dataform.v1alpha2.QueryWorkflowInvocationActionsResponse;
import com.google.cloud.dataform.v1alpha2.ReadFileRequest;
import com.google.cloud.dataform.v1alpha2.ReadFileResponse;
import com.google.cloud.dataform.v1alpha2.RemoveDirectoryRequest;
import com.google.cloud.dataform.v1alpha2.RemoveFileRequest;
import com.google.cloud.dataform.v1alpha2.Repository;
import com.google.cloud.dataform.v1alpha2.RepositoryName;
import com.google.cloud.dataform.v1alpha2.ResetWorkspaceChangesRequest;
import com.google.cloud.dataform.v1alpha2.UpdateRepositoryRequest;
import com.google.cloud.dataform.v1alpha2.WorkflowInvocation;
import com.google.cloud.dataform.v1alpha2.WorkflowInvocationAction;
import com.google.cloud.dataform.v1alpha2.WorkflowInvocationName;
import com.google.cloud.dataform.v1alpha2.Workspace;
import com.google.cloud.dataform.v1alpha2.WorkspaceName;
import com.google.cloud.dataform.v1alpha2.WriteFileRequest;
import com.google.cloud.dataform.v1alpha2.WriteFileResponse;
import com.google.cloud.dataform.v1alpha2.stub.DataformStub;
import com.google.cloud.dataform.v1alpha2.stub.DataformStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataformClient
implements BackgroundResource {
    private final DataformSettings settings;
    private final DataformStub stub;

    public static final DataformClient create() throws IOException {
        return DataformClient.create(DataformSettings.newBuilder().build());
    }

    public static final DataformClient create(DataformSettings settings) throws IOException {
        return new DataformClient(settings);
    }

    public static final DataformClient create(DataformStub stub) {
        return new DataformClient(stub);
    }

    protected DataformClient(DataformSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataformStubSettings)settings.getStubSettings()).createStub();
    }

    protected DataformClient(DataformStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataformSettings getSettings() {
        return this.settings;
    }

    public DataformStub getStub() {
        return this.stub;
    }

    public final ListRepositoriesPagedResponse listRepositories(LocationName parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(String parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(ListRepositoriesRequest request) {
        return (ListRepositoriesPagedResponse)((Object)this.listRepositoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.stub.listRepositoriesPagedCallable();
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.stub.listRepositoriesCallable();
    }

    public final Repository getRepository(RepositoryName name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(String name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(GetRepositoryRequest request) {
        return (Repository)this.getRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.stub.getRepositoryCallable();
    }

    public final Repository createRepository(LocationName parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepository(request);
    }

    public final Repository createRepository(String parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepository(request);
    }

    public final Repository createRepository(CreateRepositoryRequest request) {
        return (Repository)this.createRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<CreateRepositoryRequest, Repository> createRepositoryCallable() {
        return this.stub.createRepositoryCallable();
    }

    public final Repository updateRepository(Repository repository, FieldMask updateMask) {
        UpdateRepositoryRequest request = UpdateRepositoryRequest.newBuilder().setRepository(repository).setUpdateMask(updateMask).build();
        return this.updateRepository(request);
    }

    public final Repository updateRepository(UpdateRepositoryRequest request) {
        return (Repository)this.updateRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRepositoryRequest, Repository> updateRepositoryCallable() {
        return this.stub.updateRepositoryCallable();
    }

    public final void deleteRepository(RepositoryName name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteRepository(request);
    }

    public final void deleteRepository(String name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name).build();
        this.deleteRepository(request);
    }

    public final void deleteRepository(DeleteRepositoryRequest request) {
        this.deleteRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRepositoryRequest, Empty> deleteRepositoryCallable() {
        return this.stub.deleteRepositoryCallable();
    }

    public final FetchRemoteBranchesResponse fetchRemoteBranches(FetchRemoteBranchesRequest request) {
        return (FetchRemoteBranchesResponse)this.fetchRemoteBranchesCallable().call((Object)request);
    }

    public final UnaryCallable<FetchRemoteBranchesRequest, FetchRemoteBranchesResponse> fetchRemoteBranchesCallable() {
        return this.stub.fetchRemoteBranchesCallable();
    }

    public final ListWorkspacesPagedResponse listWorkspaces(RepositoryName parent) {
        ListWorkspacesRequest request = ListWorkspacesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkspaces(request);
    }

    public final ListWorkspacesPagedResponse listWorkspaces(String parent) {
        ListWorkspacesRequest request = ListWorkspacesRequest.newBuilder().setParent(parent).build();
        return this.listWorkspaces(request);
    }

    public final ListWorkspacesPagedResponse listWorkspaces(ListWorkspacesRequest request) {
        return (ListWorkspacesPagedResponse)((Object)this.listWorkspacesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkspacesRequest, ListWorkspacesPagedResponse> listWorkspacesPagedCallable() {
        return this.stub.listWorkspacesPagedCallable();
    }

    public final UnaryCallable<ListWorkspacesRequest, ListWorkspacesResponse> listWorkspacesCallable() {
        return this.stub.listWorkspacesCallable();
    }

    public final Workspace getWorkspace(WorkspaceName name) {
        GetWorkspaceRequest request = GetWorkspaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkspace(request);
    }

    public final Workspace getWorkspace(String name) {
        GetWorkspaceRequest request = GetWorkspaceRequest.newBuilder().setName(name).build();
        return this.getWorkspace(request);
    }

    public final Workspace getWorkspace(GetWorkspaceRequest request) {
        return (Workspace)this.getWorkspaceCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkspaceRequest, Workspace> getWorkspaceCallable() {
        return this.stub.getWorkspaceCallable();
    }

    public final Workspace createWorkspace(RepositoryName parent, Workspace workspace, String workspaceId) {
        CreateWorkspaceRequest request = CreateWorkspaceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkspace(workspace).setWorkspaceId(workspaceId).build();
        return this.createWorkspace(request);
    }

    public final Workspace createWorkspace(String parent, Workspace workspace, String workspaceId) {
        CreateWorkspaceRequest request = CreateWorkspaceRequest.newBuilder().setParent(parent).setWorkspace(workspace).setWorkspaceId(workspaceId).build();
        return this.createWorkspace(request);
    }

    public final Workspace createWorkspace(CreateWorkspaceRequest request) {
        return (Workspace)this.createWorkspaceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateWorkspaceRequest, Workspace> createWorkspaceCallable() {
        return this.stub.createWorkspaceCallable();
    }

    public final void deleteWorkspace(WorkspaceName name) {
        DeleteWorkspaceRequest request = DeleteWorkspaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteWorkspace(request);
    }

    public final void deleteWorkspace(String name) {
        DeleteWorkspaceRequest request = DeleteWorkspaceRequest.newBuilder().setName(name).build();
        this.deleteWorkspace(request);
    }

    public final void deleteWorkspace(DeleteWorkspaceRequest request) {
        this.deleteWorkspaceCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteWorkspaceRequest, Empty> deleteWorkspaceCallable() {
        return this.stub.deleteWorkspaceCallable();
    }

    public final InstallNpmPackagesResponse installNpmPackages(InstallNpmPackagesRequest request) {
        return (InstallNpmPackagesResponse)this.installNpmPackagesCallable().call((Object)request);
    }

    public final UnaryCallable<InstallNpmPackagesRequest, InstallNpmPackagesResponse> installNpmPackagesCallable() {
        return this.stub.installNpmPackagesCallable();
    }

    public final void pullGitCommits(PullGitCommitsRequest request) {
        this.pullGitCommitsCallable().call((Object)request);
    }

    public final UnaryCallable<PullGitCommitsRequest, Empty> pullGitCommitsCallable() {
        return this.stub.pullGitCommitsCallable();
    }

    public final void pushGitCommits(PushGitCommitsRequest request) {
        this.pushGitCommitsCallable().call((Object)request);
    }

    public final UnaryCallable<PushGitCommitsRequest, Empty> pushGitCommitsCallable() {
        return this.stub.pushGitCommitsCallable();
    }

    public final FetchFileGitStatusesResponse fetchFileGitStatuses(FetchFileGitStatusesRequest request) {
        return (FetchFileGitStatusesResponse)this.fetchFileGitStatusesCallable().call((Object)request);
    }

    public final UnaryCallable<FetchFileGitStatusesRequest, FetchFileGitStatusesResponse> fetchFileGitStatusesCallable() {
        return this.stub.fetchFileGitStatusesCallable();
    }

    public final FetchGitAheadBehindResponse fetchGitAheadBehind(FetchGitAheadBehindRequest request) {
        return (FetchGitAheadBehindResponse)this.fetchGitAheadBehindCallable().call((Object)request);
    }

    public final UnaryCallable<FetchGitAheadBehindRequest, FetchGitAheadBehindResponse> fetchGitAheadBehindCallable() {
        return this.stub.fetchGitAheadBehindCallable();
    }

    public final void commitWorkspaceChanges(CommitWorkspaceChangesRequest request) {
        this.commitWorkspaceChangesCallable().call((Object)request);
    }

    public final UnaryCallable<CommitWorkspaceChangesRequest, Empty> commitWorkspaceChangesCallable() {
        return this.stub.commitWorkspaceChangesCallable();
    }

    public final void resetWorkspaceChanges(ResetWorkspaceChangesRequest request) {
        this.resetWorkspaceChangesCallable().call((Object)request);
    }

    public final UnaryCallable<ResetWorkspaceChangesRequest, Empty> resetWorkspaceChangesCallable() {
        return this.stub.resetWorkspaceChangesCallable();
    }

    public final FetchFileDiffResponse fetchFileDiff(FetchFileDiffRequest request) {
        return (FetchFileDiffResponse)this.fetchFileDiffCallable().call((Object)request);
    }

    public final UnaryCallable<FetchFileDiffRequest, FetchFileDiffResponse> fetchFileDiffCallable() {
        return this.stub.fetchFileDiffCallable();
    }

    public final QueryDirectoryContentsPagedResponse queryDirectoryContents(QueryDirectoryContentsRequest request) {
        return (QueryDirectoryContentsPagedResponse)((Object)this.queryDirectoryContentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryDirectoryContentsRequest, QueryDirectoryContentsPagedResponse> queryDirectoryContentsPagedCallable() {
        return this.stub.queryDirectoryContentsPagedCallable();
    }

    public final UnaryCallable<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse> queryDirectoryContentsCallable() {
        return this.stub.queryDirectoryContentsCallable();
    }

    public final MakeDirectoryResponse makeDirectory(MakeDirectoryRequest request) {
        return (MakeDirectoryResponse)this.makeDirectoryCallable().call((Object)request);
    }

    public final UnaryCallable<MakeDirectoryRequest, MakeDirectoryResponse> makeDirectoryCallable() {
        return this.stub.makeDirectoryCallable();
    }

    public final void removeDirectory(RemoveDirectoryRequest request) {
        this.removeDirectoryCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveDirectoryRequest, Empty> removeDirectoryCallable() {
        return this.stub.removeDirectoryCallable();
    }

    public final MoveDirectoryResponse moveDirectory(MoveDirectoryRequest request) {
        return (MoveDirectoryResponse)this.moveDirectoryCallable().call((Object)request);
    }

    public final UnaryCallable<MoveDirectoryRequest, MoveDirectoryResponse> moveDirectoryCallable() {
        return this.stub.moveDirectoryCallable();
    }

    public final ReadFileResponse readFile(ReadFileRequest request) {
        return (ReadFileResponse)this.readFileCallable().call((Object)request);
    }

    public final UnaryCallable<ReadFileRequest, ReadFileResponse> readFileCallable() {
        return this.stub.readFileCallable();
    }

    public final void removeFile(RemoveFileRequest request) {
        this.removeFileCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveFileRequest, Empty> removeFileCallable() {
        return this.stub.removeFileCallable();
    }

    public final MoveFileResponse moveFile(MoveFileRequest request) {
        return (MoveFileResponse)this.moveFileCallable().call((Object)request);
    }

    public final UnaryCallable<MoveFileRequest, MoveFileResponse> moveFileCallable() {
        return this.stub.moveFileCallable();
    }

    public final WriteFileResponse writeFile(WriteFileRequest request) {
        return (WriteFileResponse)this.writeFileCallable().call((Object)request);
    }

    public final UnaryCallable<WriteFileRequest, WriteFileResponse> writeFileCallable() {
        return this.stub.writeFileCallable();
    }

    public final ListCompilationResultsPagedResponse listCompilationResults(RepositoryName parent) {
        ListCompilationResultsRequest request = ListCompilationResultsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCompilationResults(request);
    }

    public final ListCompilationResultsPagedResponse listCompilationResults(String parent) {
        ListCompilationResultsRequest request = ListCompilationResultsRequest.newBuilder().setParent(parent).build();
        return this.listCompilationResults(request);
    }

    public final ListCompilationResultsPagedResponse listCompilationResults(ListCompilationResultsRequest request) {
        return (ListCompilationResultsPagedResponse)((Object)this.listCompilationResultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCompilationResultsRequest, ListCompilationResultsPagedResponse> listCompilationResultsPagedCallable() {
        return this.stub.listCompilationResultsPagedCallable();
    }

    public final UnaryCallable<ListCompilationResultsRequest, ListCompilationResultsResponse> listCompilationResultsCallable() {
        return this.stub.listCompilationResultsCallable();
    }

    public final CompilationResult getCompilationResult(CompilationResultName name) {
        GetCompilationResultRequest request = GetCompilationResultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCompilationResult(request);
    }

    public final CompilationResult getCompilationResult(String name) {
        GetCompilationResultRequest request = GetCompilationResultRequest.newBuilder().setName(name).build();
        return this.getCompilationResult(request);
    }

    public final CompilationResult getCompilationResult(GetCompilationResultRequest request) {
        return (CompilationResult)this.getCompilationResultCallable().call((Object)request);
    }

    public final UnaryCallable<GetCompilationResultRequest, CompilationResult> getCompilationResultCallable() {
        return this.stub.getCompilationResultCallable();
    }

    public final CompilationResult createCompilationResult(RepositoryName parent, CompilationResult compilationResult) {
        CreateCompilationResultRequest request = CreateCompilationResultRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCompilationResult(compilationResult).build();
        return this.createCompilationResult(request);
    }

    public final CompilationResult createCompilationResult(String parent, CompilationResult compilationResult) {
        CreateCompilationResultRequest request = CreateCompilationResultRequest.newBuilder().setParent(parent).setCompilationResult(compilationResult).build();
        return this.createCompilationResult(request);
    }

    public final CompilationResult createCompilationResult(CreateCompilationResultRequest request) {
        return (CompilationResult)this.createCompilationResultCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCompilationResultRequest, CompilationResult> createCompilationResultCallable() {
        return this.stub.createCompilationResultCallable();
    }

    public final QueryCompilationResultActionsPagedResponse queryCompilationResultActions(QueryCompilationResultActionsRequest request) {
        return (QueryCompilationResultActionsPagedResponse)((Object)this.queryCompilationResultActionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryCompilationResultActionsRequest, QueryCompilationResultActionsPagedResponse> queryCompilationResultActionsPagedCallable() {
        return this.stub.queryCompilationResultActionsPagedCallable();
    }

    public final UnaryCallable<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse> queryCompilationResultActionsCallable() {
        return this.stub.queryCompilationResultActionsCallable();
    }

    public final ListWorkflowInvocationsPagedResponse listWorkflowInvocations(RepositoryName parent) {
        ListWorkflowInvocationsRequest request = ListWorkflowInvocationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkflowInvocations(request);
    }

    public final ListWorkflowInvocationsPagedResponse listWorkflowInvocations(String parent) {
        ListWorkflowInvocationsRequest request = ListWorkflowInvocationsRequest.newBuilder().setParent(parent).build();
        return this.listWorkflowInvocations(request);
    }

    public final ListWorkflowInvocationsPagedResponse listWorkflowInvocations(ListWorkflowInvocationsRequest request) {
        return (ListWorkflowInvocationsPagedResponse)((Object)this.listWorkflowInvocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkflowInvocationsRequest, ListWorkflowInvocationsPagedResponse> listWorkflowInvocationsPagedCallable() {
        return this.stub.listWorkflowInvocationsPagedCallable();
    }

    public final UnaryCallable<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse> listWorkflowInvocationsCallable() {
        return this.stub.listWorkflowInvocationsCallable();
    }

    public final WorkflowInvocation getWorkflowInvocation(WorkflowInvocationName name) {
        GetWorkflowInvocationRequest request = GetWorkflowInvocationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkflowInvocation(request);
    }

    public final WorkflowInvocation getWorkflowInvocation(String name) {
        GetWorkflowInvocationRequest request = GetWorkflowInvocationRequest.newBuilder().setName(name).build();
        return this.getWorkflowInvocation(request);
    }

    public final WorkflowInvocation getWorkflowInvocation(GetWorkflowInvocationRequest request) {
        return (WorkflowInvocation)this.getWorkflowInvocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkflowInvocationRequest, WorkflowInvocation> getWorkflowInvocationCallable() {
        return this.stub.getWorkflowInvocationCallable();
    }

    public final WorkflowInvocation createWorkflowInvocation(RepositoryName parent, WorkflowInvocation workflowInvocation) {
        CreateWorkflowInvocationRequest request = CreateWorkflowInvocationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkflowInvocation(workflowInvocation).build();
        return this.createWorkflowInvocation(request);
    }

    public final WorkflowInvocation createWorkflowInvocation(String parent, WorkflowInvocation workflowInvocation) {
        CreateWorkflowInvocationRequest request = CreateWorkflowInvocationRequest.newBuilder().setParent(parent).setWorkflowInvocation(workflowInvocation).build();
        return this.createWorkflowInvocation(request);
    }

    public final WorkflowInvocation createWorkflowInvocation(CreateWorkflowInvocationRequest request) {
        return (WorkflowInvocation)this.createWorkflowInvocationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateWorkflowInvocationRequest, WorkflowInvocation> createWorkflowInvocationCallable() {
        return this.stub.createWorkflowInvocationCallable();
    }

    public final void deleteWorkflowInvocation(WorkflowInvocationName name) {
        DeleteWorkflowInvocationRequest request = DeleteWorkflowInvocationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteWorkflowInvocation(request);
    }

    public final void deleteWorkflowInvocation(String name) {
        DeleteWorkflowInvocationRequest request = DeleteWorkflowInvocationRequest.newBuilder().setName(name).build();
        this.deleteWorkflowInvocation(request);
    }

    public final void deleteWorkflowInvocation(DeleteWorkflowInvocationRequest request) {
        this.deleteWorkflowInvocationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteWorkflowInvocationRequest, Empty> deleteWorkflowInvocationCallable() {
        return this.stub.deleteWorkflowInvocationCallable();
    }

    public final void cancelWorkflowInvocation(CancelWorkflowInvocationRequest request) {
        this.cancelWorkflowInvocationCallable().call((Object)request);
    }

    public final UnaryCallable<CancelWorkflowInvocationRequest, Empty> cancelWorkflowInvocationCallable() {
        return this.stub.cancelWorkflowInvocationCallable();
    }

    public final QueryWorkflowInvocationActionsPagedResponse queryWorkflowInvocationActions(QueryWorkflowInvocationActionsRequest request) {
        return (QueryWorkflowInvocationActionsPagedResponse)((Object)this.queryWorkflowInvocationActionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsPagedResponse> queryWorkflowInvocationActionsPagedCallable() {
        return this.stub.queryWorkflowInvocationActionsPagedCallable();
    }

    public final UnaryCallable<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse> queryWorkflowInvocationActionsCallable() {
        return this.stub.queryWorkflowInvocationActionsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class QueryWorkflowInvocationActionsFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction, QueryWorkflowInvocationActionsPage, QueryWorkflowInvocationActionsFixedSizeCollection> {
        private QueryWorkflowInvocationActionsFixedSizeCollection(List<QueryWorkflowInvocationActionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryWorkflowInvocationActionsFixedSizeCollection createEmptyCollection() {
            return new QueryWorkflowInvocationActionsFixedSizeCollection(null, 0);
        }

        protected QueryWorkflowInvocationActionsFixedSizeCollection createCollection(List<QueryWorkflowInvocationActionsPage> pages, int collectionSize) {
            return new QueryWorkflowInvocationActionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryWorkflowInvocationActionsPage
    extends AbstractPage<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction, QueryWorkflowInvocationActionsPage> {
        private QueryWorkflowInvocationActionsPage(PageContext<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction> context, QueryWorkflowInvocationActionsResponse response) {
            super(context, (Object)response);
        }

        private static QueryWorkflowInvocationActionsPage createEmptyPage() {
            return new QueryWorkflowInvocationActionsPage(null, null);
        }

        protected QueryWorkflowInvocationActionsPage createPage(PageContext<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction> context, QueryWorkflowInvocationActionsResponse response) {
            return new QueryWorkflowInvocationActionsPage(context, response);
        }

        public ApiFuture<QueryWorkflowInvocationActionsPage> createPageAsync(PageContext<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction> context, ApiFuture<QueryWorkflowInvocationActionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryWorkflowInvocationActionsPagedResponse
    extends AbstractPagedListResponse<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction, QueryWorkflowInvocationActionsPage, QueryWorkflowInvocationActionsFixedSizeCollection> {
        public static ApiFuture<QueryWorkflowInvocationActionsPagedResponse> createAsync(PageContext<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction> context, ApiFuture<QueryWorkflowInvocationActionsResponse> futureResponse) {
            ApiFuture<QueryWorkflowInvocationActionsPage> futurePage = QueryWorkflowInvocationActionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryWorkflowInvocationActionsPagedResponse((QueryWorkflowInvocationActionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryWorkflowInvocationActionsPagedResponse(QueryWorkflowInvocationActionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryWorkflowInvocationActionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkflowInvocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation, ListWorkflowInvocationsPage, ListWorkflowInvocationsFixedSizeCollection> {
        private ListWorkflowInvocationsFixedSizeCollection(List<ListWorkflowInvocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkflowInvocationsFixedSizeCollection createEmptyCollection() {
            return new ListWorkflowInvocationsFixedSizeCollection(null, 0);
        }

        protected ListWorkflowInvocationsFixedSizeCollection createCollection(List<ListWorkflowInvocationsPage> pages, int collectionSize) {
            return new ListWorkflowInvocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkflowInvocationsPage
    extends AbstractPage<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation, ListWorkflowInvocationsPage> {
        private ListWorkflowInvocationsPage(PageContext<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation> context, ListWorkflowInvocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkflowInvocationsPage createEmptyPage() {
            return new ListWorkflowInvocationsPage(null, null);
        }

        protected ListWorkflowInvocationsPage createPage(PageContext<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation> context, ListWorkflowInvocationsResponse response) {
            return new ListWorkflowInvocationsPage(context, response);
        }

        public ApiFuture<ListWorkflowInvocationsPage> createPageAsync(PageContext<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation> context, ApiFuture<ListWorkflowInvocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkflowInvocationsPagedResponse
    extends AbstractPagedListResponse<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation, ListWorkflowInvocationsPage, ListWorkflowInvocationsFixedSizeCollection> {
        public static ApiFuture<ListWorkflowInvocationsPagedResponse> createAsync(PageContext<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation> context, ApiFuture<ListWorkflowInvocationsResponse> futureResponse) {
            ApiFuture<ListWorkflowInvocationsPage> futurePage = ListWorkflowInvocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkflowInvocationsPagedResponse((ListWorkflowInvocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkflowInvocationsPagedResponse(ListWorkflowInvocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkflowInvocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class QueryCompilationResultActionsFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction, QueryCompilationResultActionsPage, QueryCompilationResultActionsFixedSizeCollection> {
        private QueryCompilationResultActionsFixedSizeCollection(List<QueryCompilationResultActionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryCompilationResultActionsFixedSizeCollection createEmptyCollection() {
            return new QueryCompilationResultActionsFixedSizeCollection(null, 0);
        }

        protected QueryCompilationResultActionsFixedSizeCollection createCollection(List<QueryCompilationResultActionsPage> pages, int collectionSize) {
            return new QueryCompilationResultActionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryCompilationResultActionsPage
    extends AbstractPage<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction, QueryCompilationResultActionsPage> {
        private QueryCompilationResultActionsPage(PageContext<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction> context, QueryCompilationResultActionsResponse response) {
            super(context, (Object)response);
        }

        private static QueryCompilationResultActionsPage createEmptyPage() {
            return new QueryCompilationResultActionsPage(null, null);
        }

        protected QueryCompilationResultActionsPage createPage(PageContext<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction> context, QueryCompilationResultActionsResponse response) {
            return new QueryCompilationResultActionsPage(context, response);
        }

        public ApiFuture<QueryCompilationResultActionsPage> createPageAsync(PageContext<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction> context, ApiFuture<QueryCompilationResultActionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryCompilationResultActionsPagedResponse
    extends AbstractPagedListResponse<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction, QueryCompilationResultActionsPage, QueryCompilationResultActionsFixedSizeCollection> {
        public static ApiFuture<QueryCompilationResultActionsPagedResponse> createAsync(PageContext<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction> context, ApiFuture<QueryCompilationResultActionsResponse> futureResponse) {
            ApiFuture<QueryCompilationResultActionsPage> futurePage = QueryCompilationResultActionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryCompilationResultActionsPagedResponse((QueryCompilationResultActionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryCompilationResultActionsPagedResponse(QueryCompilationResultActionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryCompilationResultActionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCompilationResultsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult, ListCompilationResultsPage, ListCompilationResultsFixedSizeCollection> {
        private ListCompilationResultsFixedSizeCollection(List<ListCompilationResultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCompilationResultsFixedSizeCollection createEmptyCollection() {
            return new ListCompilationResultsFixedSizeCollection(null, 0);
        }

        protected ListCompilationResultsFixedSizeCollection createCollection(List<ListCompilationResultsPage> pages, int collectionSize) {
            return new ListCompilationResultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCompilationResultsPage
    extends AbstractPage<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult, ListCompilationResultsPage> {
        private ListCompilationResultsPage(PageContext<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult> context, ListCompilationResultsResponse response) {
            super(context, (Object)response);
        }

        private static ListCompilationResultsPage createEmptyPage() {
            return new ListCompilationResultsPage(null, null);
        }

        protected ListCompilationResultsPage createPage(PageContext<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult> context, ListCompilationResultsResponse response) {
            return new ListCompilationResultsPage(context, response);
        }

        public ApiFuture<ListCompilationResultsPage> createPageAsync(PageContext<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult> context, ApiFuture<ListCompilationResultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCompilationResultsPagedResponse
    extends AbstractPagedListResponse<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult, ListCompilationResultsPage, ListCompilationResultsFixedSizeCollection> {
        public static ApiFuture<ListCompilationResultsPagedResponse> createAsync(PageContext<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult> context, ApiFuture<ListCompilationResultsResponse> futureResponse) {
            ApiFuture<ListCompilationResultsPage> futurePage = ListCompilationResultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCompilationResultsPagedResponse((ListCompilationResultsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCompilationResultsPagedResponse(ListCompilationResultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCompilationResultsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class QueryDirectoryContentsFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, QueryDirectoryContentsResponse.DirectoryEntry, QueryDirectoryContentsPage, QueryDirectoryContentsFixedSizeCollection> {
        private QueryDirectoryContentsFixedSizeCollection(List<QueryDirectoryContentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryDirectoryContentsFixedSizeCollection createEmptyCollection() {
            return new QueryDirectoryContentsFixedSizeCollection(null, 0);
        }

        protected QueryDirectoryContentsFixedSizeCollection createCollection(List<QueryDirectoryContentsPage> pages, int collectionSize) {
            return new QueryDirectoryContentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryDirectoryContentsPage
    extends AbstractPage<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, QueryDirectoryContentsResponse.DirectoryEntry, QueryDirectoryContentsPage> {
        private QueryDirectoryContentsPage(PageContext<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, QueryDirectoryContentsResponse.DirectoryEntry> context, QueryDirectoryContentsResponse response) {
            super(context, (Object)response);
        }

        private static QueryDirectoryContentsPage createEmptyPage() {
            return new QueryDirectoryContentsPage(null, null);
        }

        protected QueryDirectoryContentsPage createPage(PageContext<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, QueryDirectoryContentsResponse.DirectoryEntry> context, QueryDirectoryContentsResponse response) {
            return new QueryDirectoryContentsPage(context, response);
        }

        public ApiFuture<QueryDirectoryContentsPage> createPageAsync(PageContext<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, QueryDirectoryContentsResponse.DirectoryEntry> context, ApiFuture<QueryDirectoryContentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryDirectoryContentsPagedResponse
    extends AbstractPagedListResponse<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, QueryDirectoryContentsResponse.DirectoryEntry, QueryDirectoryContentsPage, QueryDirectoryContentsFixedSizeCollection> {
        public static ApiFuture<QueryDirectoryContentsPagedResponse> createAsync(PageContext<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, QueryDirectoryContentsResponse.DirectoryEntry> context, ApiFuture<QueryDirectoryContentsResponse> futureResponse) {
            ApiFuture<QueryDirectoryContentsPage> futurePage = QueryDirectoryContentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryDirectoryContentsPagedResponse((QueryDirectoryContentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryDirectoryContentsPagedResponse(QueryDirectoryContentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryDirectoryContentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkspacesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkspacesRequest, ListWorkspacesResponse, Workspace, ListWorkspacesPage, ListWorkspacesFixedSizeCollection> {
        private ListWorkspacesFixedSizeCollection(List<ListWorkspacesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkspacesFixedSizeCollection createEmptyCollection() {
            return new ListWorkspacesFixedSizeCollection(null, 0);
        }

        protected ListWorkspacesFixedSizeCollection createCollection(List<ListWorkspacesPage> pages, int collectionSize) {
            return new ListWorkspacesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkspacesPage
    extends AbstractPage<ListWorkspacesRequest, ListWorkspacesResponse, Workspace, ListWorkspacesPage> {
        private ListWorkspacesPage(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ListWorkspacesResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkspacesPage createEmptyPage() {
            return new ListWorkspacesPage(null, null);
        }

        protected ListWorkspacesPage createPage(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ListWorkspacesResponse response) {
            return new ListWorkspacesPage(context, response);
        }

        public ApiFuture<ListWorkspacesPage> createPageAsync(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ApiFuture<ListWorkspacesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkspacesPagedResponse
    extends AbstractPagedListResponse<ListWorkspacesRequest, ListWorkspacesResponse, Workspace, ListWorkspacesPage, ListWorkspacesFixedSizeCollection> {
        public static ApiFuture<ListWorkspacesPagedResponse> createAsync(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ApiFuture<ListWorkspacesResponse> futureResponse) {
            ApiFuture<ListWorkspacesPage> futurePage = ListWorkspacesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkspacesPagedResponse((ListWorkspacesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkspacesPagedResponse(ListWorkspacesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkspacesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRepositoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        private ListRepositoriesFixedSizeCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRepositoriesFixedSizeCollection createEmptyCollection() {
            return new ListRepositoriesFixedSizeCollection(null, 0);
        }

        protected ListRepositoriesFixedSizeCollection createCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            return new ListRepositoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRepositoriesPage
    extends AbstractPage<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage> {
        private ListRepositoriesPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListRepositoriesPage createEmptyPage() {
            return new ListRepositoriesPage(null, null);
        }

        protected ListRepositoriesPage createPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            return new ListRepositoriesPage(context, response);
        }

        public ApiFuture<ListRepositoriesPage> createPageAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRepositoriesPagedResponse
    extends AbstractPagedListResponse<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        public static ApiFuture<ListRepositoriesPagedResponse> createAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            ApiFuture<ListRepositoriesPage> futurePage = ListRepositoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRepositoriesPagedResponse((ListRepositoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRepositoriesPagedResponse(ListRepositoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRepositoriesFixedSizeCollection.createEmptyCollection());
        }
    }
}

