/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.Batch;
import com.google.cloud.dataproc.v1.BatchControllerClient;
import com.google.cloud.dataproc.v1.BatchOperationMetadata;
import com.google.cloud.dataproc.v1.CreateBatchRequest;
import com.google.cloud.dataproc.v1.DeleteBatchRequest;
import com.google.cloud.dataproc.v1.GetBatchRequest;
import com.google.cloud.dataproc.v1.ListBatchesRequest;
import com.google.cloud.dataproc.v1.ListBatchesResponse;
import com.google.cloud.dataproc.v1.stub.BatchControllerStub;
import com.google.cloud.dataproc.v1.stub.BatchControllerStubSettings;
import com.google.cloud.dataproc.v1.stub.HttpJsonBatchControllerCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonBatchControllerStub
extends BatchControllerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Batch.getDescriptor()).add(BatchOperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateBatchRequest, Operation> createBatchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.BatchController/CreateBatch").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/batches", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "batchId", (Object)request.getBatchId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("batch", (Message)request.getBatch(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetBatchRequest, Batch> getBatchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.BatchController/GetBatch").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/batches/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Batch.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListBatchesRequest, ListBatchesResponse> listBatchesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.BatchController/ListBatches").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/batches", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBatchesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteBatchRequest, Empty> deleteBatchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.BatchController/DeleteBatch").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/batches/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateBatchRequest, Operation> createBatchCallable;
    private final OperationCallable<CreateBatchRequest, Batch, BatchOperationMetadata> createBatchOperationCallable;
    private final UnaryCallable<GetBatchRequest, Batch> getBatchCallable;
    private final UnaryCallable<ListBatchesRequest, ListBatchesResponse> listBatchesCallable;
    private final UnaryCallable<ListBatchesRequest, BatchControllerClient.ListBatchesPagedResponse> listBatchesPagedCallable;
    private final UnaryCallable<DeleteBatchRequest, Empty> deleteBatchCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonBatchControllerStub create(BatchControllerStubSettings settings) throws IOException {
        return new HttpJsonBatchControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonBatchControllerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonBatchControllerStub(BatchControllerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonBatchControllerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonBatchControllerStub(BatchControllerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonBatchControllerStub(BatchControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonBatchControllerCallableFactory());
    }

    protected HttpJsonBatchControllerStub(BatchControllerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings createBatchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createBatchMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getBatchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBatchMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listBatchesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBatchesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteBatchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteBatchMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createBatchCallable = callableFactory.createUnaryCallable(createBatchTransportSettings, settings.createBatchSettings(), clientContext);
        this.createBatchOperationCallable = callableFactory.createOperationCallable(createBatchTransportSettings, settings.createBatchOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getBatchCallable = callableFactory.createUnaryCallable(getBatchTransportSettings, settings.getBatchSettings(), clientContext);
        this.listBatchesCallable = callableFactory.createUnaryCallable(listBatchesTransportSettings, settings.listBatchesSettings(), clientContext);
        this.listBatchesPagedCallable = callableFactory.createPagedCallable(listBatchesTransportSettings, settings.listBatchesSettings(), clientContext);
        this.deleteBatchCallable = callableFactory.createUnaryCallable(deleteBatchTransportSettings, settings.deleteBatchSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createBatchMethodDescriptor);
        methodDescriptors.add(getBatchMethodDescriptor);
        methodDescriptors.add(listBatchesMethodDescriptor);
        methodDescriptors.add(deleteBatchMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateBatchRequest, Operation> createBatchCallable() {
        return this.createBatchCallable;
    }

    @Override
    public OperationCallable<CreateBatchRequest, Batch, BatchOperationMetadata> createBatchOperationCallable() {
        return this.createBatchOperationCallable;
    }

    @Override
    public UnaryCallable<GetBatchRequest, Batch> getBatchCallable() {
        return this.getBatchCallable;
    }

    @Override
    public UnaryCallable<ListBatchesRequest, ListBatchesResponse> listBatchesCallable() {
        return this.listBatchesCallable;
    }

    @Override
    public UnaryCallable<ListBatchesRequest, BatchControllerClient.ListBatchesPagedResponse> listBatchesPagedCallable() {
        return this.listBatchesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteBatchRequest, Empty> deleteBatchCallable() {
        return this.deleteBatchCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

