/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.debugger.v2;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.debugger.v2.Controller2Settings;
import com.google.cloud.debugger.v2.stub.Controller2Stub;
import com.google.cloud.debugger.v2.stub.Controller2StubSettings;
import com.google.devtools.clouddebugger.v2.Breakpoint;
import com.google.devtools.clouddebugger.v2.Debuggee;
import com.google.devtools.clouddebugger.v2.ListActiveBreakpointsRequest;
import com.google.devtools.clouddebugger.v2.ListActiveBreakpointsResponse;
import com.google.devtools.clouddebugger.v2.RegisterDebuggeeRequest;
import com.google.devtools.clouddebugger.v2.RegisterDebuggeeResponse;
import com.google.devtools.clouddebugger.v2.UpdateActiveBreakpointRequest;
import com.google.devtools.clouddebugger.v2.UpdateActiveBreakpointResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class Controller2Client
implements BackgroundResource {
    private final Controller2Settings settings;
    private final Controller2Stub stub;

    public static final Controller2Client create() throws IOException {
        return Controller2Client.create(Controller2Settings.newBuilder().build());
    }

    public static final Controller2Client create(Controller2Settings settings) throws IOException {
        return new Controller2Client(settings);
    }

    public static final Controller2Client create(Controller2Stub stub) {
        return new Controller2Client(stub);
    }

    protected Controller2Client(Controller2Settings settings) throws IOException {
        this.settings = settings;
        this.stub = ((Controller2StubSettings)settings.getStubSettings()).createStub();
    }

    protected Controller2Client(Controller2Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final Controller2Settings getSettings() {
        return this.settings;
    }

    public Controller2Stub getStub() {
        return this.stub;
    }

    public final RegisterDebuggeeResponse registerDebuggee(Debuggee debuggee) {
        RegisterDebuggeeRequest request = RegisterDebuggeeRequest.newBuilder().setDebuggee(debuggee).build();
        return this.registerDebuggee(request);
    }

    public final RegisterDebuggeeResponse registerDebuggee(RegisterDebuggeeRequest request) {
        return (RegisterDebuggeeResponse)this.registerDebuggeeCallable().call((Object)request);
    }

    public final UnaryCallable<RegisterDebuggeeRequest, RegisterDebuggeeResponse> registerDebuggeeCallable() {
        return this.stub.registerDebuggeeCallable();
    }

    public final ListActiveBreakpointsResponse listActiveBreakpoints(String debuggeeId) {
        ListActiveBreakpointsRequest request = ListActiveBreakpointsRequest.newBuilder().setDebuggeeId(debuggeeId).build();
        return this.listActiveBreakpoints(request);
    }

    public final ListActiveBreakpointsResponse listActiveBreakpoints(ListActiveBreakpointsRequest request) {
        return (ListActiveBreakpointsResponse)this.listActiveBreakpointsCallable().call((Object)request);
    }

    public final UnaryCallable<ListActiveBreakpointsRequest, ListActiveBreakpointsResponse> listActiveBreakpointsCallable() {
        return this.stub.listActiveBreakpointsCallable();
    }

    public final UpdateActiveBreakpointResponse updateActiveBreakpoint(String debuggeeId, Breakpoint breakpoint) {
        UpdateActiveBreakpointRequest request = UpdateActiveBreakpointRequest.newBuilder().setDebuggeeId(debuggeeId).setBreakpoint(breakpoint).build();
        return this.updateActiveBreakpoint(request);
    }

    public final UpdateActiveBreakpointResponse updateActiveBreakpoint(UpdateActiveBreakpointRequest request) {
        return (UpdateActiveBreakpointResponse)this.updateActiveBreakpointCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateActiveBreakpointRequest, UpdateActiveBreakpointResponse> updateActiveBreakpointCallable() {
        return this.stub.updateActiveBreakpointCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

